/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsTestModuleProperties;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.ImportTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.KotlinJpsBundle;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.KotlinIncludedModuleSourceRoot;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesDiff;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManagerKt;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManager;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.LocalKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0006\u0090\u0001\u0091\u0001\u0092\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u000e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u000fJ\u001c\u0010S\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020L0K2\u0006\u0010R\u001a\u00020\u000fH\u0002J\u000e\u0010T\u001a\u00020\u001d2\u0006\u0010U\u001a\u000207J\n\u0010Z\u001a\u00020\u0019H\u0096\u0080\u0004J*\u0010[\u001a\u00020\u001d2\u0006\u0010\\\u001a\u00020\"2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\b\u0010a\u001a\u0004\u0018\u00010bH&J\u001e\u0010c\u001a\u00020Q2\u0006\u0010d\u001a\u00020e2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020g0=H\u0016J\u0010\u0010h\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020`H\u0004J\b\u0010i\u001a\u00020QH\u0016J\u0010\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020oH&JZ\u0010p\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020q2\u0006\u0010]\u001a\u00020^2\u0018\u0010f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020g0r0K2\u0016\u0010s\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0000\u0012\u0004\u0012\u00020m0K2\u0006\u0010_\u001a\u00020`H\u0016J6\u0010t\u001a\u00020Q2\u0006\u0010]\u001a\u00020^2\u0006\u0010u\u001a\u00020m2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020g0=2\u0006\u0010w\u001a\u00020x2\u0006\u0010_\u001a\u00020`H\u0016JV\u0010y\u001a\u00020Q2\u0006\u0010z\u001a\u00020{2\u0016\u0010s\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0000\u0012\u0004\u0012\u00020m0K2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007f2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0016J\u001c\u0010\u0086\u0001\u001a\r0\u0087\u0001R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010]\u001a\u00020^H\u0004J\u0018\u0010\u008d\u0001\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0007\u0010\u008e\u0001\u001a\u00020\"J\u0011\u0010\u008f\u0001\u001a\u00020Q2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0011\u0010\u008f\u0001\u001a\u00020Q2\u0006\u0010\u0012\u001a\u00020qH\u0002J\u001b\u0010\u008f\u0001\u001a\u00020Q2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000=H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0017\u0010#\u001a\u00020$\u00a2\u0006\u000e\n\u0000\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0015\u0010)\u001a\u0006\u0012\u0002\b\u00030*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001eR\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001b\u00106\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b8\u00109R\u001b\u0010<\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u0002070=8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010?R\u0016\u0010B\u001a\u0004\u0018\u00010.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u00100R \u0010D\u001a\u00070E\u00a2\u0006\u0002\bF8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010;\u001a\u0004\bG\u0010HR\u001d\u0010J\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020L0K8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR \u0010O\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020L0K0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010V\u001a\b\u0012\u0004\u0012\u0002070W8F\u00a2\u0006\u0006\u001a\u0004\bX\u0010YR\u0014\u0010j\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\u001eR\u0014\u0010\u0088\u0001\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0089\u0001\u0010\u001bR\u0015\u0010\u008a\u0001\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\b\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001\u00a8\u0006\u0093\u0001"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "BuildMetaInfoType", "Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "", "kotlinContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "<init>", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "getKotlinContext", "()Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "getJpsModuleBuildTarget", "()Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "jpsGlobalContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "getJpsGlobalContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "getChunk", "()Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "setChunk", "(Lorg/jetbrains/kotlin/jps/build/KotlinChunk;)V", "globalLookupCacheId", "", "getGlobalLookupCacheId", "()Ljava/lang/String;", "isIncrementalCompilationEnabled", "", "()Z", "isEnabled", "chunkCompilerArguments", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "localCacheVersionManager", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "getLocalCacheVersionManager$annotations", "()V", "getLocalCacheVersionManager", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "initialLocalCacheAttributesDiff", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesDiff;", "getInitialLocalCacheAttributesDiff", "()Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesDiff;", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "getModule", "()Lorg/jetbrains/jps/model/module/JpsModule;", "isTests", "targetId", "Lorg/jetbrains/kotlin/modules/TargetId;", "getTargetId", "()Lorg/jetbrains/kotlin/modules/TargetId;", "outputDir", "Ljava/io/File;", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "Lkotlin/Lazy;", "friendBuildTargets", "", "getFriendBuildTargets", "()Ljava/util/List;", "friendOutputDirs", "getFriendOutputDirs", "relatedProductionModule", "getRelatedProductionModule", "allDependencies", "Lorg/jetbrains/jps/model/java/JpsJavaDependenciesEnumerator;", "Lorg/jetbrains/annotations/NotNull;", "getAllDependencies", "()Lorg/jetbrains/jps/model/java/JpsJavaDependenciesEnumerator;", "allDependencies$delegate", "sources", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "getSources", "()Ljava/util/Map;", "_sources", "nextRound", "", "localContext", "computeSourcesList", "isFromIncludedSourceRoot", "file", "sourceFiles", "", "getSourceFiles", "()Ljava/util/Collection;", "toString", "compileModuleChunk", "commonArguments", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "buildMetricReporter", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "registerOutputItems", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "outputItems", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "reportAndSkipCircular", "doAfterBuild", "hasCaches", "getHasCaches", "createCacheStorage", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "updateChunkMappings", "Lorg/jetbrains/jps/ModuleChunk;", "", "incrementalCaches", "updateCaches", "jpsIncrementalCache", "files", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "makeServices", "builder", "Lorg/jetbrains/kotlin/config/Services$Builder;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "enumWhenTracker", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "importTracker", "Lorg/jetbrains/kotlin/incremental/components/ImportTracker;", "collectSourcesToCompile", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$SourcesToCompile;", "compilerArgumentsFileName", "getCompilerArgumentsFileName", "buildMetaInfo", "getBuildMetaInfo", "()Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "isVersionChanged", "compilerArguments", "checkRepresentativeTarget", "Dependency", "Source", "SourcesToCompile", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinModuleBuildTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleBuildTarget.kt\norg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,375:1\n777#2:376\n873#2,2:377\n1642#2,10:379\n1915#2:389\n1916#2:391\n1652#2:392\n1661#2,3:393\n1915#2:396\n1916#2:399\n1586#2:400\n1661#2,3:401\n1#3:390\n1#3:404\n1342#4,2:397\n*S KotlinDebug\n*F\n+ 1 KotlinModuleBuildTarget.kt\norg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget\n*L\n113#1:376\n113#1:377,2\n117#1:379,10\n117#1:389\n117#1:391\n117#1:392\n161#1:393,3\n169#1:396\n169#1:399\n212#1:400\n212#1:401,3\n117#1:390\n174#1:397,2\n*E\n"})
public abstract class KotlinModuleBuildTarget<BuildMetaInfoType extends BuildMetaInfo> {
    @NotNull
    private final KotlinCompileContext kotlinContext;
    @NotNull
    private final ModuleBuildTarget jpsModuleBuildTarget;
    public KotlinChunk chunk;
    @NotNull
    private final CacheVersionManager localCacheVersionManager;
    @NotNull
    private final CacheAttributesDiff<?> initialLocalCacheAttributesDiff;
    @NotNull
    private final Lazy outputDir$delegate;
    @NotNull
    private final Lazy allDependencies$delegate;
    @NotNull
    private volatile Lazy<? extends Map<File, Source>> _sources;
    private final boolean hasCaches;

    public KotlinModuleBuildTarget(@NotNull KotlinCompileContext kotlinContext, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkNotNullParameter((Object)kotlinContext, (String)"kotlinContext");
        Intrinsics.checkNotNullParameter((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        this.kotlinContext = kotlinContext;
        this.jpsModuleBuildTarget = jpsModuleBuildTarget;
        Path path = this.kotlinContext.getDataPaths().getTargetDataRoot((BuildTarget)this.jpsModuleBuildTarget).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        this.localCacheVersionManager = LocalKt.localCacheVersionManager(path, this.isIncrementalCompilationEnabled());
        this.initialLocalCacheAttributesDiff = CacheAttributesManagerKt.loadDiff$default(this.localCacheVersionManager, null, null, 3, null);
        this.outputDir$delegate = LazyKt.lazy(() -> KotlinModuleBuildTarget.outputDir_delegate$lambda$0(this));
        this.allDependencies$delegate = LazyKt.lazy(() -> KotlinModuleBuildTarget.allDependencies_delegate$lambda$0(this));
        this._sources = LazyKt.lazy(() -> KotlinModuleBuildTarget._sources$lambda$0(this));
        this.hasCaches = true;
    }

    @NotNull
    public final KotlinCompileContext getKotlinContext() {
        return this.kotlinContext;
    }

    @NotNull
    public final ModuleBuildTarget getJpsModuleBuildTarget() {
        return this.jpsModuleBuildTarget;
    }

    @NotNull
    public final CompileContext getJpsGlobalContext() {
        return this.kotlinContext.getJpsContext();
    }

    @NotNull
    public final KotlinChunk getChunk() {
        KotlinChunk kotlinChunk = this.chunk;
        if (kotlinChunk != null) {
            return kotlinChunk;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chunk");
        return null;
    }

    public final void setChunk(@NotNull KotlinChunk kotlinChunk) {
        Intrinsics.checkNotNullParameter((Object)kotlinChunk, (String)"<set-?>");
        this.chunk = kotlinChunk;
    }

    @NotNull
    public abstract String getGlobalLookupCacheId();

    public abstract boolean isIncrementalCompilationEnabled();

    public boolean isEnabled(@NotNull Lazy<? extends CommonCompilerArguments> chunkCompilerArguments) {
        Intrinsics.checkNotNullParameter(chunkCompilerArguments, (String)"chunkCompilerArguments");
        return true;
    }

    @NotNull
    public final CacheVersionManager getLocalCacheVersionManager() {
        return this.localCacheVersionManager;
    }

    public static /* synthetic */ void getLocalCacheVersionManager$annotations() {
    }

    @NotNull
    public final CacheAttributesDiff<?> getInitialLocalCacheAttributesDiff() {
        return this.initialLocalCacheAttributesDiff;
    }

    @NotNull
    public final JpsModule getModule() {
        JpsModule jpsModule = this.jpsModuleBuildTarget.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"getModule(...)");
        return jpsModule;
    }

    public final boolean isTests() {
        return this.jpsModuleBuildTarget.isTests();
    }

    @NotNull
    public TargetId getTargetId() {
        Object object = this.getRelatedProductionModule();
        if (object == null || (object = object.getName()) == null) {
            String string = this.jpsModuleBuildTarget.getId();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        }
        Object name2 = object;
        String string = this.jpsModuleBuildTarget.getTargetType().getTypeId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeId(...)");
        return new TargetId((String)name2, string);
    }

    @NotNull
    public final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinModuleBuildTarget<?>> getFriendBuildTargets() {
        void $this$filterTo$iv$iv;
        List result2 = new ArrayList();
        if (this.isTests()) {
            CollectionsKt.addIfNotNull(result2, this.kotlinContext.getTargetsBinding().get(JpsUtilKt.getProductionBuildTarget(this.getModule())));
            Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map = this.kotlinContext.getTargetsBinding();
            JpsModule jpsModule = this.getRelatedProductionModule();
            CollectionsKt.addIfNotNull(result2, map.get(jpsModule != null ? JpsUtilKt.getProductionBuildTarget(jpsModule) : null));
        }
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !it.getSources().isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getFriendOutputDirs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getFriendBuildTargets();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            File it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv$iv;
            boolean bl2 = false;
            if (JpsJavaExtensionService.getInstance().getOutputDirectory(it.getModule(), false) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final JpsModule getRelatedProductionModule() {
        JpsTestModuleProperties jpsTestModuleProperties = JpsJavaExtensionService.getInstance().getTestModuleProperties(this.getModule());
        return jpsTestModuleProperties != null ? jpsTestModuleProperties.getProductionModule() : null;
    }

    @NotNull
    public final JpsJavaDependenciesEnumerator getAllDependencies() {
        Lazy lazy = this.allDependencies$delegate;
        return (JpsJavaDependenciesEnumerator)lazy.getValue();
    }

    @NotNull
    public final Map<File, Source> getSources() {
        return (Map)this._sources.getValue();
    }

    public final void nextRound(@NotNull CompileContext localContext) {
        Intrinsics.checkNotNullParameter((Object)localContext, (String)"localContext");
        this._sources = LazyKt.lazy(() -> KotlinModuleBuildTarget.nextRound$lambda$0(this, localContext));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, Source> computeSourcesList(CompileContext localContext) {
        void $this$mapTo$iv;
        Map result2 = new LinkedHashMap();
        List list = this.getModule().getExcludeRootsList().getUrls();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUrls(...)");
        Iterable iterable = list;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(JpsPathUtil.urlToFile((String)p0));
        }
        HashSet moduleExcludes = (HashSet)destination$iv;
        JpsCompilerExcludes jpsCompilerExcludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.getModule().getProject()).getCompilerExcludes();
        Intrinsics.checkNotNullExpressionValue((Object)jpsCompilerExcludes, (String)"getCompilerExcludes(...)");
        JpsCompilerExcludes compilerExcludes = jpsCompilerExcludes;
        BuildRootIndex buildRootIndex = localContext.getProjectDescriptor().getBuildRootIndex();
        List list2 = buildRootIndex.getTargetRoots((BuildTarget)this.jpsModuleBuildTarget, localContext);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTargetRoots(...)");
        List roots = list2;
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            JavaSourceRootDescriptor rootDescriptor = (JavaSourceRootDescriptor)element$iv;
            boolean bl = false;
            boolean isCrossCompiled = rootDescriptor instanceof KotlinIncludedModuleSourceRoot;
            File file = rootDescriptor.root;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root");
            Sequence sequence2 = (Sequence)FilesKt.walkTopDown((File)file).onEnter(arg_0 -> KotlinModuleBuildTarget.computeSourcesList$lambda$0$0(moduleExcludes, arg_0));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File file2 = (File)element$iv2;
                boolean bl2 = false;
                if (compilerExcludes.isExcluded(file2) || !file2.isFile() || !KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file2)) continue;
                result2.put(file2, new Source(file2, isCrossCompiled));
            }
        }
        return result2;
    }

    public final boolean isFromIncludedSourceRoot(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Source source = this.getSources().get(file);
        return source != null ? source.isCrossCompiled() : false;
    }

    @NotNull
    public final Collection<File> getSourceFiles() {
        return this.getSources().keySet();
    }

    @NotNull
    public String toString() {
        String string = this.jpsModuleBuildTarget.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public abstract boolean compileModuleChunk(@NotNull CommonCompilerArguments var1, @NotNull KotlinDirtySourceFilesHolder var2, @NotNull JpsCompilerEnvironment var3, @Nullable JpsBuilderMetricReporter var4);

    /*
     * WARNING - void declaration
     */
    public void registerOutputItems(@NotNull ModuleLevelBuilder.OutputConsumer outputConsumer, @NotNull List<? extends GeneratedFile> outputItems) {
        Intrinsics.checkNotNullParameter((Object)outputConsumer, (String)"outputConsumer");
        Intrinsics.checkNotNullParameter(outputItems, (String)"outputItems");
        for (GeneratedFile generatedFile : outputItems) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = generatedFile.getSourceFiles();
            File file = generatedFile.getOutputFile();
            BuildTarget buildTarget = (BuildTarget)this.jpsModuleBuildTarget;
            ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            collection = (List)destination$iv$iv;
            outputConsumer2.registerOutputFile(buildTarget, file, (Collection)collection);
        }
    }

    protected final boolean reportAndSkipCircular(@NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (this.getChunk().getTargets().size() > 1) {
            MessageCollector.report$default(environment.getMessageCollector(), CompilerMessageSeverity.STRONG_WARNING, "Circular dependencies are not supported. The following modules depend on each other: " + this.getChunk().getPresentableShortName() + " Kotlin is not compiled for these modules", null, 4, null);
            return true;
        }
        return false;
    }

    public void doAfterBuild() {
    }

    public boolean getHasCaches() {
        return this.hasCaches;
    }

    @NotNull
    public abstract JpsIncrementalCache createCacheStorage(@NotNull BuildDataPaths var1);

    public void updateChunkMappings(@NotNull CompileContext localContext, @NotNull ModuleChunk chunk, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull Map<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>> outputItems, @NotNull Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)localContext, (String)"localContext");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter(outputItems, (String)"outputItems");
        Intrinsics.checkNotNullParameter(incrementalCaches, (String)"incrementalCaches");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
    }

    public void updateCaches(@NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsIncrementalCache jpsIncrementalCache, @NotNull List<? extends GeneratedFile> files2, @NotNull ChangesCollector changesCollector, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)jpsIncrementalCache, (String)"jpsIncrementalCache");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Set changedAndRemovedFiles = SetsKt.plus(dirtyFilesHolder2.getDirtyFiles(this.jpsModuleBuildTarget).keySet(), (Iterable)dirtyFilesHolder2.getRemovedFiles(this.jpsModuleBuildTarget));
        ExpectActualTracker expectActualTracker = environment.getServices().get(ExpectActualTracker.class);
        Intrinsics.checkNotNull((Object)expectActualTracker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl");
        ExpectActualTrackerImpl expectActualTracker2 = (ExpectActualTrackerImpl)expectActualTracker;
        jpsIncrementalCache.updateComplementaryFiles(changedAndRemovedFiles, expectActualTracker2);
    }

    public void makeServices(@NotNull Services.Builder builder, @NotNull Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @NotNull ExpectActualTracker exceptActualTracer, @NotNull InlineConstTracker inlineConstTracker, @NotNull EnumWhenTracker enumWhenTracker, @NotNull ImportTracker importTracker) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(incrementalCaches, (String)"incrementalCaches");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter((Object)exceptActualTracer, (String)"exceptActualTracer");
        Intrinsics.checkNotNullParameter((Object)inlineConstTracker, (String)"inlineConstTracker");
        Intrinsics.checkNotNullParameter((Object)enumWhenTracker, (String)"enumWhenTracker");
        Intrinsics.checkNotNullParameter((Object)importTracker, (String)"importTracker");
        Services.Builder $this$makeServices_u24lambda_u240 = builder;
        boolean bl = false;
        $this$makeServices_u24lambda_u240.register(LookupTracker.class, lookupTracker);
        $this$makeServices_u24lambda_u240.register(ExpectActualTracker.class, exceptActualTracer);
        $this$makeServices_u24lambda_u240.register(CompilationCanceledStatus.class, new CompilationCanceledStatus(this){
            final /* synthetic */ KotlinModuleBuildTarget<BuildMetaInfoType> this$0;
            {
                this.this$0 = $receiver;
            }

            public void checkCanceled() {
                if (this.this$0.getJpsGlobalContext().getCancelStatus().isCanceled()) {
                    throw new CompilationCanceledException();
                }
            }
        });
        $this$makeServices_u24lambda_u240.register(InlineConstTracker.class, inlineConstTracker);
        $this$makeServices_u24lambda_u240.register(EnumWhenTracker.class, enumWhenTracker);
        $this$makeServices_u24lambda_u240.register(ImportTracker.class, importTracker);
    }

    @NotNull
    protected final SourcesToCompile collectSourcesToCompile(@NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2) {
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        return new SourcesToCompile(this.getChunk().getRepresentativeTarget().isIncrementalCompilationEnabled() ? dirtyFilesHolder2.getDirtyFiles(this.jpsModuleBuildTarget).values() : this.getSources().values(), dirtyFilesHolder2.getRemovedFiles(this.jpsModuleBuildTarget));
    }

    @NotNull
    public abstract String getCompilerArgumentsFileName();

    @NotNull
    public abstract BuildMetaInfoType getBuildMetaInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isVersionChanged(@NotNull KotlinChunk chunk, @NotNull CommonCompilerArguments compilerArguments) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Map<String, String> currentCompilerArgumentsMap = ((BuildMetaInfo)this.getBuildMetaInfo()).createPropertiesMapFromCompilerArguments(compilerArguments);
        Path file = chunk.compilerArgumentsFile(this.jpsModuleBuildTarget);
        if (Files.notExists(file, new LinkOption[0])) {
            return false;
        }
        try {
            BuildMetaInfoType BuildMetaInfoType = this.getBuildMetaInfo();
            InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            object = inputStream;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
            int n = 8192;
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            BuildMetaInfoType BuildMetaInfoType2 = BuildMetaInfoType;
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl2 = false;
                object3 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = ((BuildMetaInfo)BuildMetaInfoType2).deserializeMapFromString((String)object3);
        }
        catch (Exception e) {
            KotlinBuilder.Companion.getLOG().error("Could not deserialize previous compiler arguments info", (Throwable)e);
            return false;
        }
        Object previousCompilerArgsMap = object;
        String rebuildReason = ((BuildMetaInfo)this.getBuildMetaInfo()).obtainReasonForRebuild(currentCompilerArgumentsMap, (Map<String, String>)previousCompilerArgsMap);
        if (rebuildReason != null) {
            KotlinModuleBuildTarget.isVersionChanged$printReasonToRebuild(rebuildReason);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkRepresentativeTarget(KotlinChunk chunk) {
        if (!Intrinsics.areEqual(chunk.getRepresentativeTarget(), (Object)this)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final void checkRepresentativeTarget(ModuleChunk chunk) {
        if (!Intrinsics.areEqual((Object)chunk.representativeTarget(), (Object)this.jpsModuleBuildTarget)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final void checkRepresentativeTarget(List<? extends KotlinModuleBuildTarget<?>> chunk) {
        if (!Intrinsics.areEqual((Object)kotlin.collections.CollectionsKt.first(chunk), (Object)this)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private static final File outputDir_delegate$lambda$0(KotlinModuleBuildTarget this$0) {
        File explicitOutputDir;
        File file;
        File file2;
        String explicitOutputPath;
        String string = explicitOutputPath = this$0.isTests() ? ModuleSettingsKt.getTestOutputFilePath(this$0.getModule()) : ModuleSettingsKt.getProductionOutputFilePath(this$0.getModule());
        if (string != null) {
            String it = string;
            boolean bl = false;
            file2 = new File(it).getAbsoluteFile().getParentFile();
        } else {
            file2 = null;
        }
        if ((file = (explicitOutputDir = file2)) == null && (file = this$0.jpsModuleBuildTarget.getOutputDir()) == null) {
            Object[] objectArray = new Object[]{this$0};
            throw new ProjectBuildException(KotlinJpsBundle.message("error.message.no.output.directory.found.for.0", objectArray));
        }
        return file;
    }

    private static final JpsJavaDependenciesEnumerator allDependencies_delegate$lambda$0(KotlinModuleBuildTarget this$0) {
        return JpsJavaExtensionService.dependencies((JpsModule)this$0.getModule()).recursively().exportedOnly().includedIn(JpsJavaClasspathKind.compile((boolean)this$0.isTests()));
    }

    private static final Map _sources$lambda$0(KotlinModuleBuildTarget this$0) {
        return this$0.computeSourcesList(this$0.getJpsGlobalContext());
    }

    private static final Map nextRound$lambda$0(KotlinModuleBuildTarget this$0, CompileContext $localContext) {
        return this$0.computeSourcesList($localContext);
    }

    private static final boolean computeSourcesList$lambda$0$0(HashSet $moduleExcludes, File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !$moduleExcludes.contains(file);
    }

    private static final void isVersionChanged$printReasonToRebuild(String reasonToRebuild) {
        KotlinBuilder.Companion.getLOG().info(reasonToRebuild + ". Performing non-incremental rebuild (kotlin only)");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J/\u0010\u0011\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "", "src", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "target", "exported", "", "<init>", "(Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;Z)V", "getSrc", "()Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTarget", "getExported", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "jps-plugin"})
    public static final class Dependency {
        @NotNull
        private final KotlinModuleBuildTarget<?> src;
        @NotNull
        private final KotlinModuleBuildTarget<?> target;
        private final boolean exported;

        public Dependency(@NotNull KotlinModuleBuildTarget<?> src, @NotNull KotlinModuleBuildTarget<?> target, boolean exported) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            this.src = src;
            this.target = target;
            this.exported = exported;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> getSrc() {
            return this.src;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> getTarget() {
            return this.target;
        }

        public final boolean getExported() {
            return this.exported;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> component1() {
            return this.src;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> component2() {
            return this.target;
        }

        public final boolean component3() {
            return this.exported;
        }

        @NotNull
        public final Dependency copy(@NotNull KotlinModuleBuildTarget<?> src, @NotNull KotlinModuleBuildTarget<?> target, boolean exported) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            return new Dependency(src, target, exported);
        }

        public static /* synthetic */ Dependency copy$default(Dependency dependency, KotlinModuleBuildTarget kotlinModuleBuildTarget, KotlinModuleBuildTarget kotlinModuleBuildTarget2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                kotlinModuleBuildTarget = dependency.src;
            }
            if ((n & 2) != 0) {
                kotlinModuleBuildTarget2 = dependency.target;
            }
            if ((n & 4) != 0) {
                bl = dependency.exported;
            }
            return dependency.copy(kotlinModuleBuildTarget, kotlinModuleBuildTarget2, bl);
        }

        @NotNull
        public String toString() {
            return "Dependency(src=" + this.src + ", target=" + this.target + ", exported=" + this.exported + ')';
        }

        public int hashCode() {
            int result2 = this.src.hashCode();
            result2 = result2 * 31 + this.target.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.exported);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Dependency)) {
                return false;
            }
            Dependency dependency = (Dependency)other;
            if (!Intrinsics.areEqual(this.src, dependency.src)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.target, dependency.target)) {
                return false;
            }
            return this.exported == dependency.exported;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "", "file", "Ljava/io/File;", "isCrossCompiled", "", "<init>", "(Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "()Z", "jps-plugin"})
    public static final class Source {
        @NotNull
        private final File file;
        private final boolean isCrossCompiled;

        public Source(@NotNull File file, boolean isCrossCompiled) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.isCrossCompiled = isCrossCompiled;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final boolean isCrossCompiled() {
            return this.isCrossCompiled;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$SourcesToCompile;", "", "sources", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "removedFiles", "Ljava/io/File;", "<init>", "(Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;Ljava/util/Collection;Ljava/util/Collection;)V", "getRemovedFiles", "()Ljava/util/Collection;", "allFiles", "", "getAllFiles", "()Ljava/util/List;", "crossCompiledFiles", "getCrossCompiledFiles", "logFiles", "", "jps-plugin"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleBuildTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleBuildTarget.kt\norg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$SourcesToCompile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,375:1\n1586#2:376\n1661#2,3:377\n777#2:380\n873#2,2:381\n1586#2:383\n1661#2,3:384\n*S KotlinDebug\n*F\n+ 1 KotlinModuleBuildTarget.kt\norg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$SourcesToCompile\n*L\n311#1:376\n311#1:377,3\n312#1:380\n312#1:381,2\n312#1:383\n312#1:384,3\n*E\n"})
    public final class SourcesToCompile {
        @NotNull
        private final Collection<File> removedFiles;
        @NotNull
        private final List<File> allFiles;
        @NotNull
        private final List<File> crossCompiledFiles;

        /*
         * WARNING - void declaration
         */
        public SourcesToCompile(@NotNull Collection<Source> sources, Collection<? extends File> removedFiles) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Source it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Intrinsics.checkNotNullParameter(removedFiles, (String)"removedFiles");
            this.removedFiles = removedFiles;
            Iterable iterable = sources;
            SourcesToCompile sourcesToCompile = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Source source = (Source)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFile());
            }
            sourcesToCompile.allFiles = (List)destination$iv$iv;
            $this$map$iv = sources;
            sourcesToCompile = this;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Source)element$iv$iv;
                boolean bl = false;
                if (!it.isCrossCompiled()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Source)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFile());
            }
            sourcesToCompile.crossCompiledFiles = (List)destination$iv$iv;
        }

        @NotNull
        public final Collection<File> getRemovedFiles() {
            return this.removedFiles;
        }

        @NotNull
        public final List<File> getAllFiles() {
            return this.allFiles;
        }

        @NotNull
        public final List<File> getCrossCompiledFiles() {
            return this.crossCompiledFiles;
        }

        public final boolean logFiles() {
            boolean hasDirtyOrRemovedSources;
            boolean hasRemovedSources = !this.removedFiles.isEmpty();
            boolean bl = hasDirtyOrRemovedSources = !((Collection)this.allFiles).isEmpty() || hasRemovedSources;
            if (hasDirtyOrRemovedSources) {
                ProjectBuilderLogger projectBuilderLogger = KotlinModuleBuildTarget.this.getJpsGlobalContext().getLoggingManager().getProjectBuilderLogger();
                Intrinsics.checkNotNullExpressionValue((Object)projectBuilderLogger, (String)"getProjectBuilderLogger(...)");
                ProjectBuilderLogger logger = projectBuilderLogger;
                if (logger.isEnabled()) {
                    logger.logCompiledFiles((Collection)this.allFiles, "Kotlin Builder", "Compiling files:");
                }
            }
            return hasDirtyOrRemovedSources;
        }
    }
}

