/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.components;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdEmptyMarkupModel;
import com.jetbrains.rd.ide.model.RdMarkupKey;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterFactory;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.HighlighterRangeRepairer;
import com.jetbrains.rdclient.daemon.IFrontendProtocolMarkupExtension;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelSupport;
import com.jetbrains.rdclient.daemon.RecyclingHighlighterStorage;
import com.jetbrains.rdclient.daemon.components.FrontendDaemonHost;
import com.jetbrains.rdclient.daemon.suppressors.HighlighterElementSuppressorFactory;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModel;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 )2\u00020\u0001:\u0003)*+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JR\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J8\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J$\u0010\u001d\u001a\u0004\u0018\u00010\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J$\u0010\u001e\u001a\u0004\u0018\u00010\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010 \u001a\u00020\u001b2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010$0\"H\u0002J(\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0\"H\u0002\u00a8\u0006,"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendMarkupHost;", "", "<init>", "()V", "createProtocolDocumentMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "document", "Lcom/intellij/openapi/editor/Document;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "createProtocolEditorMarkupModel", "editor", "Lcom/intellij/openapi/editor/Editor;", "createDocumentContributor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "protocolMarkup", "ideaMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "adapterFactory", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterFactory;", "handler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "createContributor", "createDocumentMarkupAdapterFactory", "createEditorMarkupAdapterFactory", "findMarkupContributor", "collectHandlers", "func", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelSupport;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "collectExtensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "Lcom/jetbrains/rdclient/daemon/IFrontendProtocolMarkupExtension;", "Companion", "MyDocumentListener", "MyEditorListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendMarkupHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,273:1\n13#2:274\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendMarkupHost\n*L\n34#1:274\n*E\n"})
public class FrontendMarkupHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<Map<Project, FrontendMarkupContributor>> DOCUMENT_CONTRIBUTOR_KEY;
    @NotNull
    private static final Key<FrontendMarkupContributor> EDITOR_CONTRIBUTOR_KEY;
    @NotNull
    private static final Key<ProtocolSuppressableMarkupModel> EDITOR_SUPPRESSABLE_MODEL_KEY;
    @NotNull
    private static final Key<Map<Project, ProtocolSuppressableMarkupModel>> DOCUMENT_SUPPRESSABLE_MODEL_KEY;

    private final RdMarkupModel createProtocolDocumentMarkupModel(Lifetime lifetime, ClientProjectSession projectSession, ClientAppSession session, Document document, RdDocumentId documentId) {
        FrontendMarkupAdapterFactory frontendMarkupAdapterFactory = this.createDocumentMarkupAdapterFactory(projectSession, session, document);
        if (frontendMarkupAdapterFactory == null) {
            return null;
        }
        FrontendMarkupAdapterFactory adapterFactory = frontendMarkupAdapterFactory;
        ClientProjectSession clientProjectSession = projectSession;
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)(clientProjectSession != null ? clientProjectSession.getProject() : null), (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx ideaDocumentMarkup = (MarkupModelEx)markupModel;
        List<MarkupModelExtension> documentMarkupExtensions = this.collectExtensions((Function1<? super IFrontendProtocolMarkupExtension, ? extends List<? extends MarkupModelExtension>>)((Function1)arg_0 -> FrontendMarkupHost.createProtocolDocumentMarkupModel$lambda$0(lifetime, document, arg_0)));
        RdMarkupModel protocolMarkup = new RdMarkupModel(documentMarkupExtensions);
        CompoundHighlighterModelsHandler handlers = this.collectHandlers((Function1<? super IProtocolHighlighterModelSupport, ? extends IProtocolHighlighterModelHandler>)((Function1)arg_0 -> FrontendMarkupHost.createProtocolDocumentMarkupModel$lambda$1(lifetime, projectSession, session, protocolMarkup, document, arg_0)));
        ProtocolSuppressableMarkupModel protocolSuppressableMarkup = new ProtocolSuppressableMarkupModel(protocolMarkup, HighlighterElementSuppressorFactory.Companion.createSuppressors(lifetime, session, document));
        FrontendMarkupContributor contributor = this.createDocumentContributor(lifetime, projectSession, session, document, documentId, protocolMarkup, ideaDocumentMarkup, adapterFactory, handlers);
        ClientProjectSession clientProjectSession2 = projectSession;
        FrontendMarkupHost.Companion.putMarkupContributor(lifetime, (Project)(clientProjectSession2 != null ? clientProjectSession2.getProject() : null), document, contributor);
        ClientProjectSession clientProjectSession3 = projectSession;
        FrontendMarkupHost.Companion.putSuppressableMarkup(lifetime, (Project)(clientProjectSession3 != null ? clientProjectSession3.getProject() : null), document, protocolSuppressableMarkup);
        contributor.bind$intellij_rd_client(lifetime, protocolSuppressableMarkup);
        return protocolMarkup;
    }

    private final RdMarkupModel createProtocolEditorMarkupModel(Lifetime lifetime, ClientProjectSession projectSession, ClientAppSession session, Editor editor) {
        FrontendMarkupAdapterFactory frontendMarkupAdapterFactory = this.createEditorMarkupAdapterFactory(projectSession, session, editor);
        if (frontendMarkupAdapterFactory == null) {
            return null;
        }
        FrontendMarkupAdapterFactory adapterFactory = frontendMarkupAdapterFactory;
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx ideaEditorMarkup = (MarkupModelEx)markupModel;
        List<MarkupModelExtension> editorMarkupExtensions = this.collectExtensions((Function1<? super IFrontendProtocolMarkupExtension, ? extends List<? extends MarkupModelExtension>>)((Function1)arg_0 -> FrontendMarkupHost.createProtocolEditorMarkupModel$lambda$0(lifetime, editor, arg_0)));
        RdMarkupModel protocolMarkup = new RdMarkupModel(editorMarkupExtensions);
        CompoundHighlighterModelsHandler editorMarkupHandlers = this.collectHandlers((Function1<? super IProtocolHighlighterModelSupport, ? extends IProtocolHighlighterModelHandler>)((Function1)arg_0 -> FrontendMarkupHost.createProtocolEditorMarkupModel$lambda$1(lifetime, editor, session, protocolMarkup, arg_0)));
        ProtocolSuppressableMarkupModel protocolSuppressableMarkup = new ProtocolSuppressableMarkupModel(protocolMarkup, HighlighterElementSuppressorFactory.Companion.createSuppressors(lifetime, session, editor));
        FrontendMarkupContributor contributor = this.createContributor(lifetime, session, protocolMarkup, ideaEditorMarkup, adapterFactory, editorMarkupHandlers);
        FrontendMarkupHost.Companion.putMarkupContributor(lifetime, editor, contributor);
        FrontendMarkupHost.Companion.putSuppressableMarkup(lifetime, editor, protocolSuppressableMarkup);
        contributor.bind$intellij_rd_client(lifetime, protocolSuppressableMarkup);
        return protocolMarkup;
    }

    @NotNull
    protected FrontendMarkupContributor createDocumentContributor(@NotNull Lifetime lifetime, @Nullable ClientProjectSession projectSession, @NotNull ClientAppSession session, @NotNull Document document, @NotNull RdDocumentId documentId, @NotNull RdMarkupModel protocolMarkup, @NotNull MarkupModelEx ideaMarkup, @NotNull FrontendMarkupAdapterFactory adapterFactory, @NotNull CompoundHighlighterModelsHandler handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        Intrinsics.checkNotNullParameter((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkNotNullParameter((Object)adapterFactory, (String)"adapterFactory");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        return this.createContributor(lifetime, session, protocolMarkup, ideaMarkup, adapterFactory, handler);
    }

    @NotNull
    protected FrontendMarkupContributor createContributor(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RdMarkupModel protocolMarkup, @NotNull MarkupModelEx ideaMarkup, @NotNull FrontendMarkupAdapterFactory adapterFactory, @NotNull CompoundHighlighterModelsHandler handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        Intrinsics.checkNotNullParameter((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkNotNullParameter((Object)adapterFactory, (String)"adapterFactory");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        FrontendMarkupAdapter adapter = adapterFactory.create(protocolMarkup, ideaMarkup, handler);
        Document document = ideaMarkup.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        HighlighterRangeRepairer repairer = new HighlighterRangeRepairer(lifetime, session, document, handler);
        FrontendMarkupSuppressor suppressor = FrontendDaemonHost.Companion.createMarkupSuppressor(lifetime, protocolMarkup.getDaemon());
        RecyclingHighlighterStorage storage = new RecyclingHighlighterStorage(handler, ideaMarkup, lifetime);
        return new FrontendMarkupContributor(lifetime, adapter, repairer, storage, suppressor);
    }

    @Nullable
    protected FrontendMarkupAdapterFactory createDocumentMarkupAdapterFactory(@Nullable ClientProjectSession projectSession, @NotNull ClientAppSession session, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return new FrontendMarkupAdapterFactory();
    }

    @Nullable
    protected FrontendMarkupAdapterFactory createEditorMarkupAdapterFactory(@Nullable ClientProjectSession projectSession, @NotNull ClientAppSession session, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return this.createDocumentMarkupAdapterFactory(projectSession, session, document);
    }

    @Nullable
    public FrontendMarkupContributor findMarkupContributor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return Companion.getMarkupContributor(project, document);
    }

    private final CompoundHighlighterModelsHandler collectHandlers(Function1<? super IProtocolHighlighterModelSupport, ? extends IProtocolHighlighterModelHandler> func) {
        List handlers = new ArrayList();
        for (IProtocolHighlighterModelSupport support : IProtocolHighlighterModelSupport.Companion.getEP_NAME().getExtensionList()) {
            IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler;
            try {
                iProtocolHighlighterModelHandler = (IProtocolHighlighterModelHandler)func.invoke((Object)support);
            }
            catch (Exception exception) {
                LOG.error("Error during creation highlighter model handler", (Throwable)exception);
                continue;
            }
            IProtocolHighlighterModelHandler handler = iProtocolHighlighterModelHandler;
            IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler2 = handler;
            if (iProtocolHighlighterModelHandler2 == null) continue;
            handlers.add(iProtocolHighlighterModelHandler2);
        }
        return new CompoundHighlighterModelsHandler(handlers);
    }

    private final List<MarkupModelExtension> collectExtensions(Function1<? super IFrontendProtocolMarkupExtension, ? extends List<? extends MarkupModelExtension>> func) {
        HashSet result2 = new HashSet();
        for (IFrontendProtocolMarkupExtension ex : IFrontendProtocolMarkupExtension.Companion.getEP_NAME().getExtensionList()) {
            List list2;
            try {
                list2 = (List)func.invoke((Object)ex);
            }
            catch (Exception exception) {
                LOG.error("Error during creation of protocol markup model extensions", (Throwable)exception);
                continue;
            }
            List extensions = list2;
            result2.addAll(extensions);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    private static final List createProtocolDocumentMarkupModel$lambda$0(Lifetime $lifetime, Document $document, IFrontendProtocolMarkupExtension it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createExtensions($lifetime, $document);
    }

    private static final IProtocolHighlighterModelHandler createProtocolDocumentMarkupModel$lambda$1(Lifetime $lifetime, ClientProjectSession $projectSession, ClientAppSession $session, RdMarkupModel $protocolMarkup, Document $document, IProtocolHighlighterModelSupport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClientProjectSession clientProjectSession = $projectSession;
        return it.createHandler($lifetime, (Project)(clientProjectSession != null ? clientProjectSession.getProject() : null), $session, $protocolMarkup, $document);
    }

    private static final List createProtocolEditorMarkupModel$lambda$0(Lifetime $lifetime, Editor $editor, IFrontendProtocolMarkupExtension it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createExtensions($lifetime, $editor);
    }

    private static final IProtocolHighlighterModelHandler createProtocolEditorMarkupModel$lambda$1(Lifetime $lifetime, Editor $editor, ClientAppSession $session, RdMarkupModel $protocolMarkup, IProtocolHighlighterModelSupport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createHandler($lifetime, $editor.getProject(), $session, $protocolMarkup, $editor);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DOCUMENT_CONTRIBUTOR_KEY = new Key("MarkupContributor");
        EDITOR_CONTRIBUTOR_KEY = new Key("MarkupContributor");
        EDITOR_SUPPRESSABLE_MODEL_KEY = new Key("MarkupContributor.SuppressableModel");
        DOCUMENT_SUPPRESSABLE_MODEL_KEY = new Key("MarkupContributor.SuppressableModel");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\fH\u0002J*\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J#\u0010\u001e\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\n\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0015\u0010\u001e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u001a\u001a\u00020\u001bJ:\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u000f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendMarkupHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdclient/daemon/components/FrontendMarkupHost;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DOCUMENT_CONTRIBUTOR_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/project/Project;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "EDITOR_CONTRIBUTOR_KEY", "EDITOR_SUPPRESSABLE_MODEL_KEY", "Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "DOCUMENT_SUPPRESSABLE_MODEL_KEY", "getMarkupContributor", "project", "document", "Lcom/intellij/openapi/editor/Document;", "putMarkupContributor", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "contributor", "editor", "Lcom/intellij/openapi/editor/Editor;", "putSuppressableMarkup", "suppressable", "getSuppressableMarkup", "Lorg/jetbrains/annotations/Nullable;", "addProtocolDocumentMarkupModel", "documentLifetime", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendMarkupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendMarkupHost$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,273:1\n42#2,3:274\n68#3,6:277\n68#3,6:283\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendMarkupHost$Companion\n*L\n32#1:274,3\n45#1:277,6\n63#1:283,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendMarkupHost getInstance() {
            boolean $i$f$service = false;
            Class<FrontendMarkupHost> serviceClass$iv = FrontendMarkupHost.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (FrontendMarkupHost)object;
        }

        @Nullable
        public final FrontendMarkupContributor getMarkupContributor(@Nullable Project project, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Map map = (Map)document.getUserData(DOCUMENT_CONTRIBUTOR_KEY);
            return map != null ? (FrontendMarkupContributor)map.get(project) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final void putMarkupContributor(Lifetime lifetime, Project project, Document document, FrontendMarkupContributor contributor) {
            void $this$getOrCreateUserDataUnsafe$iv;
            UserDataHolder userDataHolder = (UserDataHolder)document;
            Key key$iv = DOCUMENT_CONTRIBUTOR_KEY;
            boolean $i$f$getOrCreateUserDataUnsafe = false;
            Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
            Object object = existing$iv;
            if (object == null) {
                boolean bl = false;
                Map value$iv = new LinkedHashMap();
                $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
                object = value$iv;
            }
            Map map = (Map)object;
            CollectionExKt.addUnique((Map)map, (Lifetime)lifetime, (Object)project, (Object)contributor);
        }

        @Nullable
        public final FrontendMarkupContributor getMarkupContributor(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (FrontendMarkupContributor)editor.getUserData(EDITOR_CONTRIBUTOR_KEY);
        }

        private final void putMarkupContributor(Lifetime lifetime, Editor editor, FrontendMarkupContributor contributor) {
            lifetime.bracketOrThrowEx(() -> Companion.putMarkupContributor$lambda$1(editor, contributor), arg_0 -> Companion.putMarkupContributor$lambda$2(editor, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void putSuppressableMarkup(Lifetime lifetime, Project project, Document document, ProtocolSuppressableMarkupModel suppressable) {
            void $this$getOrCreateUserDataUnsafe$iv;
            UserDataHolder userDataHolder = (UserDataHolder)document;
            Key key$iv = DOCUMENT_SUPPRESSABLE_MODEL_KEY;
            boolean $i$f$getOrCreateUserDataUnsafe = false;
            Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
            Object object = existing$iv;
            if (object == null) {
                boolean bl = false;
                Map value$iv = new LinkedHashMap();
                $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
                object = value$iv;
            }
            Map map = (Map)object;
            CollectionExKt.addUnique((Map)map, (Lifetime)lifetime, (Object)project, (Object)suppressable);
        }

        private final void putSuppressableMarkup(Lifetime lifetime, Editor editor, ProtocolSuppressableMarkupModel suppressable) {
            lifetime.bracketOrThrowEx(() -> Companion.putSuppressableMarkup$lambda$1(editor, suppressable), arg_0 -> Companion.putSuppressableMarkup$lambda$2(editor, arg_0));
        }

        @Nullable
        public final Map<Project, ProtocolSuppressableMarkupModel> getSuppressableMarkup(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return (Map)document.getUserData(DOCUMENT_SUPPRESSABLE_MODEL_KEY);
        }

        @Nullable
        public final ProtocolSuppressableMarkupModel getSuppressableMarkup(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (ProtocolSuppressableMarkupModel)editor.getUserData(EDITOR_SUPPRESSABLE_MODEL_KEY);
        }

        private final void addProtocolDocumentMarkupModel(Lifetime documentLifetime, ClientProjectSession projectSession, ClientAppSession session, RdDocumentId documentId, RdDocumentModel documentModel, Document document) {
            ClientProjectSession clientProjectSession = projectSession;
            RdMarkupKey key = new RdMarkupKey(clientProjectSession != null && (clientProjectSession = clientProjectSession.getProject()) != null ? ProjectUtilKt.getRdProjectId((Project)clientProjectSession) : null);
            if (((Map)com.jetbrains.rd.ide.document.DocumentExKt.getMarkups((RdDocumentModel)documentModel)).containsKey(key)) {
                return;
            }
            RdMarkupModel markupModel = this.getInstance().createProtocolDocumentMarkupModel(documentLifetime, projectSession, session, document, documentId);
            if (markupModel == null) {
                CollectionExKt.addUnique((Map)((Map)com.jetbrains.rd.ide.document.DocumentExKt.getMarkups((RdDocumentModel)documentModel)), (Lifetime)documentLifetime, (Object)key, (Object)new RdEmptyMarkupModel());
                return;
            }
            LOG.debug("Setting document markup for '" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId) + "' to protocol");
            CollectionExKt.addUnique((Map)((Map)com.jetbrains.rd.ide.document.DocumentExKt.getMarkups((RdDocumentModel)documentModel)), (Lifetime)documentLifetime, (Object)key, (Object)markupModel);
        }

        private static final Unit putMarkupContributor$lambda$1(Editor $editor, FrontendMarkupContributor $contributor) {
            $editor.putUserData(EDITOR_CONTRIBUTOR_KEY, (Object)$contributor);
            return Unit.INSTANCE;
        }

        private static final Unit putMarkupContributor$lambda$2(Editor $editor, Unit it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$editor), (Key)EDITOR_CONTRIBUTOR_KEY);
            return Unit.INSTANCE;
        }

        private static final Unit putSuppressableMarkup$lambda$1(Editor $editor, ProtocolSuppressableMarkupModel $suppressable) {
            $editor.putUserData(EDITOR_SUPPRESSABLE_MODEL_KEY, (Object)$suppressable);
            return Unit.INSTANCE;
        }

        private static final Unit putSuppressableMarkup$lambda$2(Editor $editor, Unit it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$editor), (Key)EDITOR_SUPPRESSABLE_MODEL_KEY);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendMarkupHost$MyDocumentListener;", "Lcom/jetbrains/rdclient/document/FrontendDocumentHostListener;", "<init>", "()V", "documentBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rd.client"})
    public static final class MyDocumentListener
    implements FrontendDocumentHostListener {
        @Override
        public void documentBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Companion.addProtocolDocumentMarkupModel(lifetime, null, session, documentId, documentModel, document);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendMarkupHost$MyEditorListener;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHostListener;", "<init>", "()V", "beforeEditorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorBound", "intellij.rd.client"})
    public static final class MyEditorListener
    implements FrontendTextControlHostListener {
        @Override
        public void beforeEditorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ClientProjectSession projectSession = SessionUtilKt.getProjectSession((ClientAppSession)appSession, (RdProjectId)textControlId.getProjectId());
            if (projectSession != null) {
                Document document = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                RdDocumentId documentId = DocumentExKt.getDocumentId(document, appSession);
                if (documentId != null) {
                    DocumentSynchronizer documentSynchronizer = FrontendDocumentHost.Companion.getInstance(appSession).getSynchronizer(documentId);
                    Intrinsics.checkNotNull((Object)documentSynchronizer);
                    DocumentSynchronizer synchronizer = documentSynchronizer;
                    Lifetime lifetime2 = synchronizer.getDocumentLifetime();
                    RdDocumentModel rdDocumentModel = synchronizer.getModelDocument();
                    Document document2 = editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                    Companion.addProtocolDocumentMarkupModel(lifetime2, projectSession, appSession, documentId, rdDocumentModel, document2);
                }
            }
        }

        @Override
        public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ClientProjectSession projectSession = SessionUtilKt.getProjectSession((ClientAppSession)appSession, (RdProjectId)textControlId.getProjectId());
            RdMarkupModel protocolMarkup = Companion.getInstance().createProtocolEditorMarkupModel(lifetime, projectSession, appSession, editor);
            if (protocolMarkup == null) {
                TextControlModelExKt.getMarkup((TextControlModel)editorModel).set((Object)new RdEmptyMarkupModel());
                return;
            }
            TextControlId textControlId2 = DocumentExKt.getTextControlId(editor);
            LOG.debug("Setting editor markup for '" + (textControlId2 != null ? UtilKt.toDebugString((TextControlId)textControlId2) : null) + "' to protocol");
            TextControlModelExKt.getMarkup((TextControlModel)editorModel).set((Object)protocolMarkup);
        }
    }
}

