/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo.rhizome;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.rhizome.NodeEntity;
import com.intellij.platform.vcs.impl.shared.rhizome.RepositoryNodeEntity;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.shelf.NodeToEntityConverter;
import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.kernel.rebase.SharedChangeScope;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/dvcs/repo/rhizome/RepositoryNodeToEntityConverter;", "Lcom/intellij/vcs/shelf/NodeToEntityConverter;", "Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode;", "<init>", "()V", "convert", "Lcom/intellij/platform/vcs/impl/shared/rhizome/NodeEntity;", "Lfleet/kernel/rebase/SharedChangeScope;", "node", "orderInParent", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.dvcs.impl"})
public final class RepositoryNodeToEntityConverter
extends NodeToEntityConverter<RepositoryChangesBrowserNode> {
    public RepositoryNodeToEntityConverter() {
        super(Reflection.getOrCreateKotlinClass(RepositoryChangesBrowserNode.class));
    }

    @NotNull
    public NodeEntity convert(@NotNull SharedChangeScope $this$convert, @NotNull RepositoryChangesBrowserNode node, int orderInParent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (NodeEntity)$this$convert.new((EntityType)RepositoryNodeEntity.Companion, arg_0 -> RepositoryNodeToEntityConverter.convert$lambda$0(node, project, orderInParent, arg_0));
    }

    private static final void convert$lambda$0(RepositoryChangesBrowserNode $node, Project $project, int $orderInParent, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Repository repository = (Repository)$node.getUserObject();
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        BranchData currentBranch = CurrentBranchComponent.Companion.getCurrentBranch($project, virtualFile);
        Color color = RepositoryChangesBrowserNode.Companion.getColorManager($project).getRootColor(repository.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getRootColor(...)");
        Color color2 = color;
        Attributes.Required required = RepositoryNodeEntity.Companion.getName();
        String string = DvcsUtil.getShortRepositoryName(repository);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortRepositoryName(...)");
        it.set(required, (Object)string);
        if (currentBranch != null) {
            it.set(RepositoryNodeEntity.Companion.getBranchName(), (Object)BranchPresentation.INSTANCE.getPresentableText(currentBranch));
            it.set(RepositoryNodeEntity.Companion.getToolTip(), (Object)BranchPresentation.INSTANCE.getSingleTooltip(currentBranch));
        }
        it.set(RepositoryNodeEntity.Companion.getColorRed(), (Object)color2.getRed());
        it.set(RepositoryNodeEntity.Companion.getColorGreen(), (Object)color2.getGreen());
        it.set(RepositoryNodeEntity.Companion.getColorBlue(), (Object)color2.getBlue());
        it.set(NodeEntity.Companion.getOrder(), (Object)$orderInParent);
    }
}

