/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.options;

import com.intellij.codeInspection.options.LocMessage;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptCheckboxPanel;
import com.intellij.codeInspection.options.OptComponent;
import com.intellij.codeInspection.options.OptControl;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptExpandableString;
import com.intellij.codeInspection.options.OptGroup;
import com.intellij.codeInspection.options.OptHorizontalStack;
import com.intellij.codeInspection.options.OptMultiSelector;
import com.intellij.codeInspection.options.OptNumber;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptSeparator;
import com.intellij.codeInspection.options.OptSettingLink;
import com.intellij.codeInspection.options.OptString;
import com.intellij.codeInspection.options.OptStringList;
import com.intellij.codeInspection.options.OptTab;
import com.intellij.codeInspection.options.OptTabSet;
import com.intellij.codeInspection.options.OptTable;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptPane
extends Record {
    @NotNull
    private final @NotNull List<@NotNull OptRegularComponent> components;
    @Nullable
    private final String helpId;
    public static final OptPane EMPTY = new OptPane(List.of());

    public OptPane(@NotNull List<OptRegularComponent> components, @Nullable String helpId) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(0);
        }
        HashSet ids = new HashSet();
        OptPane.traverse(components, comp -> {
            OptControl ctl;
            if (comp instanceof OptControl && !ids.add((ctl = (OptControl)comp).bindId())) {
                throw new IllegalArgumentException("Repeating control identifier inside the pane: " + ctl.bindId());
            }
            return true;
        });
        this.components = components;
        this.helpId = helpId;
    }

    public OptPane(@NotNull @NotNull List<@NotNull OptRegularComponent> components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(1);
        }
        this(components, null);
    }

    @NotNull
    public OptPane withHelpId(@Nullable String helpId) {
        return new OptPane(this.components(), helpId);
    }

    @Nullable
    public OptControl findControl(final @NotNull String bindId) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(2);
        }
        var processor = new Predicate<OptComponent>(){
            OptControl found = null;

            @Override
            public boolean test(OptComponent cmp) {
                OptControl ctl;
                if (cmp instanceof OptControl && (ctl = (OptControl)cmp).bindId().equals(bindId)) {
                    this.found = ctl;
                    return false;
                }
                return true;
            }
        };
        OptPane.traverse(this.components, processor);
        return processor.found;
    }

    @NotNull
    public @NotNull List<@NotNull OptControl> allControls() {
        ArrayList<@NotNull OptControl> controls = new ArrayList<OptControl>();
        OptPane.traverse(this.components, component -> {
            if (component instanceof OptControl) {
                OptControl control = (OptControl)component;
                controls.add(control);
            }
            return true;
        });
        ArrayList<OptControl> arrayList = controls;
        if (arrayList == null) {
            OptPane.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static boolean traverse(@NotNull @NotNull List<? extends @NotNull OptComponent> components, @NotNull @NotNull Predicate<@NotNull OptComponent> processor) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            OptPane.$$$reportNull$$$0(5);
        }
        for (OptComponent optComponent : components) {
            if (processor.test(optComponent) && OptPane.traverse(optComponent.children(), processor)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public OptTab asTab(@NlsContexts.TabTitle @NotNull String label) {
        if (label == null) {
            OptPane.$$$reportNull$$$0(6);
        }
        return new OptTab(LocMessage.of(label), this.components());
    }

    @Contract(pure=true)
    @NotNull
    public OptCheckbox asCheckbox(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String label) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(7);
        }
        if (label == null) {
            OptPane.$$$reportNull$$$0(8);
        }
        return new OptCheckbox(bindId, LocMessage.of(label), this.components(), null);
    }

    @Contract(pure=true)
    @NotNull
    public OptPane prefix(@NotNull String bindPrefix) {
        if (bindPrefix == null) {
            OptPane.$$$reportNull$$$0(9);
        }
        return new OptPane(ContainerUtil.map(this.components(), c -> c.prefix(bindPrefix)));
    }

    @Contract(pure=true)
    @NotNull
    public OptPane prepend(OptRegularComponent ... components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(10);
        }
        ArrayList<OptRegularComponent> newComponents = new ArrayList<OptRegularComponent>(Arrays.asList(components));
        newComponents.addAll(this.components());
        return new OptPane(newComponents);
    }

    @Contract(pure=true)
    @NotNull
    public OptPane append(OptRegularComponent ... components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(11);
        }
        ArrayList<OptRegularComponent> newComponents = new ArrayList<OptRegularComponent>(this.components());
        ContainerUtil.addAll(newComponents, (Object[])components);
        return new OptPane(newComponents);
    }

    @Contract(pure=true)
    @NotNull
    public static OptPane pane(OptRegularComponent ... components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(12);
        }
        return new OptPane(List.of(components));
    }

    @Contract(pure=true)
    @NotNull
    public static OptCheckbox checkbox(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String label, OptRegularComponent ... children) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(13);
        }
        if (label == null) {
            OptPane.$$$reportNull$$$0(14);
        }
        if (children == null) {
            OptPane.$$$reportNull$$$0(15);
        }
        return new OptCheckbox(bindId, LocMessage.of(label), List.of(children), null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptCheckboxPanel checkboxPanel(OptCheckbox ... checkboxes) {
        if (checkboxes == null) {
            OptPane.$$$reportNull$$$0(16);
        }
        return new OptCheckboxPanel(List.of(checkboxes));
    }

    @Contract(pure=true)
    @NotNull
    public static OptNumber number(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel, int minValue, int maxValue) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(17);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(18);
        }
        return new OptNumber(bindId, LocMessage.of(splitLabel), minValue, maxValue, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(19);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(20);
        }
        return new OptString(bindId, LocMessage.of(splitLabel), null, -1, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel, int width) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(21);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(22);
        }
        return new OptString(bindId, LocMessage.of(splitLabel), null, width, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel, @NotNull StringValidator validator) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(23);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(24);
        }
        if (validator == null) {
            OptPane.$$$reportNull$$$0(25);
        }
        return new OptString(bindId, LocMessage.of(splitLabel), validator, -1, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel, int width, @NotNull StringValidator validator) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(26);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(27);
        }
        if (validator == null) {
            OptPane.$$$reportNull$$$0(28);
        }
        return new OptString(bindId, LocMessage.of(splitLabel), validator, width, null);
    }

    @Contract(pure=true)
    public static OptExpandableString expandableString(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String label, @NotNull String separator) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(29);
        }
        if (label == null) {
            OptPane.$$$reportNull$$$0(30);
        }
        if (separator == null) {
            OptPane.$$$reportNull$$$0(31);
        }
        return new OptExpandableString(bindId, LocMessage.of(label), separator, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptDropdown dropdown(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel, OptDropdown.Option ... options) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(32);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(33);
        }
        if (options == null) {
            OptPane.$$$reportNull$$$0(34);
        }
        return new OptDropdown(bindId, LocMessage.of(splitLabel), List.of(options));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> OptDropdown dropdown(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel, @NotNull Collection<T> values, @NotNull @NotNull Function<? super T, @NotNull @NonNls String> keyExtractor, @NotNull @NotNull Function<? super T, @NotNull @Nls String> presentableTextExtractor) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(35);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(36);
        }
        if (values == null) {
            OptPane.$$$reportNull$$$0(37);
        }
        if (keyExtractor == null) {
            OptPane.$$$reportNull$$$0(38);
        }
        if (presentableTextExtractor == null) {
            OptPane.$$$reportNull$$$0(39);
        }
        return new OptDropdown(bindId, LocMessage.of(splitLabel), ContainerUtil.map(values, c -> OptPane.option((String)keyExtractor.apply(c), (String)presentableTextExtractor.apply(c))));
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends Enum<T>> OptDropdown dropdown(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String splitLabel, @NotNull Class<T> enumClass, @NotNull @NotNull Function<@NotNull T, @NotNull @Nls String> presentableTextExtractor) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(40);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(41);
        }
        if (enumClass == null) {
            OptPane.$$$reportNull$$$0(42);
        }
        if (presentableTextExtractor == null) {
            OptPane.$$$reportNull$$$0(43);
        }
        return new OptDropdown(bindId, LocMessage.of(splitLabel), ContainerUtil.map((Object[])((Enum[])enumClass.getEnumConstants()), c -> OptPane.option(c, (String)presentableTextExtractor.apply(c))));
    }

    @Contract(pure=true)
    @NotNull
    public static OptDropdown.Option option(@NotNull String key, @NotNull @Nls String label) {
        if (key == null) {
            OptPane.$$$reportNull$$$0(44);
        }
        if (label == null) {
            OptPane.$$$reportNull$$$0(45);
        }
        return new OptDropdown.Option(key, LocMessage.of(label));
    }

    @Contract(pure=true)
    @NotNull
    public static OptDropdown.Option option(@NotNull Enum<?> key, @NotNull @Nls String label) {
        if (key == null) {
            OptPane.$$$reportNull$$$0(46);
        }
        if (label == null) {
            OptPane.$$$reportNull$$$0(47);
        }
        return new OptDropdown.Option(key.name(), LocMessage.of(label));
    }

    @Contract(pure=true)
    @NotNull
    public static OptStringList stringList(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String label) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(48);
        }
        if (label == null) {
            OptPane.$$$reportNull$$$0(49);
        }
        return new OptStringList(bindId, LocMessage.of(label), null, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptStringList stringList(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.Label @NotNull String label, @NotNull StringValidator validator) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(50);
        }
        if (label == null) {
            OptPane.$$$reportNull$$$0(51);
        }
        if (validator == null) {
            OptPane.$$$reportNull$$$0(52);
        }
        return new OptStringList(bindId, LocMessage.of(label), validator, null);
    }

    @NotNull
    public static OptTable table(@NlsContexts.Label @NotNull String label, OptTableColumn ... columns) {
        if (label == null) {
            OptPane.$$$reportNull$$$0(53);
        }
        if (columns == null) {
            OptPane.$$$reportNull$$$0(54);
        }
        return new OptTable(LocMessage.of(label), List.of(columns), null);
    }

    @NotNull
    public static OptMultiSelector multiSelector(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull List<? extends OptMultiSelector.OptElement> elements, @NotNull OptMultiSelector.SelectionMode mode) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(55);
        }
        if (elements == null) {
            OptPane.$$$reportNull$$$0(56);
        }
        if (mode == null) {
            OptPane.$$$reportNull$$$0(57);
        }
        return new OptMultiSelector(bindId, elements, mode);
    }

    @Contract(pure=true)
    @NotNull
    public static OptTableColumn column(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.ColumnName @NotNull String name) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(58);
        }
        if (name == null) {
            OptPane.$$$reportNull$$$0(59);
        }
        return new OptTableColumn(bindId, LocMessage.of(name), null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptTableColumn column(@Language(value="jvm-field-name") @NotNull String bindId, @NlsContexts.ColumnName @NotNull String name, @NotNull StringValidator validator) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(60);
        }
        if (name == null) {
            OptPane.$$$reportNull$$$0(61);
        }
        if (validator == null) {
            OptPane.$$$reportNull$$$0(62);
        }
        return new OptTableColumn(bindId, LocMessage.of(name), validator);
    }

    @Contract(pure=true)
    @NotNull
    public static OptGroup group(@NlsContexts.Label @NotNull String label, OptRegularComponent ... children) {
        if (label == null) {
            OptPane.$$$reportNull$$$0(63);
        }
        if (children == null) {
            OptPane.$$$reportNull$$$0(64);
        }
        return new OptGroup(LocMessage.of(label), List.of(children));
    }

    @Contract(pure=true)
    @NotNull
    public static OptHorizontalStack horizontalStack(OptRegularComponent ... children) {
        if (children == null) {
            OptPane.$$$reportNull$$$0(65);
        }
        return new OptHorizontalStack(List.of(children));
    }

    @Contract(pure=true)
    @NotNull
    public static OptSeparator separator() {
        return new OptSeparator(null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptSeparator separator(@NlsContexts.Label @NotNull String label) {
        if (label == null) {
            OptPane.$$$reportNull$$$0(66);
        }
        return new OptSeparator(LocMessage.of(label));
    }

    @Contract(pure=true)
    @NotNull
    public static OptTabSet tabs(OptTab ... tabs) {
        if (tabs == null) {
            OptPane.$$$reportNull$$$0(67);
        }
        return new OptTabSet(List.of(tabs));
    }

    @Contract(pure=true)
    @NotNull
    public static OptTab tab(@NlsContexts.TabTitle @NotNull String label, OptRegularComponent ... children) {
        if (label == null) {
            OptPane.$$$reportNull$$$0(68);
        }
        if (children == null) {
            OptPane.$$$reportNull$$$0(69);
        }
        return new OptTab(LocMessage.of(label), List.of(children));
    }

    @Contract(pure=true)
    @NotNull
    public static OptSettingLink settingLink(@NlsContexts.Label @NotNull String displayName, @NotNull @NonNls String configurableID) {
        if (displayName == null) {
            OptPane.$$$reportNull$$$0(70);
        }
        if (configurableID == null) {
            OptPane.$$$reportNull$$$0(71);
        }
        return new OptSettingLink(LocMessage.of(displayName), configurableID, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptSettingLink settingLink(@NlsContexts.Label @NotNull String displayName, @NotNull @NonNls String configurableID, @NotNull @Nls String controlLabel) {
        if (displayName == null) {
            OptPane.$$$reportNull$$$0(72);
        }
        if (configurableID == null) {
            OptPane.$$$reportNull$$$0(73);
        }
        if (controlLabel == null) {
            OptPane.$$$reportNull$$$0(74);
        }
        return new OptSettingLink(LocMessage.of(displayName), configurableID, controlLabel);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{OptPane.class, "components;helpId", "components", "helpId"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OptPane.class, "components;helpId", "components", "helpId"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OptPane.class, "components;helpId", "components", "helpId"}, this, o);
    }

    @NotNull
    public @NotNull List<@NotNull OptRegularComponent> components() {
        List<OptRegularComponent> list = this.components;
        if (list == null) {
            OptPane.$$$reportNull$$$0(75);
        }
        return list;
    }

    @Nullable
    public String helpId() {
        return this.helpId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 40: 
            case 48: 
            case 50: 
            case 55: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindId";
                break;
            }
            case 3: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/options/OptPane";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 30: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 63: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindPrefix";
                break;
            }
            case 15: 
            case 64: 
            case 65: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkboxes";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 33: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitLabel";
                break;
            }
            case 25: 
            case 28: 
            case 52: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyExtractor";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableTextExtractor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableID";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/options/OptPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "allControls";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findControl";
                break;
            }
            case 3: 
            case 75: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asTab";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asCheckbox";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prefix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pane";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkbox";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkboxPanel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "number";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "string";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "expandableString";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "dropdown";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "option";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "stringList";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "table";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "multiSelector";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "column";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "horizontalStack";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "separator";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "tabs";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "tab";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "settingLink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 75 -> new IllegalStateException(string);
        };
    }
}

