/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenActionsUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.impl.GatewayUIService;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreen;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeTabFactory;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Disabled;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "RemoteDevelopmentWelcomeScreen", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nOpenRemoteDevelopmentWelcomeScreenAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenRemoteDevelopmentWelcomeScreenAction.kt\ncom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,163:1\n94#2:164\n*S KotlinDebug\n*F\n+ 1 OpenRemoteDevelopmentWelcomeScreenAction.kt\ncom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction\n*L\n38#1:164\n*E\n"})
public final class OpenRemoteDevelopmentWelcomeScreenAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Disabled {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        event.getPresentation().setEnabledAndVisible(event.getProject() != null && AppModeAssertions.isMonolith());
        event.getPresentation().setText(GatewayBundle.INSTANCE.message("action.remoteDevelopment.openRemoteDevelopmentWelcomeScreen.title", new Object[0]));
        if (Intrinsics.areEqual((Object)event.getData(WelcomeScreenActionsUtil.NON_MODAL_WELCOME_SCREEN), (Object)true)) {
            event.getPresentation().setIcon(AllIcons.Nodes.Plugin);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RemoteDevelopmentWelcomeScreen dialog2 = new RemoteDevelopmentWelcomeScreen(event.getProject());
        dialog2.show();
    }

    static {
        boolean $i$f$getLogger = false;
        logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(OpenRemoteDevelopmentWelcomeScreenAction.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction$Companion;", "", "<init>", "()V", "logger", "Lcom/jetbrains/rd/util/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014\u00a2\u0006\u0002\u0010\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u001c\u001a\u00020\u0012H\u0014J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction$RemoteDevelopmentWelcomeScreen;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "gatewayFactory", "Lcom/jetbrains/gateway/welcomeScreen/GatewayWelcomeTabFactory;", "tabbedWelcomeScreen", "Lcom/jetbrains/gateway/welcomeScreen/GatewayWelcomeScreen;", "gatewayUiService", "Lcom/jetbrains/gateway/impl/GatewayUIService;", "dimensionService", "Lcom/intellij/openapi/util/DimensionService;", "kotlin.jvm.PlatformType", "beforeShowCallback", "", "getStyle", "Lcom/intellij/openapi/ui/DialogWrapper$DialogStyle;", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createSouthPanel", "dispose", "initDialogSize", "saveDialogSizeAndLocation", "Companion", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nOpenRemoteDevelopmentWelcomeScreenAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenRemoteDevelopmentWelcomeScreenAction.kt\ncom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction$RemoteDevelopmentWelcomeScreen\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,163:1\n103#2:164\n98#2,4:165\n94#2:169\n*S KotlinDebug\n*F\n+ 1 OpenRemoteDevelopmentWelcomeScreenAction.kt\ncom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction$RemoteDevelopmentWelcomeScreen\n*L\n108#1:164\n108#1:165,4\n63#1:169\n*E\n"})
    public static final class RemoteDevelopmentWelcomeScreen
    extends DialogWrapper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Project project;
        @NotNull
        private final LifetimeDefinition lifetime;
        @NotNull
        private final GatewayWelcomeTabFactory gatewayFactory;
        @NotNull
        private final GatewayWelcomeScreen tabbedWelcomeScreen;
        @NotNull
        private final GatewayUIService gatewayUiService;
        private final DimensionService dimensionService;
        @NotNull
        private static final Logger logger;
        @NotNull
        private static final String DIMENSION_KEY = "REMOTE_DEVELOPMENT_CONNECTION";

        public RemoteDevelopmentWelcomeScreen(@Nullable Project project) {
            super(project, false, DialogWrapper.IdeModalityType.IDE);
            this.project = project;
            Disposable disposable = this.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            this.lifetime = LifetimeDisposableExKt.defineNestedLifetime((Disposable)disposable);
            this.gatewayFactory = new GatewayWelcomeTabFactory(true);
            this.tabbedWelcomeScreen = new GatewayWelcomeScreen(CollectionsKt.listOf((Object)this.gatewayFactory), false, false);
            this.gatewayUiService = GatewayUIService.Companion.getServiceInstance();
            this.dimensionService = DimensionService.getInstance();
            super.init();
            Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)this.tabbedWelcomeScreen));
            this.setTitle(GatewayBundle.INSTANCE.message("welcome.tab.title", new Object[0]));
            this.lifetime.onTermination(() -> RemoteDevelopmentWelcomeScreen._init_$lambda$0(this));
            this.getWindow().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    this.saveDialogSizeAndLocation();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.saveDialogSizeAndLocation();
                }
            });
            this.initDialogSize();
        }

        public void beforeShowCallback() {
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            ModalityState modalityState2 = modalityState;
            SourceExKt.adviseOnce((ISource)((ISource)this.gatewayUiService.getConnected()), (Lifetime)((Lifetime)this.lifetime), arg_0 -> RemoteDevelopmentWelcomeScreen.beforeShowCallback$lambda$0(this, modalityState2, arg_0));
            super.beforeShowCallback();
        }

        @NotNull
        protected DialogWrapper.DialogStyle getStyle() {
            return DialogWrapper.DialogStyle.COMPACT;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)((Object)this.tabbedWelcomeScreen);
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[0];
        }

        @Nullable
        protected JComponent createSouthPanel() {
            return null;
        }

        protected void dispose() {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetime, (boolean)false, (int)1, null);
            super.dispose();
        }

        private final void initDialogSize() {
            Dimension savedSize = this.dimensionService.getSize(DIMENSION_KEY, this.project);
            JBDimension jBDimension = JBUI.size((int)FlatWelcomeFrame.MAX_DEFAULT_WIDTH, (int)FlatWelcomeFrame.DEFAULT_HEIGHT);
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
            JBDimension defaultSize = jBDimension;
            this.tabbedWelcomeScreen.setMinimumSize((Dimension)defaultSize);
            Dimension dimension = savedSize;
            if (dimension == null) {
                dimension = (Dimension)defaultSize;
            }
            Dimension windowSize = dimension;
            this.getWindow().setPreferredSize(windowSize);
            Point savedLocation = this.dimensionService.getLocation(DIMENSION_KEY, this.project);
            if (savedLocation != null) {
                this.setLocation(savedLocation);
            }
        }

        private final void saveDialogSizeAndLocation() {
            this.dimensionService.setSize(DIMENSION_KEY, this.getWindow().getSize(), this.project);
            this.dimensionService.setLocation(DIMENSION_KEY, this.getWindow().getLocation(), this.project);
        }

        private static final void lambda$0$0(RemoteDevelopmentWelcomeScreen this$0) {
            this$0.saveDialogSizeAndLocation();
        }

        private static final Unit _init_$lambda$0(RemoteDevelopmentWelcomeScreen this$0) {
            ApplicationKt.getApplication().invokeLater(() -> RemoteDevelopmentWelcomeScreen.lambda$0$0(this$0));
            return Unit.INSTANCE;
        }

        private static final void beforeShowCallback$lambda$0$1(RemoteDevelopmentWelcomeScreen this$0) {
            this$0.close(1);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit beforeShowCallback$lambda$0(RemoteDevelopmentWelcomeScreen this$0, ModalityState $modalityState, Unit it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!this$0.isVisible()) {
                void $this$log$iv$iv;
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                Logger logger = $this$trace$iv;
                LogLevel level$iv$iv = LogLevel.Trace;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var9_9 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = "Gateway connection event was fired. Remote Development connection screen is not visible. Skip closing the screen.";
                    var9_9.log(logLevel, (Object)string, null);
                }
                return Unit.INSTANCE;
            }
            ApplicationKt.getApplication().invokeLater(() -> RemoteDevelopmentWelcomeScreen.beforeShowCallback$lambda$0$1(this$0), $modalityState);
            return Unit.INSTANCE;
        }

        static {
            boolean $i$f$getLogger = false;
            logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(RemoteDevelopmentWelcomeScreen.class));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/actions/OpenRemoteDevelopmentWelcomeScreenAction$RemoteDevelopmentWelcomeScreen$Companion;", "", "<init>", "()V", "logger", "Lcom/jetbrains/rd/util/Logger;", "DIMENSION_KEY", "", "intellij.gateway.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

