/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    private static boolean mirrorToStderr = true;
    private final String category;
    private LogLevel level = LogLevel.WARNING;

    public DefaultLogger(String category) {
        this.category = category;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level.compareTo(LogLevel.DEBUG) >= 0;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level.compareTo(LogLevel.TRACE) >= 0;
    }

    @Override
    public void trace(String message) {
        if (this.isTraceEnabled()) {
            System.out.println("TRACE[" + this.category + "]: " + message);
        }
    }

    @Override
    public void trace(@Nullable Throwable t) {
        if (t != null && this.isTraceEnabled()) {
            System.out.print("TRACE[" + this.category + "]: ");
            t.printStackTrace(System.out);
        }
    }

    @Override
    public void debug(String message, @Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            System.out.println("DEBUG[" + this.category + "]: " + message);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (this.level.compareTo(LogLevel.INFO) >= 0) {
            System.out.println("INFO[" + this.category + "]: " + message);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void warn(String message, @Nullable Throwable t) {
        t = DefaultLogger.ensureNotControlFlow(t);
        System.err.println("WARN: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(0);
        }
        t = DefaultLogger.ensureNotControlFlow(t);
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message + DefaultLogger.detailsToString(details) + DefaultLogger.attachmentsToString(t));
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
        throw new AssertionError(message, t);
    }

    @Override
    public void setLevel(@NotNull LogLevel level) {
        if (level == null) {
            DefaultLogger.$$$reportNull$$$0(1);
        }
        this.level = level;
    }

    @ApiStatus.Internal
    public LogLevel getLevel() {
        return this.level;
    }

    @NotNull
    public static String detailsToString(String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(2);
        }
        return details.length > 0 ? "\nDetails:\n" + String.join((CharSequence)"\n", details) : "";
    }

    @NotNull
    public static String attachmentsToString(@Nullable Throwable t) {
        if (t != null) {
            String prefix = "\n\nAttachments:\n";
            String attachments = ExceptionUtil.causeAndSuppressed(t, ExceptionWithAttachments.class).flatMap(e -> Stream.of(e.getAttachments()).map(attachment -> {
                if (attachment == null) {
                    throw new NullPointerException(e + " returned null attachment from getAttachments() method");
                }
                return (String)ATTACHMENT_TO_STRING.apply(attachment);
            })).collect(Collectors.joining("\n----\n", prefix, ""));
            if (!attachments.equals(prefix)) {
                String string = attachments;
                if (string == null) {
                    DefaultLogger.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return mirrorToStderr;
    }

    public static void disableStderrDumping(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DefaultLogger.$$$reportNull$$$0(4);
        }
        boolean prev = mirrorToStderr;
        mirrorToStderr = false;
        Disposer.register(parentDisposable, () -> {
            mirrorToStderr = prev;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "attachmentsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detailsToString";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disableStderrDumping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

