/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jdom.Attribute;
import org.jdom.AttributeType;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.ImmutableAttribute;
import org.jdom.ImmutableSameTypeAttributeList;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.filter2.ElementFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImmutableElement
extends Element {
    private static final List<Attribute> EMPTY_LIST = new ImmutableSameTypeAttributeList(ArrayUtilRt.EMPTY_STRING_ARRAY, null, Namespace.NO_NAMESPACE);
    private final Content[] myContent;
    private static final Content[] EMPTY_CONTENT = new Content[0];
    private final List<Attribute> myAttributes;

    ImmutableElement(@NotNull Element origin, @NotNull JDOMInterner interner) {
        if (origin == null) {
            ImmutableElement.$$$reportNull$$$0(0);
        }
        if (interner == null) {
            ImmutableElement.$$$reportNull$$$0(1);
        }
        this.name = interner.internString(origin.getName());
        this.myAttributes = ImmutableElement.internAttributes(origin, interner);
        List<Content> origContent = origin.getContent();
        if (origContent.isEmpty()) {
            this.myContent = EMPTY_CONTENT;
        } else {
            Content[] newContent = new Content[origContent.size()];
            int index = 0;
            for (Content o : origContent) {
                if (o instanceof Element) {
                    Element newElement = interner.internElement((Element)o);
                    newContent[index++] = newElement;
                    continue;
                }
                if (o instanceof Text) {
                    Text newText = interner.internText((Text)o);
                    newContent[index++] = newText;
                    continue;
                }
                throw new RuntimeException(o.toString());
            }
            this.myContent = index == newContent.length ? newContent : Arrays.copyOf(newContent, index);
        }
        this.namespace = origin.getNamespace();
        for (Namespace namespace : origin.getAdditionalNamespaces()) {
            super.addNamespaceDeclaration(namespace);
        }
    }

    @NotNull
    private static List<Attribute> internAttributes(@NotNull Element origin, @NotNull JDOMInterner interner) {
        List<Attribute> originAttributes;
        if (origin == null) {
            ImmutableElement.$$$reportNull$$$0(2);
        }
        if (interner == null) {
            ImmutableElement.$$$reportNull$$$0(3);
        }
        List<Attribute> list = originAttributes = origin.hasAttributes() ? origin.getAttributes() : null;
        if (originAttributes == null || originAttributes.isEmpty()) {
            List<Attribute> list2 = EMPTY_LIST;
            if (list2 == null) {
                ImmutableElement.$$$reportNull$$$0(4);
            }
            return list2;
        }
        AttributeType type = null;
        String[] nameValues = new String[originAttributes.size() * 2];
        Namespace namespace = null;
        for (int i = 0; i < originAttributes.size(); ++i) {
            Attribute origAttribute = originAttributes.get(i);
            if (type == null) {
                type = origAttribute.getAttributeType();
                namespace = origAttribute.getNamespace();
            } else if (type != origAttribute.getAttributeType() || !origAttribute.getNamespace().equals(namespace)) {
                type = null;
                break;
            }
            String name = interner.internString(origAttribute.getName());
            String value = interner.internString(origAttribute.getValue());
            nameValues[i * 2] = name;
            nameValues[i * 2 + 1] = value;
        }
        if (type == null) {
            ArrayList<ImmutableAttribute> list3 = new ArrayList<ImmutableAttribute>(originAttributes.size());
            for (Attribute attribute : originAttributes) {
                list3.add(new ImmutableAttribute(interner.internString(attribute.getName()), interner.internString(attribute.getValue()), attribute.getAttributeType(), attribute.getNamespace()));
            }
            List<Attribute> list4 = Collections.unmodifiableList(list3);
            if (list4 == null) {
                ImmutableElement.$$$reportNull$$$0(5);
            }
            return list4;
        }
        return new ImmutableSameTypeAttributeList(nameValues, type, namespace);
    }

    @Override
    public int getContentSize() {
        return this.myContent.length;
    }

    @Override
    @NotNull
    public List<Content> getContent() {
        List<Content> list = Arrays.asList(this.myContent);
        if (list == null) {
            ImmutableElement.$$$reportNull$$$0(6);
        }
        return list;
    }

    public <T extends Content> List<T> getContent(@NotNull Filter<T> filter) {
        if (filter == null) {
            ImmutableElement.$$$reportNull$$$0(7);
        }
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content it : this.myContent) {
            if (!filter.matches(it)) continue;
            result.add(it);
        }
        return result;
    }

    @Override
    public Content getContent(int index) {
        return this.myContent[index];
    }

    @Override
    public Iterator<Content> getDescendants() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public List<Element> getChildren() {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Content it : this.myContent) {
            if (!(it instanceof Element)) continue;
            list.add((Element)it);
        }
        ArrayList<Element> arrayList = list;
        if (arrayList == null) {
            ImmutableElement.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Element> getChildren(String name, Namespace ns) {
        ElementFilter predicate = new ElementFilter(name, ns);
        ArrayList<Element> list = new ArrayList<Element>();
        for (Content it : this.myContent) {
            if (!predicate.matches(it)) continue;
            list.add((Element)it);
        }
        ArrayList<Element> arrayList = list;
        if (arrayList == null) {
            ImmutableElement.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    public Element getChild(String name, Namespace ns) {
        List<Element> children = this.getChildren(name, ns);
        return children.isEmpty() ? null : children.get(0);
    }

    @Override
    public String getText() {
        if (this.myContent.length == 0) {
            return "";
        }
        if (this.myContent.length == 1) {
            Content obj = this.myContent[0];
            return obj instanceof Text ? ((Text)obj).getText() : "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (Content content : this.myContent) {
            if (!(content instanceof Text)) continue;
            textContent.append(((Text)content).getText());
            hasText = true;
        }
        return hasText ? textContent.toString() : "";
    }

    @Override
    public int indexOf(Content child) {
        return ArrayUtilRt.indexOf((Object[])this.myContent, (Object)child, (int)0, (int)this.myContent.length);
    }

    @Override
    public Namespace getNamespace(String prefix) {
        Namespace ns = super.getNamespace(prefix);
        if (ns == null) {
            for (Attribute a : this.myAttributes) {
                if (!prefix.equals(a.getNamespacePrefix())) continue;
                return a.getNamespace();
            }
        }
        return ns;
    }

    @Override
    public boolean hasAttributes() {
        return !this.myAttributes.isEmpty();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public Attribute getAttribute(String name, Namespace ns) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).get(name, ns);
        }
        String uri = this.namespace.getURI();
        for (Attribute a : this.myAttributes) {
            String oldURI = a.getNamespaceURI();
            String oldName = a.getName();
            if (!oldURI.equals(uri) || !oldName.equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    @Nullable
    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, Namespace.NO_NAMESPACE);
    }

    @Override
    public String getAttributeValue(String name, String def) {
        return this.getAttributeValue(name, Namespace.NO_NAMESPACE, def);
    }

    @Override
    public String getAttributeValue(String name, Namespace ns) {
        return this.getAttributeValue(name, ns, null);
    }

    @Override
    public String getAttributeValue(String name, Namespace ns, String defaultValue) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).getValue(name, ns, defaultValue);
        }
        Attribute attribute = this.getAttribute(name, ns);
        return attribute == null ? defaultValue : attribute.getValue();
    }

    @Override
    public Element clone() {
        return ImmutableElement.createClone(this, this.myContent, this.myAttributes);
    }

    @Override
    public Element getParent() {
        throw ImmutableElement.immutableError(this);
    }

    boolean attributesEqual(Element element) {
        List<Attribute> attrs = element.getAttributes();
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return this.myAttributes.equals(attrs);
        }
        if (this.myAttributes.size() != attrs.size()) {
            return false;
        }
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute oAttr;
            Attribute attribute = this.myAttributes.get(i);
            if (ImmutableElement.attributesEqual(attribute, oAttr = attrs.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean attributesEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && Objects.equals(a1.getValue(), a2.getValue()) && a1.getAttributeType() == a2.getAttributeType() && a1.getNamespace().equals(a2.getNamespace());
    }

    @NotNull
    static IncorrectOperationException immutableError(Object element) {
        return new IncorrectOperationException("Can't change immutable element: " + element.getClass() + ". To obtain mutable Element call .clone()");
    }

    @Override
    @NotNull
    public Element detach() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setName(String name) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setNamespace(Namespace namespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setText(String text) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public List<Content> removeContent() {
        throw ImmutableElement.immutableError(this);
    }

    public <T extends Content> List<T> removeContent(Filter<T> filter) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setContent(int index, Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Parent setContent(int index, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(String str) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Element child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(int index, Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(int index, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Content removeContent(int index) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    public Element setAttributes(Collection newAttributes) {
        throw ImmutableElement.immutableError(this);
    }

    public Element setAttributes(List newAttributes) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull String name, @NotNull String value) {
        if (name == null) {
            ImmutableElement.$$$reportNull$$$0(10);
        }
        if (value == null) {
            ImmutableElement.$$$reportNull$$$0(11);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull String name, @NotNull String value, Namespace ns) {
        if (name == null) {
            ImmutableElement.$$$reportNull$$$0(12);
        }
        if (value == null) {
            ImmutableElement.$$$reportNull$$$0(13);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull Attribute attribute) {
        if (attribute == null) {
            ImmutableElement.$$$reportNull$$$0(14);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(String name) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(String name, Namespace ns) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAttribute(Attribute attribute) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChild(String name) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChild(String name, Namespace ns) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChildren(String name) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeChildren(String name, Namespace ns) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    protected Content setParent(Parent parent) {
        throw ImmutableElement.immutableError(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jdom/ImmutableElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jdom/ImmutableElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "internAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "internAttributes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

