/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.PackageJsonReferenceContributor;
import com.intellij.javascript.nodejs.packageJson.PackageJsonScriptReferenceSupport;
import com.intellij.javascript.nodejs.packageJson.codeInsight.PackageJsonCompletionUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.json.codeinsight.JsonStringPropertyInsertHandler;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonCompletionContributor
extends CompletionContributor
implements DumbAware {
    static final Logger LOG = Logger.getInstance(PackageJsonCompletionContributor.class);
    private static final ElementPattern<? extends PsiElement> SCRIPT_PATTERN = PackageJsonReferenceContributor.createScriptValuePattern();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(1);
        }
        if (PackageJsonCommonUtil.isInsidePackageJsonFile((PsiElement)parameters2.getOriginalFile())) {
            if (SCRIPT_PATTERN.accepts((Object)parameters2.getPosition().getParent())) {
                PackageJsonScriptReferenceSupport.complete(parameters2, result2);
            }
            PackageJsonCompletionContributor.completeDependencies(parameters2, result2);
        }
    }

    private static void completeDependencies(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(3);
        }
        VirtualFile packageJson = parameters2.getOriginalFile().getVirtualFile();
        JsonProperty dependencyProperty = PackageJsonCommonUtil.findContainingProperty((PsiElement)parameters2.getPosition());
        if (packageJson != null && dependencyProperty != null && PackageJsonCommonUtil.isPackageDependencyProperty((JsonProperty)dependencyProperty)) {
            CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("priority"){

                @NotNull
                public Double weigh(@NotNull LookupElement element2) {
                    PrioritizedLookupElement ple;
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Double d = (ple = (PrioritizedLookupElement)ObjectUtils.tryCast((Object)element2, PrioritizedLookupElement.class)) != null ? ple.getPriority() : 0.0;
                    if (d == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return d;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "weigh";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "weigh";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            result2 = result2.withRelevanceSorter(sorter);
            JsonValue nameElement = dependencyProperty.getNameElement();
            if (nameElement.getTextRange().containsOffset(parameters2.getOffset())) {
                String prefix = PackageJsonCompletionUtil.findPrefix(parameters2, (PsiElement)nameElement);
                result2 = result2.withPrefixMatcher(prefix);
                PackageJsonCompletionContributor.completeDependenciesNames(parameters2, packageJson, result2, prefix);
            } else {
                String packageName = StringUtil.unquoteString((String)nameElement.getText());
                PackageJsonCompletionContributor.completeDependenciesVersions(parameters2, packageJson, result2, packageName);
            }
        }
    }

    private static void completeDependenciesNames(@NotNull CompletionParameters parameters2, @NotNull VirtualFile packageJson, @NotNull CompletionResultSet result2, @NotNull String packageNamePrefix) {
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(4);
        }
        if (packageJson == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(6);
        }
        if (packageNamePrefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(7);
        }
        Set<String> alreadyUsedNames = PackageJsonCompletionContributor.getUsedPackageNames(parameters2);
        AtomicInteger priority = new AtomicInteger(0);
        boolean wrapWithDoubleQuote = !PackageJsonCompletionContributor.isInsideStringLiteral(parameters2);
        PackageJsonCompletionUtil.searchPackagesByPrefix(parameters2.getPosition().getProject(), packageJson, packageNamePrefix, packageNamePrefix.isEmpty() ? 20 : 10, info -> !alreadyUsedNames.contains(info.getName()), info -> PackageJsonCompletionContributor.addPackageInfo(wrapWithDoubleQuote, result2, info, priority.getAndIncrement()));
        result2.restartCompletionOnAnyPrefixChange();
        result2.addLookupAdvertisement(JavaScriptBundle.message((String)"popup.advertisement.start.typing.package.name", (Object[])new Object[0]));
    }

    private static boolean isInsideStringLiteral(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(8);
        }
        return parameters2.getPosition().getParent() instanceof JsonStringLiteral;
    }

    private static void completeDependenciesVersions(@NotNull CompletionParameters parameters2, @NotNull VirtualFile packageJson, @NotNull CompletionResultSet result2, @NotNull String packageName) {
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(9);
        }
        if (packageJson == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(12);
        }
        String prefix = PackageJsonCompletionUtil.findPrefix(parameters2, parameters2.getPosition());
        result2 = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix, true));
        AvailablePackageVersions versions = PackageJsonCompletionContributor.fetchPackageVersions(parameters2.getPosition().getProject(), packageJson, packageName);
        int order = 0;
        String[] versionPrefixes = PackageJsonCompletionContributor.getVersionPrefixesSortedByRelevance(parameters2);
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (SemVer semVer : versions.getVersions()) {
            String[] distTag = versions.findDistTagByVersion(semVer);
            if (distTag == null && prefix.isEmpty() && parameters2.getInvocationCount() <= 1) continue;
            pairs.add("latest".equals(distTag) ? 0 : pairs.size(), Pair.create((Object)semVer, (Object)distTag));
        }
        for (Pair pair : pairs) {
            for (String versionPrefix : versionPrefixes) {
                PackageJsonCompletionContributor.addValueCompletionItem(parameters2, result2, versionPrefix, ((SemVer)pair.first).getRawVersion(), (String)pair.getSecond(), order++);
            }
        }
        if (!prefix.isEmpty() || parameters2.getInvocationCount() > 1) {
            for (Pair pair : versions.getDistTags()) {
                SemVer v = (SemVer)pair.getSecond();
                PackageJsonCompletionContributor.addValueCompletionItem(parameters2, result2, "", (String)pair.getFirst(), v != null ? v.getRawVersion() : null, order++);
            }
        }
        if (!pairs.isEmpty() && prefix.isEmpty()) {
            result2.addLookupAdvertisement(JavaScriptBundle.message((String)"popup.advertisement.latest.available.versions.for.all.distribution.tags", (Object[])new Object[0]));
        }
    }

    private static String @NotNull [] getVersionPrefixesSortedByRelevance(@NotNull CompletionParameters parameters2) {
        Object[] versionPrefixes;
        int ind;
        String versionPrefix;
        PsiElement element2;
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(13);
        }
        String text = StringUtil.unquoteString((String)((element2 = parameters2.getOriginalPosition()) != null ? element2.getText() : ""));
        String string = versionPrefix = text.isEmpty() ? "^" : text.substring(0, 1);
        if (Character.isDigit(versionPrefix.charAt(0))) {
            versionPrefix = "";
        }
        if ((ind = ArrayUtil.find((Object[])(versionPrefixes = new String[]{"^", "~", ""}), (Object)versionPrefix)) >= 0) {
            ArrayUtil.rotateRight((Object[])versionPrefixes, (int)0, (int)ind);
        }
        if (versionPrefixes == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(14);
        }
        return versionPrefixes;
    }

    private static void addPackageInfo(boolean wrapWithDoubleQuote, @NotNull CompletionResultSet result2, final @NotNull NodePackageBasicInfo info, int priority) {
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(15);
        }
        if (info == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(16);
        }
        Object lookupString = info.getName() + " ";
        if (wrapWithDoubleQuote) {
            lookupString = StringUtil.wrapWithDoubleQuote((String)lookupString);
        }
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)info, (String)lookupString);
        builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element2, @NotNull LookupElementPresentation presentation) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    2.$$$reportNull$$$0(1);
                }
                presentation.setItemText(info.getName());
                presentation.setTypeGrayed(true);
                presentation.setTypeText(info.getDescription());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$2";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(info.getName()));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder2.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)priority));
    }

    private static void addValueCompletionItem(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2, final @NotNull String itemTextPrefix, @NotNull String itemText, final @Nullable String typeText, int order) {
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(17);
        }
        if (result2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(18);
        }
        if (itemTextPrefix == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(19);
        }
        if (itemText == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(20);
        }
        final String value = itemTextPrefix + itemText;
        Object lookupString = PackageJsonCompletionContributor.isInsideStringLiteral(parameters2) ? value : StringUtil.wrapWithDoubleQuote((String)value);
        LookupElementBuilder builder2 = LookupElementBuilder.create((String)lookupString).withLookupString(value);
        builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(@NotNull LookupElement element2, @NotNull LookupElementPresentation presentation) {
                if (element2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    3.$$$reportNull$$$0(1);
                }
                presentation.setItemText((String)(itemTextPrefix.isEmpty() ? " " + value : value));
                presentation.setTypeGrayed(true);
                presentation.setTypeText(typeText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$3";
                objectArray[2] = "renderElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(value));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder2.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)order));
    }

    @NotNull
    private static AvailablePackageVersions fetchPackageVersions(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull String packageName) {
        AvailablePackageVersions availablePackageVersions;
        if (project == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(21);
        }
        if (packageJson == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(22);
        }
        if (packageName == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(23);
        }
        try {
            ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            availablePackageVersions = (AvailablePackageVersions)ApplicationUtil.runWithCheckCanceled(() -> {
                CompletableFuture<AvailablePackageVersions> future = NpmRegistryService.getInstance(project).getCachedOrFetchPackageVersionsFuture(packageName, packageJson);
                return (AvailablePackageVersions)ApplicationUtil.runWithCheckCanceled(future, (ProgressIndicator)indicator);
            }, (ProgressIndicator)indicator);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching versions for " + packageName + " cancelled");
            AvailablePackageVersions availablePackageVersions2 = AvailablePackageVersions.createEmpty();
            if (availablePackageVersions2 == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(25);
            }
            return availablePackageVersions2;
        }
        catch (Exception e) {
            LOG.info("Cannot fetch versions for " + packageName, (Throwable)e);
            AvailablePackageVersions availablePackageVersions3 = AvailablePackageVersions.createEmpty();
            if (availablePackageVersions3 == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(26);
            }
            return availablePackageVersions3;
        }
        if (availablePackageVersions == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(24);
        }
        return availablePackageVersions;
    }

    @NotNull
    private static Set<String> getUsedPackageNames(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(27);
        }
        PsiElement position = parameters2.getPosition();
        JsonProperty currentProperty = PackageJsonCommonUtil.findContainingProperty((PsiElement)position);
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)position.getContainingFile(), JsonFile.class);
        if (file == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PackageJsonCompletionContributor.$$$reportNull$$$0(28);
            }
            return set;
        }
        List props = PackageJsonCommonUtil.getAllDependencies((JsonFile)file);
        HashSet<String> usedNames = new HashSet<String>();
        for (JsonProperty prop : props) {
            if (prop == currentProperty) continue;
            usedNames.add(prop.getName());
        }
        HashSet<String> hashSet = usedNames;
        if (hashSet == null) {
            PackageJsonCompletionContributor.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 24, 25, 26, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 14: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextPrefix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemText";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionPrefixesSortedByRelevance";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchPackageVersions";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedPackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "completeDependencies";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStringLiteral";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesVersions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVersionPrefixesSortedByRelevance";
                break;
            }
            case 14: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addPackageInfo";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addValueCompletionItem";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageVersions";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getUsedPackageNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 24, 25, 26, 28, 29 -> new IllegalStateException(string);
        };
    }

    public static class DependencyCharFilter
    extends CharFilter {
        @Nullable
        public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
            if (lookup == null) {
                DependencyCharFilter.$$$reportNull$$$0(0);
            }
            if (!lookup.isCompletion()) {
                return null;
            }
            PsiElement element2 = lookup.getPsiElement();
            if (element2 != null && JsonLanguage.INSTANCE.equals(element2.getLanguage())) {
                if (StringUtil.containsChar((String)"@/-.^~", (char)c)) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c == '\"' && element2 instanceof PsiWhiteSpace) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c == ',') {
                    return prefixLength == 0 ? CharFilter.Result.HIDE_LOOKUP : CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionContributor$DependencyCharFilter", "acceptChar"));
        }
    }
}

