/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSHighlightingHandlersFactoryKt;
import com.intellij.lang.javascript.highlighting.JSKeywordHighlighterVisitor;
import com.intellij.lang.javascript.inspections.JSDefaultInspectionSuppressor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/JSHighlightingHandlersFactory;", "", "<init>", "()V", "createKeywordHighlighterVisitor", "Lcom/intellij/lang/javascript/highlighting/JSKeywordHighlighterVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "dialectOptionHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "getInspectionSuppressor", "Lcom/intellij/codeInspection/InspectionSuppressor;", "Companion", "intellij.javascript.backend"})
public class JSHighlightingHandlersFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LanguageExtension<JSHighlightingHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.highlightingHandlersFactory");

    @NotNull
    public JSKeywordHighlighterVisitor createKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder, @NotNull DialectOptionHolder dialectOptionHolder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)dialectOptionHolder, (String)"dialectOptionHolder");
        return new JSKeywordHighlighterVisitor(holder, dialectOptionHolder);
    }

    @NotNull
    public InspectionSuppressor getInspectionSuppressor() {
        JSDefaultInspectionSuppressor jSDefaultInspectionSuppressor = JSDefaultInspectionSuppressor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)jSDefaultInspectionSuppressor, (String)"INSTANCE");
        return jSDefaultInspectionSuppressor;
    }

    @JvmStatic
    @NotNull
    public static final JSHighlightingHandlersFactory forElement(@Nullable PsiElement element2) {
        return Companion.forElement(element2);
    }

    @JvmStatic
    @NotNull
    public static final JSHighlightingHandlersFactory forLanguage(@Nullable Language dialect) {
        return Companion.forLanguage(dialect);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/JSHighlightingHandlersFactory$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/lang/LanguageExtension;", "Lcom/intellij/lang/javascript/JSHighlightingHandlersFactory;", "getEP_NAME", "()Lcom/intellij/lang/LanguageExtension;", "forElement", "element", "Lcom/intellij/psi/PsiElement;", "forLanguage", "dialect", "Lcom/intellij/lang/Language;", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageExtension<JSHighlightingHandlersFactory> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        @NotNull
        public final JSHighlightingHandlersFactory forElement(@Nullable PsiElement element2) {
            PsiElement psiElement = element2;
            Language dialect = psiElement != null ? DialectDetector.languageOfElement((PsiElement)psiElement) : null;
            return this.forLanguage(dialect);
        }

        @JvmStatic
        @NotNull
        public final JSHighlightingHandlersFactory forLanguage(@Nullable Language dialect) {
            JSHighlightingHandlersFactory dialectSpecificFactory = dialect != null ? (JSHighlightingHandlersFactory)this.getEP_NAME().forLanguage(dialect) : null;
            JSHighlightingHandlersFactory jSHighlightingHandlersFactory = dialectSpecificFactory;
            if (jSHighlightingHandlersFactory == null) {
                jSHighlightingHandlersFactory = JSHighlightingHandlersFactoryKt.access$getDEFAULT_INSTANCE$p();
            }
            return jSHighlightingHandlersFactory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

