/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSShowTypeInfoAction
extends ExpressionTypeProvider<PsiElement> {
    public static final String UNKNOWN_TYPE_TEXT = "<unknown type>";

    public boolean hasAdvancedInformation() {
        return true;
    }

    @NotNull
    public String getAdvancedInformationHint(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(0);
        }
        return JSShowTypeInfoAction.getInformationHintWithAdvanced(element2, true);
    }

    @NotNull
    public String getInformationHint(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(1);
        }
        return JSShowTypeInfoAction.getInformationHintWithAdvanced(element2, false);
    }

    @NlsContexts.HintText
    @NotNull
    private static String getInformationHintWithAdvanced(@NotNull PsiElement element2, boolean advanced) {
        String typeFromService;
        if (element2 == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(2);
        }
        PsiFile file = element2.getContainingFile();
        FlowJSServerService service = FlowJSServerManager.getService(file);
        if ((element2 instanceof JSReferenceExpression || element2 instanceof JSVariable) && service != null && FlowJSSettingsManager.areOtherServicesEnabled(file) && (typeFromService = service.getTypeOfElementUnderProgress((JSElement)element2)) != null) {
            String string = typeFromService;
            if (string == null) {
                JSShowTypeInfoAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        JSType type2 = JSShowTypeInfoAction.expandTypesForPresentation(JSShowTypeInfoAction.getTypeForDocumentation(element2), element2);
        String presentableType = JSShowTypeInfoAction.getNonEmptyPresentableType(type2, (JSElement)element2);
        String string = XmlStringUtil.escapeString((String)presentableType) + (advanced ? JSShowTypeInfoAction.getEscapedMembersPresentation(type2) : "");
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static JSType getTypeForDocumentation(@NotNull PsiElement element2) {
        JSQualifiedName referenceName;
        JSType candidate;
        JSCallExpression callExpression;
        List functionTypes;
        PsiElement psiElement;
        if (element2 == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(5);
        }
        JSType type2 = null;
        if (element2 instanceof JSExpression) {
            type2 = JSResolveUtil.getExpressionJSType((JSExpression)((JSExpression)element2));
        } else if (element2 instanceof JSParameter) {
            type2 = ((JSParameter)element2).getJSType();
            if (type2 == null && ((JSParameter)element2).getTypeElement() == null) {
                type2 = JSContextTypeEvaluator.getParameterType((JSParameterListElement)((JSParameter)element2), (JSEvaluateContext)new JSEvaluateContext(element2.getContainingFile()), (JSExpectedTypeKind)JSExpectedTypeKind.CONTEXTUAL);
            }
        } else if (element2 instanceof JSTypeDeclarationOwner && ((type2 = ((JSTypeDeclarationOwner)element2).getJSType()) == null || type2 instanceof JSEvaluableOnlyType)) {
            type2 = JSResolveUtil.getElementJSType((PsiElement)element2);
            type2 = JSFormatUtil.adjustEvaluatedTypeForDocumentation((JSType)type2);
        }
        if (type2 != null && element2 instanceof JSExpression && (psiElement = element2.getParent()) instanceof JSCallExpression && (functionTypes = JSTypeUtils.getFunctionType((JSType)type2, (boolean)((callExpression = (JSCallExpression)psiElement) instanceof JSNewExpression), (PsiElement)callExpression).toList()).size() == 1 && (candidate = (JSType)functionTypes.getFirst()) instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)candidate;
            return (JSType)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)element2, () -> TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments((JSFunctionType)functionType, (JSCallItem)callExpression, (PsiElement)functionType.getSourceFunctionItem()));
        }
        if (element2 instanceof JSReferenceExpression && !DialectDetector.isTypeScript((PsiElement)element2) && type2 instanceof JSContextualUnionType && (referenceName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)element2))) != null) {
            String name = referenceName.getQualifiedName();
            List types2 = ((JSContextualUnionType)type2).getTypes();
            List filtered = ContainerUtil.filter((Collection)types2, t -> !(t instanceof JSTypeImpl) || !t.getTypeText(JSType.TypeTextFormat.SIMPLE).equals(name));
            if (filtered.size() != types2.size()) {
                type2 = JSCompositeTypeFactory.createContextualUnionType((Collection)filtered, (JSTypeSource)type2.getSource());
            }
        }
        return type2;
    }

    @NotNull
    public String getErrorHint() {
        String string = JavaScriptBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(7);
        }
        List list = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(o -> o instanceof JSExpression && (!(o instanceof JSFunctionExpression) || !((JSFunctionExpression)o).isArrowFunction()) && !(o instanceof JSDefinitionExpression) || o instanceof JSVariable).toList();
        if (list == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    @NlsSafe
    public static String getNonEmptyPresentableType(@Nullable JSType type2, @NotNull JSElement element2) {
        if (element2 == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            if (!DialectDetector.isTypeScript((PsiElement)element2)) {
                return UNKNOWN_TYPE_TEXT;
            }
            type2 = JSAnyType.get((PsiElement)element2);
        }
        String string = type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getEscapedMembersPresentation(@Nullable JSType type2) {
        if (!(type2 instanceof JSUnionOrIntersectionType) || StreamEx.of((Collection)((JSUnionOrIntersectionType)type2).getTypes()).anyMatch(el -> el instanceof JSAnyType)) {
            return "";
        }
        JSRecordType recordType = type2.asRecordType();
        List members = recordType.getTypeMembers();
        if (members.isEmpty()) {
            return "";
        }
        JSRecordTypeImpl wrappedRecordType = new JSRecordTypeImpl(recordType.getSource(), members){

            public void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
                if (format == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (builder2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                String separator = this.getTypeSeparator(format);
                char quote = this.getQuote();
                for (JSRecordType.TypeMember member : this.getTypeMembers()) {
                    builder2.append("<br>&nbsp;&nbsp;");
                    JSTypeTextStringBuilder subBuilder = new JSTypeTextStringBuilder();
                    member.appendMemberPresentation(format, (JSTypeTextBuilder)subBuilder, separator, quote);
                    builder2.append(XmlStringUtil.escapeString((String)subBuilder.getResult()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "format";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "builder";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction$1";
                objectArray[2] = "buildTypeTextImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        String string = wrappedRecordType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static JSType expandTypesForPresentation(@Nullable JSType type2, @Nullable PsiElement location) {
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)type2, (PsiElement)location);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHintWithAdvanced";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsAt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyPresentableType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedMembersPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdvancedInformationHint";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInformationHint";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInformationHintWithAdvanced";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForDocumentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyPresentableType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

