/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocMethodInfoBuilder;
import com.intellij.lang.javascript.documentation.JSDocParameterInfoBuilder;
import com.intellij.lang.javascript.documentation.JSDocParameterInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocSymbolInfoPrinter;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocMethodInfoPrinter
extends JSDocSymbolInfoPrinter<JSDocMethodInfoBuilder> {
    @NotNull
    private final JSFunctionItem myFunctionItem;

    public JSDocMethodInfoPrinter(@NotNull JSDocMethodInfoBuilder builder2, @NotNull JSFunctionItem functionItem, PsiElement element2, PsiElement _contextElement) {
        if (builder2 == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(0);
        }
        if (functionItem == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(1);
        }
        super(builder2, element2, _contextElement, false);
        this.myFunctionItem = functionItem;
        if (builder2.returnInfo.type == null) {
            builder2.returnInfo.type = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)functionItem, null);
        }
    }

    @Override
    protected void appendDefinitionDoc(@NotNull StringBuilder builder2, @NotNull JSQuickNavigateBuilder quickNavigateBuilder, @Nullable Ref<String> definitionDetails) {
        if (builder2 == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(2);
        }
        if (quickNavigateBuilder == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(3);
        }
        builder2.append(StringUtil.notNullize((String)quickNavigateBuilder.getContainerDefinition((PsiNamedElement)this.myFunctionItem)));
        builder2.append("<div class='definition'><pre>");
        StringBuilder options = new StringBuilder();
        JSDocMethodInfoPrinter.addJSDocVisibilityAndAccess(this.myBuilder, options);
        if (!options.isEmpty()) {
            builder2.append((CharSequence)options).append("<br>");
        }
        List parameterInfos = ContainerUtil.map((Object[])this.myFunctionItem.getParameters(), it -> new JSDocParameterInfoPrinter((JSParameterItem)it, ((JSDocMethodInfoBuilder)this.myBuilder).parameterInfoMap.get(it.getName())));
        builder2.append(quickNavigateBuilder.getFunctionDefinitionWithHighlighting(this.myFunctionItem, parameterInfos, ((JSDocMethodInfoBuilder)this.myBuilder).returnInfo, (PsiElement)ObjectUtils.coalesce((Object)this.contextElement, (Object)this.myElement), true));
        builder2.append("</pre></div>");
    }

    @Override
    protected void appendBodyDoc(@NotNull StringBuilder result2, boolean hasDefinition) {
        if (result2 == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(4);
        }
        this.appendParameters(result2, hasDefinition);
        this.appendReturns(result2, hasDefinition);
        JSDocMethodInfoPrinter.appendNamedSectionAndElements(((JSDocMethodInfoBuilder)this.myBuilder).throwsInfos, CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0]), result2);
        JSDocMethodInfoPrinter.appendNamedSectionAndElements(((JSDocMethodInfoBuilder)this.myBuilder).firesInfos, JavaScriptBundle.message((String)"js.documentation.fires", (Object[])new Object[0]), result2);
    }

    public void appendReturns(@NotNull StringBuilder result2, boolean hasDefinition) {
        if (result2 == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(5);
        }
        boolean hasJSDocReturnType = this.hasJSDocReturnType();
        if (((JSDocMethodInfoBuilder)this.myBuilder).returnInfo.hasDescription() || !hasDefinition && hasJSDocReturnType) {
            JSDocMethodInfoPrinter.startNamedSection(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0]), result2);
            result2.append("<td valign='top'>");
            Object description = ((JSDocMethodInfoBuilder)this.myBuilder).returnInfo.getFinalDescription();
            if (!hasDefinition && hasJSDocReturnType) {
                CharSequence returnTypeText = ((JSDocMethodInfoBuilder)this.myBuilder).returnInfo.getTypeString(this.myElement);
                description = String.valueOf(returnTypeText) + (String)(!((String)description).isEmpty() ? " - " + (String)description : "");
            }
            JSDocMethodInfoPrinter.addDescription((String)description, result2);
            result2.append("</td>");
        }
    }

    private boolean hasJSDocReturnType() {
        if (!((JSDocMethodInfoBuilder)this.myBuilder).returnInfo.hasType()) {
            return false;
        }
        JSFunctionItem jSFunctionItem = this.myFunctionItem;
        if (!(jSFunctionItem instanceof JSFunction)) {
            return true;
        }
        JSFunction item = (JSFunction)jSFunctionItem;
        return item.hasExplicitlyDeclaredReturnType() && item.getReturnTypeElement() == null;
    }

    public void appendParameters(@NotNull StringBuilder result2, boolean hasDefinition) {
        if (result2 == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(6);
        }
        if (!((JSDocMethodInfoBuilder)this.myBuilder).parameterInfoMap.isEmpty()) {
            boolean hasParamDoc = false;
            StringBuilder parametersBuilder = new StringBuilder();
            JSDocMethodInfoPrinter.startNamedSection(CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]), parametersBuilder);
            parametersBuilder.append("<td valign='top'>");
            for (Map.Entry<String, JSDocParameterInfoBuilder> parameterInfoEntry : ((JSDocMethodInfoBuilder)this.myBuilder).parameterInfoMap.entrySet()) {
                CharSequence typeString;
                JSDocParameterInfoBuilder parameterInfo = parameterInfoEntry.getValue();
                Object name = parameterInfoEntry.getKey();
                JSParameterItem parameterItem = name != null ? JSPsiImplUtils.findParameterByName((JSFunctionItem)this.myFunctionItem, (String)name) : null;
                JSDocParameterInfoPrinter printer = new JSDocParameterInfoPrinter(parameterItem, parameterInfo);
                Object description = printer.getDescriptionMergedWithConfigOptions();
                if (parameterInfo.defaultValue != null) {
                    description = (String)description + JSDocMethodInfoPrinter.buildCurrentOrDefaultValue(parameterInfo.defaultValue, false, true, null, false);
                }
                CharSequence charSequence = typeString = parameterInfo.hasType() && !printer.hasTypeElement() ? parameterInfo.getTypeString(this.myElement) : null;
                if (((String)description).isEmpty() && (hasDefinition || typeString == null)) continue;
                hasParamDoc = true;
                parametersBuilder.append("<p>");
                if (!hasDefinition && typeString != null) {
                    name = (String)name + ": " + String.valueOf(typeString);
                }
                JSDocMethodInfoPrinter.appendSingleNamedDescriptionSection((CharSequence)name, (CharSequence)description, parametersBuilder);
            }
            parametersBuilder.append("</td>");
            if (hasParamDoc) {
                result2.append((CharSequence)parametersBuilder);
            }
        }
    }

    public static void appendNamedSectionAndElements(@NotNull Collection<? extends JSDocBuilderSimpleInfo> infos, @NlsContexts.NotificationSubtitle @NotNull String sectionName, @NotNull StringBuilder builder2) {
        if (infos == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(7);
        }
        if (sectionName == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(8);
        }
        if (builder2 == null) {
            JSDocMethodInfoPrinter.$$$reportNull$$$0(9);
        }
        if (!infos.isEmpty()) {
            JSDocMethodInfoPrinter.startNamedSection(sectionName, builder2);
            builder2.append("<td valign='top'>");
            for (JSDocBuilderSimpleInfo jSDocBuilderSimpleInfo : infos) {
                builder2.append("<p>");
                if (jSDocBuilderSimpleInfo.hasType()) {
                    JSDocMethodInfoPrinter.appendSingleNamedDescriptionSection(jSDocBuilderSimpleInfo.getTypeString(null), jSDocBuilderSimpleInfo.getFinalDescription(), builder2);
                    continue;
                }
                builder2.append(jSDocBuilderSimpleInfo.getFinalDescription());
            }
            builder2.append("</td>");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickNavigateBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocMethodInfoPrinter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDefinitionDoc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBodyDoc";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendReturns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "appendNamedSectionAndElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

