/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.ecmascript6.resolve.JSProcessedPath;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.amd.JSAmdBaseUrlIndex;
import com.intellij.lang.javascript.frameworks.modules.JSDefaultModuleReferenceContributorKt;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceContributorUtil;
import com.intellij.lang.javascript.frameworks.modules.JSPackageJsonMappingContributorBase;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceAltResolver;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceContext;
import com.intellij.lang.javascript.index.JSCustomSingleEntriesIndex;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J7\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0004\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010!\u001a\u00020\bH\u0014\u00a2\u0006\u0002\u0010\"\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor;", "Lcom/intellij/lang/javascript/frameworks/modules/JSPackageJsonMappingContributorBase;", "<init>", "()V", "getAllReferences", "", "Lcom/intellij/psi/PsiReference;", "unquotedRefText", "", "host", "Lcom/intellij/psi/PsiElement;", "offset", "", "provider", "Lcom/intellij/psi/PsiReferenceProvider;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;ILcom/intellij/psi/PsiReferenceProvider;)[Lcom/intellij/psi/PsiReference;", "resolveReferences", "", "context", "getReferences", "modulePath", "index", "scheme", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;ILjava/lang/String;)[Lcom/intellij/psi/PsiReference;", "getDependencies", "", "unquoted", "isApplicable", "", "getLookupElements", "Lcom/intellij/codeInsight/lookup/LookupElement;", "unquotedEscapedText", "mergeWithStandardExtensions", "ext", "(Ljava/lang/String;)[Ljava/lang/String;", "Companion", "intellij.javascript.backend"})
@ApiStatus.NonExtendable
public class JSDefaultModuleReferenceContributor
extends JSPackageJsonMappingContributorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (JSUrlImportsUtil.startsWithRemoteUrlPrefix((String)unquotedRefText)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        JSProcessedPath jSProcessedPath = JSProcessedPath.getActualPath((String)unquotedRefText, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)jSProcessedPath, (String)"getActualPath(...)");
        JSProcessedPath actualPath = jSProcessedPath;
        String string = actualPath.fixedPath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fixedPath");
        String modulePath = string;
        int actualOffset = actualPath.fixedOffset;
        String scheme = JSFileReferencesUtil.findFileUrlPrefix((String)modulePath);
        if (scheme != null) {
            actualOffset += scheme.length();
            String string2 = modulePath.substring(scheme.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            modulePath = string2;
        }
        return this.getReferences(host, modulePath, actualOffset, scheme);
    }

    @NotNull
    public Collection<PsiElement> resolveReferences(@NotNull PsiElement context2, @NotNull String unquotedRefText) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        if (JSUrlImportsUtil.startsWithRemoteUrlPrefix((String)unquotedRefText)) {
            return SetsKt.emptySet();
        }
        String string = JSProcessedPath.getActualPathString((String)unquotedRefText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActualPathString(...)");
        String modulePath = string;
        String scheme = JSFileReferencesUtil.findFileUrlPrefix((String)modulePath);
        if (scheme != null) {
            String string2 = modulePath.substring(scheme.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            modulePath = string2;
        }
        JSDefaultFileReferenceContext referenceContext = JSDefaultModuleReferenceContributorKt.access$createReferenceContext(context2, modulePath, scheme);
        Collection<PsiElement> collection = JSDefaultFileReferenceAltResolver.resolvePsiElements(context2, referenceContext, modulePath);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolvePsiElements(...)");
        return collection;
    }

    @NotNull
    protected final PsiReference[] getReferences(@NotNull PsiElement host, @NotNull String modulePath, int index, @Nullable String scheme) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        FileReference[] fileReferenceArray = new JSModuleFileReferenceSet(modulePath, JSDefaultModuleReferenceContributorKt.access$createReferenceContext(host, modulePath, scheme), host, index).getAllReferences();
        Intrinsics.checkNotNullExpressionValue((Object)fileReferenceArray, (String)"getAllReferences(...)");
        return (PsiReference[])fileReferenceArray;
    }

    @NotNull
    public Collection<?> getDependencies(@NotNull String unquoted, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)unquoted, (String)"unquoted");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        ArrayList<Object> deps = new ArrayList<Object>();
        deps.add(TypeScriptConfigService.Provider.get((Project)host.getProject()).getTracker());
        Project project = host.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Companion.addNodeModulesDependencies(project2, (List<Object>)deps, unquoted);
        deps.add(JSModuleReferenceContributorUtil.getIndexModificationTracker(host, JSAmdBaseUrlIndex.KEY));
        deps.add(JSModuleReferenceContributorUtil.getFileBasedIndexModificationTracker(host, JSCustomSingleEntriesIndex.INDEX_ID));
        return deps;
    }

    public boolean isApplicable(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return !DialectDetector.isTypeScript((PsiElement)host);
    }

    @NotNull
    public Collection<LookupElement> getLookupElements(@NotNull String unquotedEscapedText, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)unquotedEscapedText, (String)"unquotedEscapedText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        VirtualFile virtualFile = NodeModuleUtil.getMainModuleRoot(host);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile placeRoot = virtualFile;
        PackageJsonData packageJsonData = this.getPackageJsonDataForRoot(placeRoot);
        if (packageJsonData == null) {
            return CollectionsKt.emptyList();
        }
        PackageJsonData packageJsonData2 = packageJsonData;
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings = packageJsonData2.getImports();
        Intrinsics.checkNotNullExpressionValue(jSModulePathMappings, (String)"getImports(...)");
        JSModulePathMappings<JSModulePathSubstitution> imports = jSModulePathMappings;
        if (imports.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(Companion.getMappedLookupElements(host), (Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)imports.getSubstitutions()), JSDefaultModuleReferenceContributor::getLookupElements$lambda$0), JSDefaultModuleReferenceContributor::getLookupElements$lambda$1)));
    }

    @Override
    @NotNull
    protected String[] mergeWithStandardExtensions(@NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return (String[])ArraysKt.plus((Object[])this.getTypeScriptExtensionsByJs(ext), (Object)ext);
    }

    private static final String getLookupElements$lambda$0(JSModulePathSubstitution it) {
        return it.isExact() ? it.getPattern() : it.getPathPrefix(it.getPattern());
    }

    private static final LookupElementBuilder getLookupElements$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LookupElementBuilder.create((String)it).withIcon(AllIcons.Nodes.Folder);
    }

    @JvmStatic
    public static final void addNodeModulesDependencies(@NotNull Project project, @NotNull List<Object> deps, @NotNull String unquoted) {
        Companion.addNodeModulesDependencies(project, deps, unquoted);
    }

    @JvmStatic
    @NotNull
    public static final Collection<LookupElement> getMappedLookupElements(@NotNull PsiElement host) {
        return Companion.getMappedLookupElements(host);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor$Companion;", "", "<init>", "()V", "addNodeModulesDependencies", "", "project", "Lcom/intellij/openapi/project/Project;", "deps", "", "unquoted", "", "getMappedLookupElements", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "host", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void addNodeModulesDependencies(@NotNull Project project, @NotNull List<Object> deps, @NotNull String unquoted) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(deps, (String)"deps");
            Intrinsics.checkNotNullParameter((Object)unquoted, (String)"unquoted");
            String string = JSProcessedPath.getActualPathString((String)unquoted);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActualPathString(...)");
            String modulePath = string;
            if (!JSFileReferencesUtil.isRelative((String)modulePath)) {
                ModificationTracker modificationTracker = NodeModulesDirectoryManager.getInstance(project).getNodeModulesDirChangeTracker();
                Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"getNodeModulesDirChangeTracker(...)");
                deps.add(modificationTracker);
                ModificationTracker modificationTracker2 = YarnPnpManager.getInstance(project).getYarnChangeTracker();
                Intrinsics.checkNotNullExpressionValue((Object)modificationTracker2, (String)"getYarnChangeTracker(...)");
                deps.add(modificationTracker2);
                ModificationTracker modificationTracker3 = PackageJsonFileManager.getInstance(project).getModificationTracker();
                Intrinsics.checkNotNullExpressionValue((Object)modificationTracker3, (String)"getModificationTracker(...)");
                deps.add(modificationTracker3);
            }
        }

        @JvmStatic
        @NotNull
        public final Collection<LookupElement> getMappedLookupElements(@NotNull PsiElement host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)host);
            if (file == null) {
                return CollectionsKt.emptyList();
            }
            TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile((PsiFile)host.getContainingFile(), (boolean)true);
            if (config == null) {
                return CollectionsKt.emptyList();
            }
            JSModulePathMappings jSModulePathMappings = config.getPathMappings();
            Intrinsics.checkNotNullExpressionValue((Object)jSModulePathMappings, (String)"getPathMappings(...)");
            JSModulePathMappings paths = jSModulePathMappings;
            if (paths.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            SmartList result2 = new SmartList();
            for (JSModulePathSubstitution substitution : paths.getSubstitutions()) {
                LookupElementBuilder newBuilder;
                String variant;
                String string;
                String pattern;
                Intrinsics.checkNotNullExpressionValue((Object)substitution.getPattern(), (String)"getPattern(...)");
                boolean hasStar = StringsKt.contains$default((CharSequence)pattern, (CharSequence)"*", (boolean)false, (int)2, null);
                if (hasStar && !JSPathMappingsUtil.isPatternOrMappingEndsWithStar((String)pattern)) continue;
                if (hasStar) {
                    String string2 = pattern.substring(0, pattern.length() - 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = pattern;
                }
                if (((CharSequence)(variant = string)).length() == 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)variant), (String)"create(...)");
                result2.add((Object)newBuilder.withIcon(AllIcons.Nodes.Folder));
            }
            return (Collection)result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

