/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "", "startOffset", "", "endOffset", "text", "", "<init>", "(IILjava/lang/String;)V", "getStartOffset", "()I", "getEndOffset", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Parser", "intellij.javascript.backend"})
@ApiStatus.Experimental
public final class JSParsedPathElement {
    @NotNull
    public static final Parser Parser = new Parser(null);
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private final String text;

    public JSParsedPathElement(int startOffset, int endOffset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.text = text;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int component1() {
        return this.startOffset;
    }

    public final int component2() {
        return this.endOffset;
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @NotNull
    public final JSParsedPathElement copy(int startOffset, int endOffset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new JSParsedPathElement(startOffset, endOffset, text);
    }

    public static /* synthetic */ JSParsedPathElement copy$default(JSParsedPathElement jSParsedPathElement, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = jSParsedPathElement.startOffset;
        }
        if ((n3 & 2) != 0) {
            n2 = jSParsedPathElement.endOffset;
        }
        if ((n3 & 4) != 0) {
            string = jSParsedPathElement.text;
        }
        return jSParsedPathElement.copy(n, n2, string);
    }

    @NotNull
    public String toString() {
        return "JSParsedPathElement(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", text=" + this.text + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.startOffset);
        result2 = result2 * 31 + Integer.hashCode(this.endOffset);
        result2 = result2 * 31 + this.text.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSParsedPathElement)) {
            return false;
        }
        JSParsedPathElement jSParsedPathElement = (JSParsedPathElement)other;
        if (this.startOffset != jSParsedPathElement.startOffset) {
            return false;
        }
        if (this.endOffset != jSParsedPathElement.endOffset) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)jSParsedPathElement.text);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement$Parser;", "", "<init>", "()V", "parseReferenceText", "", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "referenceText", "", "isUrlEncoded", "", "(Ljava/lang/String;Z)[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "decodeValue", "value", "intellij.javascript.backend"})
    public static final class Parser {
        private Parser() {
        }

        @NotNull
        public final JSParsedPathElement[] parseReferenceText(@NotNull String referenceText, boolean isUrlEncoded) {
            Intrinsics.checkNotNullParameter((Object)referenceText, (String)"referenceText");
            int globalOffset = 0;
            if (StringsKt.startsWith$default((CharSequence)referenceText, (char)'/', (boolean)false, (int)2, null)) {
                globalOffset = 1;
            }
            if (referenceText.length() == globalOffset) {
                JSParsedPathElement[] jSParsedPathElementArray = new JSParsedPathElement[]{new JSParsedPathElement(globalOffset, globalOffset, "")};
                return jSParsedPathElementArray;
            }
            int numberOfElement = StringUtil.countChars((CharSequence)referenceText, (char)'/') - globalOffset;
            if (numberOfElement == 0) {
                JSParsedPathElement[] jSParsedPathElementArray = new JSParsedPathElement[1];
                int n = referenceText.length();
                String string = referenceText.substring(globalOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                jSParsedPathElementArray[0] = new JSParsedPathElement(globalOffset, n, this.decodeValue(string, isUrlEncoded));
                return jSParsedPathElementArray;
            }
            int start = globalOffset;
            int end = StringsKt.indexOf$default((CharSequence)referenceText, (char)'/', (int)globalOffset, (boolean)false, (int)4, null);
            int n = numberOfElement + 1;
            JSParsedPathElement[] jSParsedPathElementArray = new JSParsedPathElement[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                String string = referenceText.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                JSParsedPathElement result2 = new JSParsedPathElement(start, end, Parser.decodeValue(string, isUrlEncoded));
                int next = referenceText.length() - 1 == end ? referenceText.length() : StringsKt.indexOf$default((CharSequence)referenceText, (char)'/', (int)(end + 1), (boolean)false, (int)4, null);
                start = end + 1;
                end = next == -1 ? referenceText.length() : next;
                jSParsedPathElementArray[n2] = result2;
            }
            JSParsedPathElement[] array = jSParsedPathElementArray;
            return array;
        }

        private final String decodeValue(String value, boolean isUrlEncoded) {
            String string;
            String string2 = StringsKt.contains$default((CharSequence)value, (char)'\\', (boolean)false, (int)2, null) ? JSStringUtil.unescapeStringLiteralValue((String)value) : value;
            Intrinsics.checkNotNull((Object)string2);
            String unescaped = string2;
            if (isUrlEncoded) {
                String string3 = JSFileReferencesUtil.decodePathChars((String)unescaped);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"decodePathChars(...)");
            } else {
                string = unescaped;
            }
            return string;
        }

        static /* synthetic */ String decodeValue$default(Parser parser, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return parser.decodeValue(string, bl);
        }

        public /* synthetic */ Parser(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

