/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/ESLintFlatConfigData;", "", "flatConfigMode", "", "flatConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(ZLcom/intellij/openapi/vfs/VirtualFile;)V", "getFlatConfigMode", "()Z", "getFlatConfigFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "intellij.javascript.backend"})
public final class ESLintFlatConfigData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean flatConfigMode;
    @Nullable
    private final VirtualFile flatConfigFile;

    public ESLintFlatConfigData(boolean flatConfigMode, @Nullable VirtualFile flatConfigFile) {
        this.flatConfigMode = flatConfigMode;
        this.flatConfigFile = flatConfigFile;
    }

    public final boolean getFlatConfigMode() {
        return this.flatConfigMode;
    }

    @Nullable
    public final VirtualFile getFlatConfigFile() {
        return this.flatConfigFile;
    }

    public final boolean component1() {
        return this.flatConfigMode;
    }

    @Nullable
    public final VirtualFile component2() {
        return this.flatConfigFile;
    }

    @NotNull
    public final ESLintFlatConfigData copy(boolean flatConfigMode, @Nullable VirtualFile flatConfigFile) {
        return new ESLintFlatConfigData(flatConfigMode, flatConfigFile);
    }

    public static /* synthetic */ ESLintFlatConfigData copy$default(ESLintFlatConfigData eSLintFlatConfigData, boolean bl, VirtualFile virtualFile, int n, Object object) {
        if ((n & 1) != 0) {
            bl = eSLintFlatConfigData.flatConfigMode;
        }
        if ((n & 2) != 0) {
            virtualFile = eSLintFlatConfigData.flatConfigFile;
        }
        return eSLintFlatConfigData.copy(bl, virtualFile);
    }

    @NotNull
    public String toString() {
        return "ESLintFlatConfigData(flatConfigMode=" + this.flatConfigMode + ", flatConfigFile=" + this.flatConfigFile + ")";
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.flatConfigMode);
        result2 = result2 * 31 + (this.flatConfigFile == null ? 0 : this.flatConfigFile.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ESLintFlatConfigData)) {
            return false;
        }
        ESLintFlatConfigData eSLintFlatConfigData = (ESLintFlatConfigData)other;
        if (this.flatConfigMode != eSLintFlatConfigData.flatConfigMode) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.flatConfigFile, (Object)eSLintFlatConfigData.flatConfigFile);
    }

    @JvmStatic
    @NotNull
    public static final ESLintFlatConfigData determineFlatConfig(@NotNull Project project, @Nullable VirtualFile specifiedConfigFile, @Nullable SemVer packageVersion, @NotNull VirtualFile workingDirectory) {
        return Companion.determineFlatConfig(project, specifiedConfigFile, packageVersion, workingDirectory);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0007J\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/ESLintFlatConfigData$Companion;", "", "<init>", "()V", "determineFlatConfig", "Lcom/intellij/lang/javascript/linter/eslint/ESLintFlatConfigData;", "project", "Lcom/intellij/openapi/project/Project;", "specifiedConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageVersion", "Lcom/intellij/util/text/SemVer;", "workingDirectory", "determineConfigFromSpecifiedFile", "determineConfigFromProject", "findFirstFlatConfigFile", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ESLintFlatConfigData determineFlatConfig(@NotNull Project project, @Nullable VirtualFile specifiedConfigFile, @Nullable SemVer packageVersion, @NotNull VirtualFile workingDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
            return specifiedConfigFile != null ? this.determineConfigFromSpecifiedFile(specifiedConfigFile, packageVersion) : this.determineConfigFromProject(project, packageVersion, workingDirectory);
        }

        private final ESLintFlatConfigData determineConfigFromSpecifiedFile(VirtualFile specifiedConfigFile, SemVer packageVersion) {
            boolean isCustomFlatConfigFile = !EslintUtil.isCustomLegacyConfigFileName(specifiedConfigFile.getName());
            boolean flatConfigMode = EslintUtil.isUseFlatConfigMode(packageVersion, isCustomFlatConfigFile);
            return new ESLintFlatConfigData(flatConfigMode, specifiedConfigFile);
        }

        private final ESLintFlatConfigData determineConfigFromProject(Project project, SemVer packageVersion, VirtualFile workingDirectory) {
            VirtualFile flatConfigFile = this.findFirstFlatConfigFile(project, workingDirectory);
            boolean flatConfigMode = EslintUtil.isUseFlatConfigMode(packageVersion, flatConfigFile != null);
            return new ESLintFlatConfigData(flatConfigMode, flatConfigFile);
        }

        private final VirtualFile findFirstFlatConfigFile(Project project, VirtualFile workingDirectory) {
            Ref.ObjectRef foundFlatConfigFile = new Ref.ObjectRef();
            JSProjectUtil.processDirectoriesUpToContentRoot(project, workingDirectory, (Processor<? super VirtualFile>)((Processor)arg_0 -> Companion.findFirstFlatConfigFile$lambda$1(arg_0 -> Companion.findFirstFlatConfigFile$lambda$0(foundFlatConfigFile, arg_0), arg_0)));
            return (VirtualFile)foundFlatConfigFile.element;
        }

        private static final boolean findFirstFlatConfigFile$lambda$0$0(VirtualFile child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return EslintUtil.isFlatConfigFileName(child.getName());
        }

        private static final boolean findFirstFlatConfigFile$lambda$0(Ref.ObjectRef $foundFlatConfigFile, VirtualFile dir) {
            boolean bl;
            List list = VfsUtil.getChildren((VirtualFile)dir, Companion::findFirstFlatConfigFile$lambda$0$0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            List flatConfigs = list;
            if (!((Collection)flatConfigs).isEmpty()) {
                $foundFlatConfigFile.element = CollectionsKt.first((List)flatConfigs);
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        private static final boolean findFirstFlatConfigFile$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

