/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeInsight.hints.declarative.CollapseState;
import com.intellij.codeInsight.hints.declarative.CollapsiblePresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.HintColorKind;
import com.intellij.codeInsight.hints.declarative.HintFontSize;
import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.HintMarginPadding;
import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.PsiPointerInlayActionPayload;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.InlayHintItem;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.InlayHintItemDisplayPart;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.InlayHintKind;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.editing.GetInlayHintsPreferencesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\r\u001a3\u0010\u000e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a \u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u001a\u0010(\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\fH\u0002\"\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"buildHintFromServiceItem", "", "hintItem", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItem;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "getParts", "", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItemDisplayPart;", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItem;)[Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItemDisplayPart;", "splitPartsToVisibleAndCollapsed", "Lkotlin/Pair;", "", "parts", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItemDisplayPart;)Lkotlin/Pair;", "parameterHintFormat", "Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "getParameterHintFormat", "()Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "otherHintFormat", "isFilterOutFunctionParamType", "", "offset", "", "isSingleNonParenthesizedParam", "element", "Lcom/intellij/psi/PsiElement;", "isParenthesizedParameter", "getSimpleTypeScriptParameter", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptParameter;", "buildHintFromDisplayPart", "part", "project", "Lcom/intellij/openapi/project/Project;", "builder", "Lcom/intellij/codeInsight/hints/declarative/PresentationTreeBuilder;", "getTargetElement", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nbuildHintFromServiceItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildHintFromServiceItem.kt\ncom/intellij/lang/typescript/editing/BuildHintFromServiceItemKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1#2:179\n1915#3,2:180\n1915#3,2:182\n*S KotlinDebug\n*F\n+ 1 buildHintFromServiceItem.kt\ncom/intellij/lang/typescript/editing/BuildHintFromServiceItemKt\n*L\n52#1:180,2\n46#1:182,2\n*E\n"})
public final class BuildHintFromServiceItemKt {
    @NotNull
    private static final HintFormat parameterHintFormat = HintFormat.Companion.getDefault().withFontSize(HintFontSize.ABitSmallerThanInEditor).withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding).withColorKind(HintColorKind.Parameter);
    @NotNull
    private static final HintFormat otherHintFormat = HintFormat.Companion.getDefault().withFontSize(HintFontSize.ABitSmallerThanInEditor).withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding);

    @RequiresReadLock
    public static final void buildHintFromServiceItem(@NotNull InlayHintItem hintItem, @NotNull Document document, @NotNull PsiFile file, @NotNull InlayTreeSink sink) {
        Intrinsics.checkNotNullParameter((Object)hintItem, (String)"hintItem");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        InlayHintItemDisplayPart[] parts = BuildHintFromServiceItemKt.getParts(hintItem);
        if (parts.length == 0) {
            return;
        }
        Pair<List<InlayHintItemDisplayPart>, List<InlayHintItemDisplayPart>> pair = BuildHintFromServiceItemKt.splitPartsToVisibleAndCollapsed(parts);
        List visibleParts = (List)pair.component1();
        List collapsedParts = (List)pair.component2();
        TypeScriptResponseCommon.Location location = hintItem.position;
        if (location == null) {
            return;
        }
        TypeScriptResponseCommon.Location position = location;
        int offset = document.getLineStartOffset(position.line - 1) + position.offset - 1;
        if (hintItem.kind == InlayHintKind.Type && BuildHintFromServiceItemKt.isFilterOutFunctionParamType(file, offset)) {
            return;
        }
        boolean relatedToPrevious = hintItem.kind != InlayHintKind.Parameter;
        InlayHintKind inlayHintKind = hintItem.kind;
        HintFormat hintFormat = (inlayHintKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[inlayHintKind.ordinal()]) == 1 ? parameterHintFormat : otherHintFormat;
        InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(offset, relatedToPrevious, 0, 4, null)), null, null, (HintFormat)hintFormat, arg_0 -> BuildHintFromServiceItemKt.buildHintFromServiceItem$lambda$0(visibleParts, collapsedParts, file, arg_0), (int)6, null);
    }

    private static final InlayHintItemDisplayPart[] getParts(InlayHintItem hintItem) {
        InlayHintItemDisplayPart[] parts;
        boolean bl = parts != null ? !((parts = hintItem.displayParts).length == 0) : false;
        if (bl) {
            return parts;
        }
        String plainText = hintItem.text;
        CharSequence charSequence = plainText;
        if (charSequence == null || charSequence.length() == 0) {
            return new InlayHintItemDisplayPart[0];
        }
        InlayHintItemDisplayPart single = new InlayHintItemDisplayPart();
        single.text = plainText;
        InlayHintItemDisplayPart[] inlayHintItemDisplayPartArray = new InlayHintItemDisplayPart[]{single};
        return inlayHintItemDisplayPartArray;
    }

    private static final Pair<List<InlayHintItemDisplayPart>, List<InlayHintItemDisplayPart>> splitPartsToVisibleAndCollapsed(InlayHintItemDisplayPart[] parts) {
        int quota = Integer.parseInt(Registry.Companion.stringValue("typescript.service.provideInlayHints.maxLength"));
        List visibleParts = new ArrayList();
        List collapsedParts = new ArrayList();
        for (InlayHintItemDisplayPart part : parts) {
            String string = part.text;
            if (string == null) {
                string = "";
            }
            String currentText = string;
            int visibleLength = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)quota, (int)currentText.length()), (int)30);
            String string2 = currentText.substring(0, visibleLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            BuildHintFromServiceItemKt.splitPartsToVisibleAndCollapsed$addFragmentIfNotEmpty(part, string2, visibleParts);
            String string3 = currentText.substring(visibleLength);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            BuildHintFromServiceItemKt.splitPartsToVisibleAndCollapsed$addFragmentIfNotEmpty(part, string3, collapsedParts);
            quota = visibleLength == currentText.length() ? quota - visibleLength : 0;
        }
        return TuplesKt.to((Object)visibleParts, (Object)collapsedParts);
    }

    @NotNull
    public static final HintFormat getParameterHintFormat() {
        return parameterHintFormat;
    }

    private static final boolean isFilterOutFunctionParamType(PsiFile file, int offset) {
        PsiElement psiElement = file.findElementAt(offset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement element2 = psiElement;
        if (!GetInlayHintsPreferencesKt.isTypeHintOptionEnabled("non.paren.single.param") && BuildHintFromServiceItemKt.isSingleNonParenthesizedParam(element2)) {
            return true;
        }
        return !GetInlayHintsPreferencesKt.isTypeHintOptionEnabled("parameters.in.parens") && BuildHintFromServiceItemKt.isParenthesizedParameter(element2);
    }

    public static final boolean isSingleNonParenthesizedParam(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        TypeScriptParameter typeScriptParameter = BuildHintFromServiceItemKt.getSimpleTypeScriptParameter(element2);
        if (typeScriptParameter == null) {
            return false;
        }
        TypeScriptParameter parameter = typeScriptParameter;
        PsiElement psiElement = parameter.getParent();
        JSParameterList jSParameterList = psiElement instanceof JSParameterList ? (JSParameterList)psiElement : null;
        if (jSParameterList == null) {
            return false;
        }
        JSParameterList parameterList = jSParameterList;
        return parameterList.getParameters().length == 1 && Intrinsics.areEqual((Object)parameterList.getFirstChild(), (Object)parameter);
    }

    private static final boolean isParenthesizedParameter(PsiElement element2) {
        TypeScriptParameter typeScriptParameter = BuildHintFromServiceItemKt.getSimpleTypeScriptParameter(element2);
        if (typeScriptParameter == null) {
            return false;
        }
        TypeScriptParameter parameter = typeScriptParameter;
        PsiElement psiElement = parameter.getParent();
        JSParameterList jSParameterList = psiElement instanceof JSParameterList ? (JSParameterList)psiElement : null;
        if (jSParameterList == null) {
            return false;
        }
        JSParameterList parameterList = jSParameterList;
        JSParameterListElement[] jSParameterListElementArray = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jSParameterListElementArray, (String)"getParameters(...)");
        JSParameterListElement jSParameterListElement = (JSParameterListElement)ArraysKt.firstOrNull((Object[])jSParameterListElementArray);
        if (jSParameterListElement == null) {
            return false;
        }
        JSParameterListElement firstParam = jSParameterListElement;
        ASTNode aSTNode = parameterList.getNode().findChildByType(JSTokenTypes.LPAR);
        if (aSTNode == null) {
            return false;
        }
        ASTNode lp = aSTNode;
        return lp.getStartOffset() < PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)firstParam));
    }

    @Nullable
    public static final TypeScriptParameter getSimpleTypeScriptParameter(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Object object = element2 instanceof TypeScriptParameter ? (TypeScriptParameter)element2 : null;
        if (object == null) {
            PsiElement psiElement = element2.getParent();
            object = psiElement instanceof TypeScriptParameter ? (TypeScriptParameter)psiElement : null;
        }
        return object;
    }

    private static final void buildHintFromDisplayPart(InlayHintItemDisplayPart part, Project project, PresentationTreeBuilder builder2) {
        String string = part.text;
        if (string == null) {
            return;
        }
        String text = string;
        PsiElement targetElement = BuildHintFromServiceItemKt.getTargetElement(project, part);
        if (targetElement != null) {
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)targetElement);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
            SmartPsiElementPointer pointer = smartPsiElementPointer;
            builder2.text(text, new InlayActionData((InlayActionPayload)new PsiPointerInlayActionPayload(pointer), "psi.pointer.navigation.handler"));
        } else {
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)builder2, (String)text, null, (int)2, null);
        }
    }

    private static final PsiElement getTargetElement(Project project, InlayHintItemDisplayPart part) {
        VirtualFile virtualFile;
        block8: {
            block7: {
                TypeScriptResponseCommon.FileSpan fileSpan = part.span;
                LocalFilePath it = fileSpan != null ? fileSpan.file : null;
                boolean bl = false;
                Path path2 = LocalFilePath.Companion.getNioPath(it);
                if (path2 == null) break block7;
                Path it2 = path2;
                boolean bl2 = false;
                virtualFile = VirtualFileManager.getInstance().findFileByNioPath(it2);
                if (virtualFile != null) break block8;
            }
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Object object = part.span;
        if (object == null || (object = ((TypeScriptResponseCommon.FileSpan)object).start) == null) {
            return null;
        }
        Object startLocation = object;
        Object object2 = part.span;
        if (object2 == null || (object2 = ((TypeScriptResponseCommon.FileSpan)object2).end) == null) {
            return null;
        }
        Object endLocation = object2;
        int startOffset = document2.getLineStartOffset(((TypeScriptResponseCommon.Location)startLocation).line - 1) + ((TypeScriptResponseCommon.Location)startLocation).offset - 1;
        int endOffset = document2.getLineStartOffset(((TypeScriptResponseCommon.Location)endLocation).line - 1) + ((TypeScriptResponseCommon.Location)endLocation).offset - 1;
        return JSimportUtilKt.getParentOfLine(psiFile2, new TextRange(startOffset, endOffset));
    }

    private static final Unit buildHintFromServiceItem$lambda$0$2$0(PresentationTreeBuilder $this$toggleButton) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleButton, (String)"$this$toggleButton");
        PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$toggleButton, (String)"...", null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit buildHintFromServiceItem$lambda$0$1(List $collapsedParts, PsiFile $file, CollapsiblePresentationTreeBuilder $this$collapsibleList) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleList, (String)"$this$collapsibleList");
        Iterable $this$forEach$iv = $collapsedParts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InlayHintItemDisplayPart it = (InlayHintItemDisplayPart)element$iv;
            boolean bl = false;
            Project project = $file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BuildHintFromServiceItemKt.buildHintFromDisplayPart(it, project, (PresentationTreeBuilder)$this$collapsibleList);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildHintFromServiceItem$lambda$0$2(CollapsiblePresentationTreeBuilder $this$collapsibleList) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleList, (String)"$this$collapsibleList");
        $this$collapsibleList.toggleButton(BuildHintFromServiceItemKt::buildHintFromServiceItem$lambda$0$2$0);
        return Unit.INSTANCE;
    }

    private static final Unit buildHintFromServiceItem$lambda$0(List $visibleParts, List $collapsedParts, PsiFile $file, PresentationTreeBuilder $this$addPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
        Iterable $this$forEach$iv = $visibleParts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InlayHintItemDisplayPart it = (InlayHintItemDisplayPart)element$iv;
            boolean bl = false;
            Project project = $file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BuildHintFromServiceItemKt.buildHintFromDisplayPart(it, project, $this$addPresentation);
        }
        if (!((Collection)$collapsedParts).isEmpty()) {
            $this$addPresentation.collapsibleList(CollapseState.Collapsed, arg_0 -> BuildHintFromServiceItemKt.buildHintFromServiceItem$lambda$0$1($collapsedParts, $file, arg_0), BuildHintFromServiceItemKt::buildHintFromServiceItem$lambda$0$2);
        }
        return Unit.INSTANCE;
    }

    private static final void splitPartsToVisibleAndCollapsed$addFragmentIfNotEmpty(InlayHintItemDisplayPart part, String fragmentText, List<InlayHintItemDisplayPart> dest) {
        if (((CharSequence)fragmentText).length() > 0) {
            InlayHintItemDisplayPart inlayHintItemDisplayPart;
            Collection collection = dest;
            InlayHintItemDisplayPart $this$splitPartsToVisibleAndCollapsed_u24addFragmentIfNotEmpty_u24lambda_u240 = inlayHintItemDisplayPart = new InlayHintItemDisplayPart();
            boolean bl = false;
            $this$splitPartsToVisibleAndCollapsed_u24addFragmentIfNotEmpty_u24lambda_u240.text = fragmentText;
            $this$splitPartsToVisibleAndCollapsed_u24addFragmentIfNotEmpty_u24lambda_u240.span = part.span;
            collection.add(inlayHintItemDisplayPart);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InlayHintKind.values().length];
            try {
                nArray[InlayHintKind.Parameter.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

