/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.checkers;

import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSConfigIncludeBase;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0082\u0004J\n\u0010 \u001a\u00020!H\u0096\u0080\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase;", "Lcom/intellij/lang/javascript/config/JSConfigIncludeBase;", "config", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "<init>", "(Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;)V", "hasTypes", "", "typeRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "types", "", "excludeMatchers", "Ljava/nio/file/PathMatcher;", "excludePatterns", "excludePatternsContainNodeModules", "isFromFilesList", "file", "getRootScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "isExcludedPath", "path", "Ljava/nio/file/Path;", "getAdditionalRootFiles", "", "getScope", "equals", "o", "", "hashCode", "", "Companion", "intellij.javascript.backend"})
public abstract class TypeScriptConfigIncludeBase
extends JSConfigIncludeBase {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean hasTypes;
    @NotNull
    private final Collection<VirtualFile> typeRoots;
    @NotNull
    private final Collection<String> types;
    @JvmField
    @Nullable
    protected final PathMatcher excludeMatchers;
    @NotNull
    private final Collection<String> excludePatterns;
    @JvmField
    protected final boolean excludePatternsContainNodeModules;

    public TypeScriptConfigIncludeBase(@NotNull TypeScriptConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((JSConfig)config);
        this.hasTypes = config.getRawCompilerOption("types") != null;
        Collection collection = config.getTypeRoots();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTypeRoots(...)");
        this.typeRoots = collection;
        Collection collection2 = config.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getTypes(...)");
        this.types = collection2;
        this.excludeMatchers = TypeScriptConfigUtil.getExcludeMatchers((TypeScriptConfig)config);
        Collection collection3 = config.getExcludePatterns();
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getExcludePatterns(...)");
        this.excludePatterns = collection3;
        this.excludePatternsContainNodeModules = TypeScriptConfigUtil.areExcludePatternsContainNodeModules((TypeScriptConfig)config);
    }

    public boolean isFromFilesList(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return false;
    }

    @Override
    @NotNull
    public GlobalSearchScope getRootScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getScope(project);
    }

    public final boolean isExcludedPath(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.excludeMatchers != null && this.excludeMatchers.matches(path2);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAdditionalRootFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.hasTypes && this.types.isEmpty()) {
            return SetsKt.emptySet();
        }
        VirtualFile virtualFile = this.myConfigDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"myConfigDirectory");
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)TypeScriptConfigIncludeBase.Companion.calcTypeFiles(this.typeRoots, this.types, virtualFile)), TypeScriptConfigIncludeBase::getAdditionalRootFiles$lambda$0));
    }

    private final GlobalSearchScope getScope(Project project) {
        GlobalSearchScope globalSearchScope = DelegatingGlobalSearchScope.allScope((Project)project);
        return (GlobalSearchScope)new DelegatingGlobalSearchScope(this, globalSearchScope){
            final /* synthetic */ TypeScriptConfigIncludeBase this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean contains(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!super.contains(file)) {
                    return false;
                }
                return this.this$0.accept(file);
            }
        };
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeScriptConfigIncludeBase base = (TypeScriptConfigIncludeBase)o;
        return this.hasTypes == base.hasTypes && Intrinsics.areEqual(this.typeRoots, base.typeRoots) && Intrinsics.areEqual(this.types, base.types) && Intrinsics.areEqual(this.excludePatterns, base.excludePatterns);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.typeRoots, this.types, this.excludePatterns, this.hasTypes};
        return Objects.hash(objectArray);
    }

    private static final boolean getAdditionalRootFiles$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\b\t\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\nH\u0002J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$Companion;", "", "<init>", "()V", "resolveTypesForRoot", "", "typesNames", "", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "visited", "", "result", "", "findDeclarationsFile", "path", "base", "calcTypeFiles", "typeRoots", "typeNames", "configDirectory", "calcAllTypeFiles", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptConfigIncludeBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptConfigIncludeBase.kt\ncom/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,191:1\n1#2:192\n1#2:201\n777#3:193\n873#3,2:194\n777#3:196\n873#3,2:197\n1172#4:199\n1342#4:200\n1343#4:202\n1173#4:203\n*S KotlinDebug\n*F\n+ 1 TypeScriptConfigIncludeBase.kt\ncom/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$Companion\n*L\n185#1:201\n170#1:193\n170#1:194,2\n172#1:196\n172#1:197,2\n185#1:199\n185#1:200\n185#1:202\n185#1:203\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final void resolveTypesForRoot(Collection<String> typesNames, VirtualFile root, Set<String> visited, List<VirtualFile> result2) {
            if (!root.isValid() || typesNames.isEmpty()) {
                return;
            }
            TypeScriptNodeSearchProcessor processor = new TypeScriptNodeSearchProcessor(TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
            for (String type2 : typesNames) {
                VirtualFile typesCandidate;
                VirtualFile directory;
                ProgressManager.checkCanceled();
                if (visited.contains(type2)) continue;
                VirtualFile virtualFile = VfsUtilCore.findRelativeFile((String)type2, (VirtualFile)root);
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile it = virtualFile2 = virtualFile;
                    boolean bl = false;
                    v0 = it.isDirectory() ? virtualFile2 : null;
                } else {
                    v0 = directory = null;
                }
                if ((typesCandidate = directory != null ? JSExactFileReference.resolveForNpmPackages(directory, (JSDirectorySearchProcessor)processor) : this.findDeclarationsFile(type2, root)) == null) continue;
                result2.add(typesCandidate);
                visited.add(type2);
            }
        }

        private final VirtualFile findDeclarationsFile(String path2, VirtualFile base) {
            String string;
            String filePath;
            VirtualFile virtualFile;
            String string2;
            String it = string2 = path2;
            boolean bl = false;
            Object object = StringsKt.endsWith$default((String)it, (String)".d.ts", (boolean)false, (int)2, null) ? string2 : null;
            if (object == null) {
                object = path2 + ".d.ts";
            }
            if ((virtualFile = VfsUtilCore.findRelativeFile((String)(filePath = object), (VirtualFile)base)) != null) {
                it = string2 = virtualFile;
                boolean bl2 = false;
                string = VirtualFileUtil.isFile((VirtualFile)it) ? string2 : null;
            } else {
                string = null;
            }
            return string;
        }

        private final Collection<VirtualFile> calcTypeFiles(Collection<? extends VirtualFile> typeRoots, Collection<String> typeNames, VirtualFile configDirectory) {
            boolean bl;
            String it;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            Companion companion;
            if (typeNames.isEmpty()) {
                return this.calcAllTypeFiles(typeRoots);
            }
            SmartList result2 = new SmartList();
            HashSet visited = new HashSet();
            for (VirtualFile virtualFile : typeRoots) {
                this.resolveTypesForRoot(typeNames, virtualFile, visited, (List)result2);
            }
            if (visited.size() == typeNames.size()) {
                return (Collection)result2;
            }
            VirtualFile nodeModules = JSLibraryUtil.findUpClosestNodeModulesResolveRoot((VirtualFile)configDirectory, (boolean)false);
            if (nodeModules != null) {
                Iterable iterable = typeNames;
                companion = this;
                $i$f$filter = false;
                Iterable iterable2 = iterable;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    bl = false;
                    if (!(!StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                companion.resolveTypesForRoot((List)destination$iv$iv, nodeModules, visited, (List)result2);
            }
            Iterable iterable = typeNames;
            companion = this;
            $i$f$filter = false;
            $this$filterTo$iv$iv = iterable;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            companion.resolveTypesForRoot((List)destination$iv$iv, configDirectory, visited, (List)result2);
            return (Collection)result2;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<VirtualFile> calcAllTypeFiles(Collection<? extends VirtualFile> typeRoots) {
            void var3_3;
            void $this$mapNotNullTo$iv;
            Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)typeRoots), Companion::calcAllTypeFiles$lambda$0), Companion::calcAllTypeFiles$lambda$1), Companion::calcAllTypeFiles$lambda$2), Companion::calcAllTypeFiles$lambda$3);
            Collection destination$iv = (Collection)new SmartList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (JSExactFileReference.resolveForNpmPackages(it, (JSDirectorySearchProcessor)TypeScriptNodeSearchProcessor.TS_PROCESSOR) == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            return var3_3;
        }

        private static final boolean calcAllTypeFiles$lambda$0(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isValid();
        }

        private static final Sequence calcAllTypeFiles$lambda$1(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            VirtualFile[] virtualFileArray = it.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            return ArraysKt.asSequence((Object[])virtualFileArray);
        }

        private static final Unit calcAllTypeFiles$lambda$2(VirtualFile it) {
            ProgressManager.checkCanceled();
            return Unit.INSTANCE;
        }

        private static final boolean calcAllTypeFiles$lambda$3(VirtualFile it) {
            return it.isDirectory();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

