/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesConfigurationUtilKt;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.FindAndApplyMatchingCrdQuickFix;
import com.intellij.kubernetes.model.KubernetesEditabilityValidator;
import com.intellij.kubernetes.model.KubernetesModel;
import com.intellij.kubernetes.model.KubernetesResourceDefinitionsKt;
import com.intellij.kubernetes.model.KubernetesUnknownResourceValidator;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.kubernetes.model.SetKubeConfigFile;
import com.intellij.kubernetes.ui.intentions.MarkAsNonK8sFileModCommandAction;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/model/KubernetesResourceKindType;", "Lorg/jetbrains/yaml/meta/model/YamlScalarType;", "Lcom/intellij/kubernetes/model/KubernetesEditabilityValidator;", "Lcom/intellij/kubernetes/model/KubernetesUnknownResourceValidator;", "<init>", "()V", "getApiVersionByKind", "", "scalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "getResourceIdentity", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "scalarValue", "getValueLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "insertedScalar", "completionContext", "Lorg/jetbrains/yaml/meta/model/CompletionContext;", "setApiVersion", "", "resourceMapping", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "apiVersion", "checkKnown", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "checkDeprecated", "checkReadOnly", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceDefinitions.kt\ncom/intellij/kubernetes/model/KubernetesResourceKindType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,446:1\n1#2:447\n777#3:448\n873#3,2:449\n1586#3:451\n1661#3,3:452\n1586#3:455\n1661#3,3:456\n1661#3,3:459\n1661#3,3:462\n777#3:465\n873#3,2:466\n1915#3,2:468\n37#4,2:470\n19#5:472\n19#5:475\n19#5:478\n73#6,2:473\n73#6,2:476\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceDefinitions.kt\ncom/intellij/kubernetes/model/KubernetesResourceKindType\n*L\n201#1:448\n201#1:449,2\n209#1:451\n209#1:452,3\n211#1:455\n211#1:456,3\n239#1:459,3\n240#1:462,3\n247#1:465\n247#1:466,2\n248#1:468,2\n303#1:470,2\n217#1:472\n219#1:475\n255#1:478\n219#1:473,2\n255#1:476,2\n*E\n"})
public final class KubernetesResourceKindType
extends YamlScalarType
implements KubernetesEditabilityValidator,
KubernetesUnknownResourceValidator {
    @NotNull
    public static final KubernetesResourceKindType INSTANCE = new KubernetesResourceKindType();

    private KubernetesResourceKindType() {
        super("string");
    }

    private final String getApiVersionByKind(YAMLScalar scalar) {
        YAMLKeyValue yAMLKeyValue;
        PsiElement psiElement = scalar.getParent();
        YAMLKeyValue yAMLKeyValue2 = psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null;
        if (yAMLKeyValue2 == null) {
            return null;
        }
        YAMLKeyValue parentKeyValue = yAMLKeyValue2;
        YAMLMapping yAMLMapping = parentKeyValue.getParentMapping();
        YAMLValue yAMLValue = yAMLMapping != null && (yAMLKeyValue = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping, (String)"apiVersion")) != null ? yAMLKeyValue.getValue() : null;
        YAMLScalar yAMLScalar = yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null;
        if (yAMLScalar == null) {
            return null;
        }
        YAMLScalar yamlValue = yAMLScalar;
        return yamlValue.getTextValue();
    }

    @Override
    @Nullable
    public ResourceIdentity getResourceIdentity(@NotNull YAMLScalar scalarValue) {
        ResourceIdentity resourceIdentity;
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        String string = this.getApiVersionByKind(scalarValue);
        if (string == null) {
            return null;
        }
        String apiVersion = string;
        String string2 = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextValue(...)");
        String kind = string2;
        ResourceIdentity it = resourceIdentity = ResourceIdentity.Companion.create(apiVersion, kind);
        boolean bl = false;
        return !Intrinsics.areEqual((Object)it, (Object)ResourceIdentity.Companion.getUNDEFINED()) ? resourceIdentity : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        Object kinds;
        Iterable searchScope;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)insertedScalar, (String)"insertedScalar");
        Project project = insertedScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string2 = this.getApiVersionByKind(insertedScalar);
        if (string2 != null) {
            String string3;
            String p0 = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)p0) ? string3 : null;
        } else {
            string = null;
        }
        String apiVersion = string;
        CompletionContext completionContext2 = completionContext;
        if ((completionContext2 != null ? completionContext2.getCompletionType() : null) == CompletionType.SMART) {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Iterable $this$filterTo$iv$iv;
            List resourceIdVsFile = KubernetesResourceDefinitionsKt.access$getNotConfiguredCustomResourceDefinitions(project2);
            if (apiVersion != null) {
                $this$filter$iv = resourceIdVsFile;
                $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Pair it = (Pair)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.contains((CharSequence)((ResourceIdentity)it.getFirst()).getApiVersion(), (CharSequence)apiVersion, (boolean)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredByApiVersion = (List)destination$iv$iv;
                if (!((Collection)filteredByApiVersion).isEmpty()) {
                    resourceIdVsFile = filteredByApiVersion;
                }
            }
            UniqueVFilePathBuilder uniqueVFilePathBuilder = UniqueVFilePathBuilder.getInstance();
            $this$filterTo$iv$iv = resourceIdVsFile;
            Object object = project2;
            boolean $i$f$map22 = false;
            void $i$f$filterTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Pair pair = (Pair)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((VirtualFile)it.getSecond());
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)object, (Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
            searchScope = globalSearchScope;
            Iterable $this$map$iv2 = resourceIdVsFile;
            boolean $i$f$map = false;
            Iterable $i$f$map22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair item$iv$iv2 = (Pair)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(LookupElementBuilder.create((Object)it, (String)((ResourceIdentity)it.getFirst()).getKind()).withPresentableText(((ResourceIdentity)it.getFirst()).getKind()).withTailText(" " + ((ResourceIdentity)it.getFirst()).getApiVersion()).withTypeText(uniqueVFilePathBuilder.getUniqueVirtualFilePath(project2, (VirtualFile)it.getSecond(), (GlobalSearchScope)searchScope), false).withInsertHandler((arg_0, arg_1) -> KubernetesResourceKindType.getValueLookups$lambda$2$0(insertedScalar, arg_0, arg_1)).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        }
        ArrayList<LookupElementBuilder> result2 = new ArrayList<LookupElementBuilder>();
        Project project3 = insertedScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        KubernetesModel model2 = KubernetesUtilKt.getK8sModel(project3);
        if (apiVersion != null) {
            KubernetesModel.Kinds kinds2 = model2.getKinds(apiVersion);
            if (kinds2 != null) {
                kinds = kinds2;
                boolean bl = false;
                if (completionContext == null || completionContext.getCompletionType() == CompletionType.BASIC && completionContext.getInvocationCount() == 1) {
                    String p0;
                    Object object;
                    Iterable $this$mapTo$iv;
                    Iterable destination$iv$iv2 = kinds.getValidKinds();
                    Object destination$iv = result2;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        String bl2 = (String)item$iv;
                        object = destination$iv;
                        boolean bl3 = false;
                        object.add(LookupElementBuilder.create((String)p0));
                    }
                    $this$mapTo$iv = kinds.getDeprecatedKinds();
                    destination$iv = result2;
                    $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        p0 = (String)item$iv;
                        object = destination$iv;
                        boolean bl4 = false;
                        object.add(LookupElementBuilder.create((String)it).withStrikeoutness(true));
                    }
                }
            }
        }
        if (result2.isEmpty()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            searchScope = model2.getEditableResources();
            $i$f$filter = false;
            kinds = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ResourceIdentity it = (ResourceIdentity)element$iv$iv;
                boolean bl = false;
                Field field2 = model2.getResourceModel(it);
                boolean bl5 = field2 != null ? !field2.isDeprecated() : false;
                if (!bl5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LookupElementBuilder builder;
                ResourceIdentity it = (ResourceIdentity)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((Object)it, (String)it.getKind()).withTypeText(it.getApiVersion(), true).withInsertHandler((arg_0, arg_1) -> KubernetesResourceKindType.getValueLookups$lambda$5$0(insertedScalar, arg_0, arg_1)), (String)"withInsertHandler(...)");
                result2.add(builder);
            }
        }
        return result2;
    }

    private final void setApiVersion(YAMLMapping resourceMapping, String apiVersion) {
        YAMLKeyValue currentApiVersionKeyVal = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)resourceMapping, (String)"apiVersion");
        if (currentApiVersionKeyVal == null) {
            resourceMapping.putKeyValue(YAMLElementGenerator.getInstance((Project)resourceMapping.getProject()).createYamlKeyValue("apiVersion", "bar"));
            YAMLKeyValue yAMLKeyValue = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)resourceMapping, (String)"apiVersion");
            if (yAMLKeyValue == null) {
                return;
            }
            currentApiVersionKeyVal = yAMLKeyValue;
        }
        YAMLKeyValue yAMLKeyValue = YAMLElementGenerator.getInstance((Project)resourceMapping.getProject()).createYamlKeyValue("foo", apiVersion);
        Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"createYamlKeyValue(...)");
        YAMLKeyValue dummyKeyVal = yAMLKeyValue;
        YAMLValue yAMLValue = dummyKeyVal.getValue();
        Intrinsics.checkNotNull((Object)yAMLValue);
        currentApiVersionKeyVal.setValue(yAMLValue);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void checkKnown(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            v0 = this.getApiVersionByKind(scalarValue);
            if (v0 != null) {
                it = v0;
                $i$a$-let-KubernetesResourceKindType$checkKnown$kinds$1 = false;
                v1 = scalarValue.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                v2 = KubernetesUtilKt.getK8sModel(v1).getKinds(it);
            } else {
                v2 = null;
            }
            kinds = v2;
            v3 = scalarValue.getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getTextValue(...)");
            kind = v3;
            it = holder.getFile();
            v4 = yamlFile = it instanceof YAMLFile != false ? (YAMLFile)it : null;
            if (kinds != null && kinds.getAllKinds().contains(kind)) break block6;
            v5 = var7_5 = new LocalQuickFix[3];
            v6 = 0;
            if (yamlFile == null) ** GOTO lbl-1000
            var10_11 = var9_9 = yamlFile;
            var14_14 = v6;
            var13_15 = v5;
            $i$a$-takeIf-KubernetesResourceKindType$checkKnown$quickFixes$1 = false;
            var15_18 = Intrinsics.areEqual((Object)scalarValue.getTextValue(), (Object)"Config");
            v5 = var13_15;
            v6 = var14_14;
            v7 /* !! */  = var8_21 = var15_18 != false ? var9_9 : null;
            if (var8_21 == null) ** GOTO lbl-1000
            $i$a$-takeIf-KubernetesResourceKindType$checkKnown$quickFixes$1 = it = var8_21;
            var14_14 = v6;
            var13_15 = v5;
            $i$a$-takeIf-KubernetesResourceKindType$checkKnown$quickFixes$2 = false;
            var15_18 = KubeConfig.isKubeConfig((PsiFile)((PsiFile)it)) == false;
            v5 = var13_15;
            v6 = var14_14;
            v8 /* !! */  = var9_9 = var15_18 != false ? it : null;
            if (var9_9 != null) {
                it = var9_9;
                var14_14 = v6;
                var13_15 = v5;
                $i$a$-let-KubernetesResourceKindType$checkKnown$quickFixes$3 = false;
                var15_19 = new SetKubeConfigFile(it);
                v5 = var13_15;
                v6 = var14_14;
                v9 = var15_19;
            } else lbl-1000:
            // 3 sources

            {
                v9 = null;
            }
            v5[v6] = v9;
            var7_5[1] = new FindAndApplyMatchingCrdQuickFix(scalarValue);
            v10 = var7_5;
            v11 = 2;
            v12 = yamlFile;
            if (v12 != null) {
                var9_9 = v12;
                var14_14 = v11;
                var13_15 = v10;
                $i$a$-let-KubernetesResourceKindType$checkKnown$quickFixes$4 = false;
                var15_20 = LocalQuickFix.from((ModCommandAction)((ModCommandAction)new MarkAsNonK8sFileModCommandAction()));
                v10 = var13_15;
                v11 = var14_14;
                v13 = var15_20;
            } else {
                v13 = null;
            }
            v10[v11] = v13;
            quickFixes = CollectionsKt.listOfNotNull((Object[])var7_5);
            $this$toTypedArray$iv = quickFixes;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            var7_5 = thisCollection$iv.toArray(new LocalQuickFix[0]);
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message((String)"KubernetesResourceKindType.validation.unknown.resource.kind", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(var7_5, var7_5.length));
        }
    }

    public final void checkDeprecated(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = this.getApiVersionByKind(scalarValue);
        if (string == null) {
            return;
        }
        String apiVersion = string;
        String string2 = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextValue(...)");
        String kind = string2;
        Project project = scalarValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubernetesModel.Kinds kinds = KubernetesUtilKt.getK8sModel(project).getKinds(apiVersion);
        if (kinds == null) {
            return;
        }
        KubernetesModel.Kinds kinds2 = kinds;
        if (kinds2.getDeprecatedKinds().contains(kind)) {
            Object[] objectArray = new Object[]{kind, apiVersion};
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message((String)"DeprecatedResourcesInspection.deprecated.kind", (Object[])objectArray), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
        }
    }

    @Override
    public void checkReadOnly(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = this.getApiVersionByKind(scalarValue);
        if (string == null) {
            return;
        }
        String apiVersion = string;
        String string2 = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextValue(...)");
        String kind = string2;
        Project project = scalarValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubernetesModel.Kinds kinds = KubernetesUtilKt.getK8sModel(project).getKinds(apiVersion);
        if (kinds == null) {
            return;
        }
        KubernetesModel.Kinds kinds2 = kinds;
        if (kinds2.getNonEditableKinds().contains(kind)) {
            Object[] objectArray = new Object[]{kind, apiVersion};
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message((String)"NonEditableResourcesInspection.noneditable.kind", (Object[])objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static final Unit getValueLookups$lambda$2$0$0$0(InsertionContext $context, Pair $resourceIdVsFile) {
        Project project = $context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubernetesConfigurationUtilKt.addCrdSpecToProjectConfiguration(project, (VirtualFile)$resourceIdVsFile.getSecond());
        return Unit.INSTANCE;
    }

    private static final void getValueLookups$lambda$2$0(YAMLScalar $insertedScalar, InsertionContext context2, LookupElement item) {
        block5: {
            YAMLKeyValue yAMLKeyValue;
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Object $this$asSafely$iv = item.getObject();
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof Pair)) {
                object = null;
            }
            Pair pair = (Pair)object;
            if (pair == null) break block5;
            Pair resourceIdVsFile = pair;
            boolean bl = false;
            PsiElement element$iv = (PsiElement)$insertedScalar;
            boolean $i$f$getOriginalElement = false;
            PsiElement psiElement2 = element$iv.getContainingFile().getOriginalFile().findElementAt(PsiTreeUtilKt.getStartOffset((PsiElement)element$iv));
            if (psiElement2 == null) {
                psiElement = null;
            } else {
                PsiElement originalElementAt$iv = psiElement2;
                psiElement = YamlUtilKt.getTypedAncestorOrSelf((PsiElement)originalElementAt$iv, YAMLScalar.class);
            }
            YAMLScalar yAMLScalar = (YAMLScalar)psiElement;
            PsiElement $this$asSafely$iv2 = yAMLScalar != null ? yAMLScalar.getParent() : null;
            boolean $i$f$asSafely2 = false;
            PsiElement psiElement3 = $this$asSafely$iv2;
            if (!(psiElement3 instanceof YAMLKeyValue)) {
                psiElement3 = null;
            }
            if ((yAMLKeyValue = (YAMLKeyValue)psiElement3) != null && (yAMLKeyValue = yAMLKeyValue.getParentMapping()) != null) {
                YAMLKeyValue parentMapping = yAMLKeyValue;
                INSTANCE.setApiVersion((YAMLMapping)parentMapping, ((ResourceIdentity)resourceIdVsFile.getFirst()).getApiVersion());
                ActionsKt.invokeLater$default(null, () -> KubernetesResourceKindType.getValueLookups$lambda$2$0$0$0(context2, resourceIdVsFile), (int)1, null);
            }
        }
    }

    private static final void getValueLookups$lambda$5$0(YAMLScalar $insertedScalar, InsertionContext context2, LookupElement item) {
        YAMLKeyValue yAMLKeyValue;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = item.getObject();
        ResourceIdentity resourceIdentity = object instanceof ResourceIdentity ? (ResourceIdentity)object : null;
        if (resourceIdentity == null) {
            return;
        }
        ResourceIdentity resourceId = resourceIdentity;
        PsiElement element$iv = (PsiElement)$insertedScalar;
        boolean $i$f$getOriginalElement = false;
        PsiElement psiElement2 = element$iv.getContainingFile().getOriginalFile().findElementAt(PsiTreeUtilKt.getStartOffset((PsiElement)element$iv));
        if (psiElement2 == null) {
            psiElement = null;
        } else {
            PsiElement originalElementAt$iv = psiElement2;
            psiElement = YamlUtilKt.getTypedAncestorOrSelf((PsiElement)originalElementAt$iv, YAMLScalar.class);
        }
        YAMLScalar yAMLScalar = (YAMLScalar)psiElement;
        PsiElement $this$asSafely$iv = yAMLScalar != null ? yAMLScalar.getParent() : null;
        boolean $i$f$asSafely = false;
        PsiElement psiElement3 = $this$asSafely$iv;
        if (!(psiElement3 instanceof YAMLKeyValue)) {
            psiElement3 = null;
        }
        if ((yAMLKeyValue = (YAMLKeyValue)psiElement3) == null || (yAMLKeyValue = yAMLKeyValue.getParentMapping()) == null) {
            return;
        }
        YAMLKeyValue resourceMapping = yAMLKeyValue;
        INSTANCE.setApiVersion((YAMLMapping)resourceMapping, resourceId.getApiVersion());
        KubernetesUsageTriggerCollector.INSTANCE.getKIND_COMPLETION_FEATURE_ID().log(context2.getProject());
    }
}

