/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.GenericFileReferenceType;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/model/KustomizeK8sResourceReferenceType;", "Lcom/intellij/kubernetes/model/GenericFileReferenceType;", "typeName", "", "specInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "acceptDirectories", "", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;Z)V", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;)V", "getFileFilter", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/psi/PsiFileSystemItem;", "element", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "validateScalarValue", "", "scalarValue", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes.backend"})
public class KustomizeK8sResourceReferenceType
extends GenericFileReferenceType {
    private final boolean acceptDirectories;

    public KustomizeK8sResourceReferenceType(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo, boolean acceptDirectories) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        super(typeName, specInfo);
        this.acceptDirectories = acceptDirectories;
    }

    public KustomizeK8sResourceReferenceType(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        this(typeName, specInfo, false);
    }

    @Override
    @NotNull
    protected Condition<PsiFileSystemItem> getFileFilter(@NotNull YAMLScalar element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KustomizeK8sResourceReferenceType::getFileFilter$lambda$0;
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        PsiFileSystemItem targetFile;
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiManager psiManager = PsiManager.getInstance((Project)scalarValue.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        VirtualFile virtualFile3 = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)scalarValue));
        if (virtualFile3 != null && (virtualFile2 = virtualFile3.getParent()) != null && (virtualFile = virtualFile2.findFileByRelativePath(YamlUtilKt.getEffectiveText((YAMLValue)((YAMLValue)scalarValue)))) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            PsiDirectory psiDirectory = this.acceptDirectories ? psiManager2.findDirectory(it) : null;
            v2 = psiDirectory != null ? (PsiFileSystemItem)psiDirectory : (PsiFileSystemItem)psiManager2.findFile(it);
        } else {
            v2 = targetFile = null;
        }
        if (targetFile == null) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message((String)"KubernetesModelDefinition.file.not.exist.error", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (!(this.acceptDirectories && targetFile instanceof PsiDirectory || KubernetesUtilKt.isKubernetesYaml((virtualFile3 = targetFile) instanceof PsiFile ? (PsiFile)virtualFile3 : null))) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message((String)"KubernetesModelDefinition.yaml.file.expected.error", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static final boolean getFileFilter$lambda$0(PsiFileSystemItem it) {
        return it instanceof PsiDirectory || KubernetesUtilKt.isNonKustomizationK8sFile(it);
    }
}

