/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.kubernetes.config.HelmParameters;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.HelmCommandParametersDialog;
import com.intellij.kubernetes.ui.actions.HelmChartActionBase;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmCliActionBase;", "Lcom/intellij/kubernetes/ui/actions/HelmChartActionBase;", "taskTitle", "", "dependsOnManualConfiguration", "", "<init>", "(Ljava/lang/String;Z)V", "getTaskTitle", "()Ljava/lang/String;", "helmCommand", "", "getHelmCommand", "()Ljava/util/List;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "createExecutionRequest", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "performInBackground", "executionManager", "Lcom/intellij/kubernetes/helm/HelmExecutionManager;", "request", "intellij.clouds.kubernetes.backend"})
public abstract class HelmCliActionBase
extends HelmChartActionBase {
    @NotNull
    private final String taskTitle;
    private final boolean dependsOnManualConfiguration;

    public HelmCliActionBase(@Nls @NotNull String taskTitle, boolean dependsOnManualConfiguration) {
        Intrinsics.checkNotNullParameter((Object)taskTitle, (String)"taskTitle");
        this.taskTitle = taskTitle;
        this.dependsOnManualConfiguration = dependsOnManualConfiguration;
    }

    @NotNull
    public final String getTaskTitle() {
        return this.taskTitle;
    }

    @NotNull
    public abstract List<String> getHelmCommand();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesActionBase.ActionContext actionContext = this.getContext(e);
        if (actionContext == null) {
            return;
        }
        KubernetesActionBase.ActionContext context2 = actionContext;
        HelmExecutionManager.ExecutionRequest executionRequest = this.createExecutionRequest(context2);
        if (executionRequest == null) {
            return;
        }
        HelmExecutionManager.ExecutionRequest request = executionRequest;
        FileDocumentManager.getInstance().saveAllDocuments();
        Object object = context2.getProject().getService(HelmExecutionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.performInBackground(context2, (HelmExecutionManager)object, request);
    }

    @Override
    protected boolean isEnabled(@NotNull KubernetesActionBase.ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !((HelmExecutionManager)context2.getProject().getService(HelmExecutionManager.class)).isBusy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final HelmExecutionManager.ExecutionRequest createExecutionRequest(KubernetesActionBase.ActionContext context2) {
        EffectiveHelmParameters effectiveHelmParameters;
        Chart chart = this.getChart(context2);
        if (chart == null) {
            return null;
        }
        Chart chart2 = chart;
        if (this.dependsOnManualConfiguration) {
            EffectiveHelmParameters dialogParams;
            EffectiveHelmParameters effectiveHelmParameters2;
            Project project = context2.getProject();
            String string = KubernetesBundle.message((String)"Helm.collect.chart.effective.params.before.action.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            EffectiveHelmParameters effectiveHelmParams2 = (EffectiveHelmParameters)TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EffectiveHelmParameters>, Object>(chart2, null){
                int label;
                final /* synthetic */ Chart $chart;
                {
                    this.$chart = $chart;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return this.$chart.getEffectiveHelmParameters();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super EffectiveHelmParameters> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            HelmParameters helmParameters2 = KubernetesProjectSettings.Companion.getInstance(context2.getProject()).getHelmParameters(chart2.getBaseDir());
            if (!(helmParameters2 != null ? !helmParameters2.getShowConfigDialog() : false)) {
                HelmCommandParametersDialog cfgDialog = new HelmCommandParametersDialog(context2.getProject(), chart2, this.taskTitle, effectiveHelmParams2);
                if (!cfgDialog.showAndGet()) return null;
                effectiveHelmParameters2 = cfgDialog.getHelmParameters();
            } else {
                effectiveHelmParameters2 = null;
            }
            if ((effectiveHelmParameters = (dialogParams = effectiveHelmParameters2)) == null) {
                effectiveHelmParameters = effectiveHelmParams2;
            }
        } else {
            effectiveHelmParameters = EffectiveHelmParameters.Companion.getEMPTY_PARAMETERS$intellij_clouds_kubernetes_backend();
        }
        EffectiveHelmParameters helmParameters3 = effectiveHelmParameters;
        VirtualFile virtualFile = chart2.getBaseDir().getParent();
        if (virtualFile == null) return null;
        VirtualFile it = virtualFile;
        boolean bl = false;
        HelmExecutionManager.ExecutionRequest executionRequest = new HelmExecutionManager.ExecutionRequest(this.taskTitle, this.getHelmCommand(), helmParameters3, it, chart2.getBaseDir().getName(), null, null, 96, null);
        return executionRequest;
    }

    protected abstract void performInBackground(@NotNull KubernetesActionBase.ActionContext var1, @NotNull HelmExecutionManager var2, @NotNull HelmExecutionManager.ExecutionRequest var3);
}

