/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.HelmModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.kubernetes.ui.actions.SlowHelmActionBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmUpdateDependenciesAction;", "Lcom/intellij/kubernetes/ui/actions/SlowHelmActionBase;", "<init>", "()V", "helmCommand", "", "", "getHelmCommand", "()Ljava/util/List;", "isApplicable", "", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "getChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "onProcessFinished", "", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmUpdateDependenciesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmUpdateDependenciesAction.kt\ncom/intellij/kubernetes/ui/actions/HelmUpdateDependenciesAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,35:1\n1#2:36\n30#3,2:37\n*S KotlinDebug\n*F\n+ 1 HelmUpdateDependenciesAction.kt\ncom/intellij/kubernetes/ui/actions/HelmUpdateDependenciesAction\n*L\n29#1:37,2\n*E\n"})
public final class HelmUpdateDependenciesAction
extends SlowHelmActionBase {
    @NotNull
    private final List<String> helmCommand;

    public HelmUpdateDependenciesAction() {
        String string = KubernetesBundle.message((String)"HelmUpdateDependenciesAction.task.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, false);
        Object[] objectArray = new String[]{"dep", "update"};
        this.helmCommand = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getHelmCommand() {
        return this.helmCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApplicable(@NotNull KubernetesActionBase.ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Chart chart = this.getChart(context2);
        if (chart == null) {
            return false;
        }
        Chart chart2 = chart;
        HelmModel model2 = chart2.getModel();
        if (Intrinsics.areEqual((Object)model2.getApiVersion(), (Object)"v1")) {
            if (chart2.getRequirementsFile() == null) return false;
            return true;
        }
        VirtualFile virtualFile = chart2.getChartFile();
        if (virtualFile == null) return false;
        VirtualFile it = virtualFile;
        boolean bl = false;
        PsiFile psiFile = PsiManager.getInstance((Project)context2.getProject()).findFile(chart2.getChartFile());
        if (!(psiFile instanceof YAMLFile)) return false;
        YAMLFile yAMLFile = (YAMLFile)psiFile;
        YAMLFile yAMLFile2 = yAMLFile;
        if (yAMLFile2 == null) return false;
        YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((YAMLFile)yAMLFile2);
        if (yAMLMapping == null) return false;
        YAMLKeyValue yAMLKeyValue = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping, (String)"dependencies");
        if (yAMLKeyValue == null) return false;
        return true;
    }

    @Override
    @Nullable
    protected Chart getChart(@NotNull KubernetesActionBase.ActionContext context2) {
        Chart chart;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)context2.getProject();
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart2 = ((ChartManager)object).findChartByRelatedFile(context2.getCurrentFile());
        if (chart2 != null) {
            Chart chart3;
            Chart it = chart3 = chart2;
            boolean bl = false;
            chart = !it.isDownloaded() && it.getChartFile() != null ? chart3 : null;
        } else {
            chart = null;
        }
        return chart;
    }

    @Override
    protected void onProcessFinished(@NotNull KubernetesActionBase.ActionContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Chart chart = this.getChart(context2);
            if (chart == null || (chart = chart.getBaseDir()) == null) break block0;
            chart.refresh(false, true);
        }
    }
}

