/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.components.document;

import com.intellij.kotlin.jupyter.core.editor.highlighting.components.HighlightingComponent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.transformers.CaretMovementEventTransformer;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.transformers.DocumentChangeEventsTransformer;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEvent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEventsQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/DocumentInputEventsTransformerAdapter;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/HighlightingComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightingEventsQueue", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueue;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Document;Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueue;)V", "caretMovementEventTransformer", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/CaretMovementEventTransformer;", "documentChangeEventTransformer", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/DocumentChangeEventsTransformer;", "initializeSelf", "", "addListeners", "NotebookDocumentListener", "NotebookCaretListener", "intellij.kotlin.jupyter.core"})
public final class DocumentInputEventsTransformerAdapter
extends HighlightingComponent {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Document document;
    @NotNull
    private final HighlightingEventsQueue highlightingEventsQueue;
    @NotNull
    private final CaretMovementEventTransformer caretMovementEventTransformer;
    @NotNull
    private final DocumentChangeEventsTransformer documentChangeEventTransformer;

    public DocumentInputEventsTransformerAdapter(@NotNull Editor editor, @NotNull Document document, @NotNull HighlightingEventsQueue highlightingEventsQueue) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)highlightingEventsQueue, (String)"highlightingEventsQueue");
        this.editor = editor;
        this.document = document;
        this.highlightingEventsQueue = highlightingEventsQueue;
        this.caretMovementEventTransformer = (CaretMovementEventTransformer)this.child(() -> DocumentInputEventsTransformerAdapter.caretMovementEventTransformer$lambda$0(this));
        this.documentChangeEventTransformer = (DocumentChangeEventsTransformer)this.child(() -> DocumentInputEventsTransformerAdapter.documentChangeEventTransformer$lambda$0(this));
        this.initialize();
    }

    @Override
    protected void initializeSelf() {
        this.addListeners();
    }

    private final void addListeners() {
        this.document.addDocumentListener((DocumentListener)new NotebookDocumentListener(), (Disposable)this);
        this.editor.getCaretModel().addCaretListener((CaretListener)new NotebookCaretListener(), (Disposable)this);
    }

    private static final CaretMovementEventTransformer caretMovementEventTransformer$lambda$0(DocumentInputEventsTransformerAdapter this$0) {
        return new CaretMovementEventTransformer(this$0.editor);
    }

    private static final DocumentChangeEventsTransformer documentChangeEventTransformer$lambda$0(DocumentInputEventsTransformerAdapter this$0) {
        return new DocumentChangeEventsTransformer(this$0.editor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/DocumentInputEventsTransformerAdapter$NotebookCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "(Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/DocumentInputEventsTransformerAdapter;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "intellij.kotlin.jupyter.core"})
    public final class NotebookCaretListener
    implements CaretListener {
        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            HighlightingEvent highlightingEvent = DocumentInputEventsTransformerAdapter.this.caretMovementEventTransformer.transformRawInput(event);
            if (highlightingEvent == null) {
                return;
            }
            HighlightingEvent caretEvent = highlightingEvent;
            DocumentInputEventsTransformerAdapter.this.highlightingEventsQueue.pushEvent(caretEvent);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/DocumentInputEventsTransformerAdapter$NotebookDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "(Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/DocumentInputEventsTransformerAdapter;)V", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.kotlin.jupyter.core"})
    public final class NotebookDocumentListener
    implements DocumentListener {
        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Intrinsics.areEqual((Object)event.getDocument(), (Object)DocumentInputEventsTransformerAdapter.this.document)) {
                return;
            }
            HighlightingEvent highlightingEvent = DocumentInputEventsTransformerAdapter.this.documentChangeEventTransformer.transformRawInput(event);
            if (highlightingEvent == null) {
                return;
            }
            HighlightingEvent transformedEvent = highlightingEvent;
            DocumentInputEventsTransformerAdapter.this.highlightingEventsQueue.pushEvent(transformedEvent);
        }
    }
}

