/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependencies;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependenciesPropertyKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookPerFileSettingsCache;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSettings;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006\u001a\n\u0010\u0015\u001a\u00020\u0002*\u00020\u000f\u001a\u001c\u0010\u0016\u001a\u00020\u0014*\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\b*\u0004\u0018\u00010\u000f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u001a\u001a\u00020\u00148F\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e*\u0016\u0010\u0012\"\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a8\u0006\u001f"}, d2={"isNotEmptyDirectory", "", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "sourceRootsForDependencies", "", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "sourceRootsForProjectModuleDependencies", "getSourceRoots", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;", "project", "parentsWithSelf", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getParentsWithSelf", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lkotlin/sequences/Sequence;", "ProjectArtifacts", "", "", "toAbsolutePath", "toPresentablePathAsTabTitle", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "toKotlinNotebookBackedFile", "pathSeparator", "getPathSeparator$annotations", "()V", "getPathSeparator", "()Ljava/lang/String;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nfiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 files.kt\ncom/intellij/kotlin/jupyter/core/util/FilesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,93:1\n1#2:94\n1391#3:95\n1480#3,2:96\n1482#3,3:102\n11705#4:98\n12052#4,3:99\n11705#4:105\n12052#4,3:106\n*S KotlinDebug\n*F\n+ 1 files.kt\ncom/intellij/kotlin/jupyter/core/util/FilesKt\n*L\n47#1:95\n47#1:96,2\n47#1:102,3\n48#1:98\n48#1:99,3\n54#1:105\n54#1:106,3\n*E\n"})
public final class FilesKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotEmptyDirectory(@NotNull Path $this$isNotEmptyDirectory) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmptyDirectory, (String)"<this>");
        if (!Files.isDirectory($this$isNotEmptyDirectory, new LinkOption[0])) return false;
        if (!Files.exists($this$isNotEmptyDirectory, new LinkOption[0])) return false;
        Closeable closeable = Files.newDirectoryStream($this$isNotEmptyDirectory);
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            boolean bl2 = false;
            bl = it.iterator().hasNext();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    public static final Collection<Path> sourceRootsForDependencies(@NotNull Project $this$sourceRootsForDependencies, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceRootsForDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        KotlinNotebookSettings optionsProvider = KotlinNotebookPerFileSettingsCache.Companion.getInstance($this$sourceRootsForDependencies).getSettings(notebookFile);
        KotlinNotebookDependencies dependencies = optionsProvider.getNotebookDependencies();
        return FilesKt.getSourceRoots(dependencies, $this$sourceRootsForDependencies);
    }

    @NotNull
    public static final Collection<Path> sourceRootsForProjectModuleDependencies(@NotNull Project $this$sourceRootsForProjectModuleDependencies, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceRootsForProjectModuleDependencies, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        KotlinNotebookSettings optionsProvider = KotlinNotebookPerFileSettingsCache.Companion.getInstance($this$sourceRootsForProjectModuleDependencies).getSettings(notebookFile);
        KotlinNotebookDependencies dependencies = optionsProvider.getNotebookDependencies();
        if (!(dependencies instanceof KotlinNotebookDependencies.SingleModule)) {
            return CollectionsKt.emptyList();
        }
        return FilesKt.getSourceRoots(dependencies, $this$sourceRootsForProjectModuleDependencies);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Path> getSourceRoots(@NotNull KotlinNotebookDependencies $this$getSourceRoots, @NotNull Project project) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinNotebookDependencies kotlinNotebookDependencies = $this$getSourceRoots;
        if (kotlinNotebookDependencies instanceof KotlinNotebookDependencies.None) {
            collection = CollectionsKt.emptyList();
        } else if (kotlinNotebookDependencies instanceof KotlinNotebookDependencies.AllLibraries) {
            void $this$flatMapTo$iv$iv;
            List<Library> libraries = KotlinNotebookDependenciesPropertyKt.getSuitableLibraries(project);
            Iterable $this$flatMap$iv = libraries;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Library library = (Library)element$iv$iv;
                boolean bl = false;
                VirtualFile[] virtualFileArray = library.getRootProvider().getFiles(OrderRootType.SOURCES);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                Object[] $this$map$iv = virtualFileArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(Path.of(it.getPath(), new String[0]));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else if (kotlinNotebookDependencies instanceof KotlinNotebookDependencies.SingleModule) {
            void $this$mapTo$iv$iv;
            Module tagetModule = KotlinNotebookDependenciesPropertyKt.findModule($this$getSourceRoots, project);
            if (tagetModule == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile[] $this$map$iv = ProjectRootsUtilKt.getSourceRoots((Module)tagetModule);
            boolean $i$f$map = false;
            VirtualFile[] $this$flatMapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection3 = destination$iv$iv;
                boolean bl3 = false;
                collection3.add(Path.of(it.getPath(), new String[0]));
            }
            collection = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return collection;
    }

    @NotNull
    public static final Sequence<VirtualFile> getParentsWithSelf(@NotNull VirtualFile $this$parentsWithSelf) {
        Intrinsics.checkNotNullParameter((Object)$this$parentsWithSelf, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentsWithSelf, FilesKt::_get_parentsWithSelf_$lambda$0);
    }

    @NotNull
    public static final Path toAbsolutePath(@NotNull VirtualFile $this$toAbsolutePath) {
        Intrinsics.checkNotNullParameter((Object)$this$toAbsolutePath, (String)"<this>");
        Path path2 = Path.of($this$toAbsolutePath.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Path path3 = path2.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
        return path3;
    }

    @NlsSafe
    @RequiresBackgroundThread
    @NotNull
    public static final String toPresentablePathAsTabTitle(@NotNull BackedNotebookVirtualFile $this$toPresentablePathAsTabTitle, @NotNull Project project, @NotNull ContentManager contentManager) {
        Intrinsics.checkNotNullParameter((Object)$this$toPresentablePathAsTabTitle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contentManager, (String)"contentManager");
        ThreadingAssertions.assertBackgroundThread();
        VirtualFile originFile = $this$toPresentablePathAsTabTitle.getOriginFile();
        String simpleName = EditorTabPresentationUtil.getEditorTabTitle((Project)project, (VirtualFile)originFile);
        return contentManager.findContent(simpleName) != null ? EditorTabPresentationUtil.getUniqueEditorTabTitle((Project)project, (VirtualFile)originFile) : simpleName;
    }

    @Nullable
    public static final BackedNotebookVirtualFile toKotlinNotebookBackedFile(@Nullable VirtualFile $this$toKotlinNotebookBackedFile) {
        return $this$toKotlinNotebookBackedFile == null || !IsKotlinNotebookKt.isKotlinNotebook($this$toKotlinNotebookBackedFile) ? null : UtilKt.toBackedNotebookFile($this$toKotlinNotebookBackedFile);
    }

    @NotNull
    public static final String getPathSeparator() {
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return string;
    }

    public static /* synthetic */ void getPathSeparator$annotations() {
    }

    private static final VirtualFile _get_parentsWithSelf_$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

