/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local;

import com.intellij.lang.Language;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.ModelVersion;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.local.BPESchema;
import org.jetbrains.completion.full.line.local.BinarySchema;
import org.jetbrains.completion.full.line.local.ConfigSchema;
import org.jetbrains.completion.full.line.local.NativeServerSchema;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Tag(value="model")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0087\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012B\t\b\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0013J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007J\u0006\u0010#\u001a\u00020\u0003J\u0014\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010'\u001a\u00020(H\u0096\u0080\u0004J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020%J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\t\u00100\u001a\u00020\tH\u00c6\u0003J\t\u00101\u001a\u00020\u000bH\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003Ja\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u00c6\u0001J\n\u00106\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u0010\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015\u00a8\u00067"}, d2={"Lorg/jetbrains/completion/full/line/local/ModelSchema;", "", "version", "", "size", "", "languages", "", "binary", "Lorg/jetbrains/completion/full/line/local/BinarySchema;", "bpe", "Lorg/jetbrains/completion/full/line/local/BPESchema;", "config", "Lorg/jetbrains/completion/full/line/local/ConfigSchema;", "native", "Lorg/jetbrains/completion/full/line/local/NativeServerSchema;", "changelog", "<init>", "(Ljava/lang/String;JLjava/util/List;Lorg/jetbrains/completion/full/line/local/BinarySchema;Lorg/jetbrains/completion/full/line/local/BPESchema;Lorg/jetbrains/completion/full/line/local/ConfigSchema;Lorg/jetbrains/completion/full/line/local/NativeServerSchema;Ljava/lang/String;)V", "()V", "getVersion", "()Ljava/lang/String;", "getSize", "()J", "getLanguages", "()Ljava/util/List;", "getBinary", "()Lorg/jetbrains/completion/full/line/local/BinarySchema;", "getBpe", "()Lorg/jetbrains/completion/full/line/local/BPESchema;", "getConfig", "()Lorg/jetbrains/completion/full/line/local/ConfigSchema;", "getNative", "()Lorg/jetbrains/completion/full/line/local/NativeServerSchema;", "getChangelog", "uid", "equals", "", "other", "hashCode", "", "suitableFor", "descriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "isUsefulModel", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "toString", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nModelSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelSchema.kt\norg/jetbrains/completion/full/line/local/ModelSchema\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1586#2:139\n1661#2,3:140\n296#2,2:143\n1642#2,10:146\n1915#2:156\n1916#2:158\n1652#2:159\n1807#2,3:160\n1#3:145\n1#3:157\n*S KotlinDebug\n*F\n+ 1 ModelSchema.kt\norg/jetbrains/completion/full/line/local/ModelSchema\n*L\n48#1:139\n48#1:140,3\n78#1:143,2\n82#1:146,10\n82#1:156\n82#1:158\n82#1:159\n82#1:160,3\n82#1:157\n*E\n"})
public final class ModelSchema {
    @Tag
    @NotNull
    private final String version;
    @Tag
    private final long size;
    @XCollection(propertyElementName="languages", elementName="language", valueAttributeName="")
    @NotNull
    private final List<String> languages;
    @Property(surroundWithTag=false)
    @NotNull
    private final BinarySchema binary;
    @Property(surroundWithTag=false)
    @NotNull
    private final BPESchema bpe;
    @Property(surroundWithTag=false)
    @NotNull
    private final ConfigSchema config;
    @Property(surroundWithTag=false)
    @Nullable
    private final NativeServerSchema native;
    @Tag
    @NotNull
    private final String changelog;

    public ModelSchema(@NotNull String version, long size, @NotNull List<String> languages, @NotNull BinarySchema binary, @NotNull BPESchema bpe, @NotNull ConfigSchema config, @Nullable NativeServerSchema nativeServerSchema, @NotNull String changelog) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)bpe, (String)"bpe");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)changelog, (String)"changelog");
        this.version = version;
        this.size = size;
        this.languages = languages;
        this.binary = binary;
        this.bpe = bpe;
        this.config = config;
        this.native = nativeServerSchema;
        this.changelog = changelog;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final long getSize() {
        return this.size;
    }

    @NotNull
    public final List<String> getLanguages() {
        return this.languages;
    }

    @NotNull
    public final BinarySchema getBinary() {
        return this.binary;
    }

    @NotNull
    public final BPESchema getBpe() {
        return this.bpe;
    }

    @NotNull
    public final ConfigSchema getConfig() {
        return this.config;
    }

    @Nullable
    public final NativeServerSchema getNative() {
        return this.native;
    }

    @NotNull
    public final String getChangelog() {
        return this.changelog;
    }

    public ModelSchema() {
        this("", 1L, CollectionsKt.emptyList(), new BinarySchema(), new BPESchema(), new ConfigSchema(), null, "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> languages() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.languages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual((Object)it, (Object)"java-v2") ? "java" : it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String uid() {
        String string = this.version + "-" + CollectionsKt.joinToString$default((Iterable)this.languages(), null, null, null, (int)0, null, null, (int)63, null);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = UUID.nameUUIDFromBytes(byArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.completion.full.line.local.ModelSchema");
        ModelSchema cfr_ignored_0 = (ModelSchema)object2;
        return Intrinsics.areEqual((Object)this.uid(), (Object)((ModelSchema)other).uid());
    }

    public int hashCode() {
        return this.uid().hashCode();
    }

    public final boolean suitableFor(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        List<String> list = this.languages();
        String string = descriptor.getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!list.contains(string2)) {
            return false;
        }
        ModelSettings modelSettings = FullLineLanguageSupporter.Companion.modelSettingsFor(descriptor.getLanguage());
        Intrinsics.checkNotNull((Object)modelSettings);
        ModelSettings modelSettings2 = modelSettings;
        String requiredVersion = modelSettings2.getVersions().selectVersionValueOrThrow(descriptor);
        return Intrinsics.areEqual((Object)this.version, (Object)requiredVersion);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isUsefulModel() {
        boolean bl;
        block10: {
            void $this$mapNotNullTo$iv$iv;
            Object $i$f$firstOrNull2;
            Iterable $this$firstOrNull$iv;
            block12: {
                block11: {
                    Object v3;
                    block9: {
                        $this$firstOrNull$iv = FullLineSettings.Companion.getAvailableLanguagesWithModel();
                        boolean $i$f$firstOrNull2 = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Language it = (Language)element$iv;
                            boolean bl2 = false;
                            List<String> list = this.languages();
                            String string = it.getID();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
                            String string2 = string.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                            if (!list.contains(string2)) continue;
                            v3 = element$iv;
                            break block9;
                        }
                        v3 = null;
                    }
                    Language language = v3;
                    if (language == null) break block11;
                    $i$f$firstOrNull2 = language;
                    FullLineLanguageSupporter.Companion companion = FullLineLanguageSupporter.Companion;
                    Language p0 = $i$f$firstOrNull2;
                    boolean bl3 = false;
                    $this$firstOrNull$iv = companion.modelSettingsFor(p0);
                    if ($this$firstOrNull$iv != null) break block12;
                }
                return false;
            }
            Iterable modelSettings = $this$firstOrNull$iv;
            Iterable $this$mapNotNull$iv = modelSettings.getVersions().getAll();
            boolean $i$f$mapNotNull = false;
            $i$f$firstOrNull2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                ModelVersion it = (ModelVersion)element$iv$iv;
                boolean bl5 = false;
                if (it.getOrNull() == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)this.version)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    public final long component2() {
        return this.size;
    }

    @NotNull
    public final List<String> component3() {
        return this.languages;
    }

    @NotNull
    public final BinarySchema component4() {
        return this.binary;
    }

    @NotNull
    public final BPESchema component5() {
        return this.bpe;
    }

    @NotNull
    public final ConfigSchema component6() {
        return this.config;
    }

    @Nullable
    public final NativeServerSchema component7() {
        return this.native;
    }

    @NotNull
    public final String component8() {
        return this.changelog;
    }

    @NotNull
    public final ModelSchema copy(@NotNull String version, long size, @NotNull List<String> languages, @NotNull BinarySchema binary, @NotNull BPESchema bpe, @NotNull ConfigSchema config, @Nullable NativeServerSchema nativeServerSchema, @NotNull String changelog) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)bpe, (String)"bpe");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)changelog, (String)"changelog");
        return new ModelSchema(version, size, languages, binary, bpe, config, nativeServerSchema, changelog);
    }

    public static /* synthetic */ ModelSchema copy$default(ModelSchema modelSchema, String string, long l, List list, BinarySchema binarySchema, BPESchema bPESchema, ConfigSchema configSchema, NativeServerSchema nativeServerSchema, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = modelSchema.version;
        }
        if ((n & 2) != 0) {
            l = modelSchema.size;
        }
        if ((n & 4) != 0) {
            list = modelSchema.languages;
        }
        if ((n & 8) != 0) {
            binarySchema = modelSchema.binary;
        }
        if ((n & 0x10) != 0) {
            bPESchema = modelSchema.bpe;
        }
        if ((n & 0x20) != 0) {
            configSchema = modelSchema.config;
        }
        if ((n & 0x40) != 0) {
            nativeServerSchema = modelSchema.native;
        }
        if ((n & 0x80) != 0) {
            string2 = modelSchema.changelog;
        }
        return modelSchema.copy(string, l, list, binarySchema, bPESchema, configSchema, nativeServerSchema, string2);
    }

    @NotNull
    public String toString() {
        return "ModelSchema(version=" + this.version + ", size=" + this.size + ", languages=" + this.languages + ", binary=" + this.binary + ", bpe=" + this.bpe + ", config=" + this.config + ", native=" + this.native + ", changelog=" + this.changelog + ")";
    }
}

