/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.provider.common.profile;

import ai.grazie.llm.profile.CloudLLMProfile;
import ai.grazie.llm.provider.common.profile.ProfileRegistryKt;
import ai.grazie.model.llm.profile.LLMProfileID;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/grazie/llm/provider/common/profile/ProfileRegistry;", "", "<init>", "()V", "profiles", "", "Lai/grazie/model/llm/profile/LLMProfileID;", "Lai/grazie/llm/profile/CloudLLMProfile;", "register", "", "profile", "getAll", "", "get", "id", "llm-provider-common"})
public class ProfileRegistry {
    @NotNull
    private final Map<LLMProfileID, CloudLLMProfile> profiles = new LinkedHashMap();

    public final void register(@NotNull CloudLLMProfile profile) {
        Intrinsics.checkNotNullParameter((Object)((Object)profile), (String)"profile");
        if (profile.isEnabled()) {
            this.profiles.put(profile.getId(), profile);
            ProfileRegistryKt.access$getLogger$p().info(() -> ProfileRegistry.register$lambda$0(profile));
        } else {
            ProfileRegistryKt.access$getLogger$p().info(() -> ProfileRegistry.register$lambda$1(profile));
        }
    }

    @NotNull
    public final List<CloudLLMProfile> getAll() {
        return CollectionsKt.toList((Iterable)this.profiles.values());
    }

    @Nullable
    public final CloudLLMProfile get(@NotNull LLMProfileID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.profiles.get(id);
    }

    private static final String register$lambda$0(CloudLLMProfile $profile) {
        return "Registered LLM profile for " + $profile.getType() + ": " + $profile.getId();
    }

    private static final String register$lambda$1(CloudLLMProfile $profile) {
        return "Skipped registration for " + $profile.getType() + " LLM profile  " + $profile.getId();
    }
}

