/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.annotations.RequiredByIntellijPlugin;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.ForceResolvedColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000f\u001a\u00028\u00002\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u00030\u0011j\u0002`\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u00030\u0011j\u0002`\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00028\u0000H\u0096\u0003\u00a2\u0006\u0002\u0010!J\t\u0010\"\u001a\u00020\u001eH\u0096\u0001J\u0010\u0010#\u001a\u0004\u0018\u00018\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010$J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0001J#\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'2\u0006\u0010(\u001a\u00020\u001e2\n\u0010)\u001a\u00020*\"\u00020\u001eH\u0096\u0003J\u0019\u0010&\u001a\n\u0012\u0002\b\u00030+j\u0002`,2\u0006\u0010-\u001a\u00020\u0017H\u0096\u0003J\u0016\u0010&\u001a\u00028\u00002\u0006\u0010.\u001a\u00020\u001eH\u0096\u0003\u00a2\u0006\u0002\u0010/J\u001e\u0010&\u001a\u00028\u00002\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u00030\u0011j\u0002`\u0012H\u0096\u0003\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e01H\u0096\u0003J\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00102\u001a\u000203H\u0096\u0003J%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u00104\u001a\u0004\u0018\u00010\u001c2\n\u00105\u001a\u0006\u0012\u0002\b\u000306H\u0096\u0003J\t\u00107\u001a\u00020\u001aH\u0096\u0001J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0096\u0003J\t\u0010:\u001a\u00020;H\u0096\u0001J\t\u0010<\u001a\u00020\u0017H\u0096\u0001J\t\u0010=\u001a\u00020>H\u0096\u0001J\t\u0010?\u001a\u00020\u001eH\u0096\u0001J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0097\u0001J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000BH\u0096\u0001J\t\u0010C\u001a\u00020DH\u0096\u0001J\u000f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0096\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/ResolvingValueColumn;", "T", "Lorg/jetbrains/kotlinx/dataframe/columns/ValueColumn;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/ForceResolvedColumn;", "source", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/columns/ValueColumn;)V", "getSource", "()Lorg/jetbrains/kotlinx/dataframe/columns/ValueColumn;", "resolve", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "resolveSingle", "getValue", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "(Lorg/jetbrains/kotlinx/dataframe/DataRow;)Ljava/lang/Object;", "getValueOrNull", "rename", "newName", "", "toString", "equals", "", "other", "", "hashCode", "", "contains", "value", "(Ljava/lang/Object;)Z", "countDistinct", "defaultValue", "()Ljava/lang/Object;", "distinct", "get", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "firstIndex", "otherIndices", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "columnName", "index", "(I)Ljava/lang/Object;", "indices", "", "range", "Lkotlin/ranges/IntRange;", "thisRef", "property", "Lkotlin/reflect/KProperty;", "hasNulls", "iterator", "", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "name", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "size", "toList", "toSet", "", "type", "Lkotlin/reflect/KType;", "values", "core"})
public final class ResolvingValueColumn<T>
implements ValueColumn<T>,
ForceResolvedColumn<T> {
    @NotNull
    private final ValueColumn<T> source;

    public ResolvingValueColumn(@NotNull ValueColumn<? extends T> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.source = source;
    }

    @Override
    @NotNull
    public ValueColumn<T> getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public List<ColumnWithPath<T>> resolve(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ValueColumn.super.resolve(context);
    }

    @Override
    @Nullable
    public ColumnWithPath<T> resolveSingle(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DataColumn dataColumn = UtilsKt.getColumn((ColumnsContainer)context.getDf(), this.getSource().name(), context.getUnresolvedColumnsPolicy());
        return dataColumn != null ? UtilsKt.addPath(dataColumn) : null;
    }

    @Override
    public T getValue(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (T)ValueColumn.super.getValue(row);
    }

    @Override
    @Nullable
    public T getValueOrNull(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (T)ValueColumn.super.getValueOrNull(row);
    }

    @Override
    @NotNull
    public ResolvingValueColumn<T> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new ResolvingValueColumn(this.getSource().rename(newName));
    }

    @NotNull
    public String toString() {
        return this.getSource().toString();
    }

    public boolean equals(@Nullable Object other) {
        return UtilsKt.checkEquals(this.getSource(), other);
    }

    public int hashCode() {
        return this.getSource().hashCode();
    }

    @Override
    @NotNull
    public ColumnKind kind() {
        return this.source.kind();
    }

    @Override
    @NotNull
    public ValueColumn<T> distinct() {
        return this.source.distinct();
    }

    @Override
    @NotNull
    public ValueColumn<T> get(@NotNull Iterable<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.source.get(indices);
    }

    @Override
    @NotNull
    public ValueColumn<T> get(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.source.get(range);
    }

    @Override
    public T get(int index) {
        return this.source.get(index);
    }

    @Override
    @NotNull
    public BaseColumn<T> get(int firstIndex, int ... otherIndices) {
        Intrinsics.checkNotNullParameter((Object)otherIndices, (String)"otherIndices");
        return this.source.get(firstIndex, otherIndices);
    }

    @Override
    public T get(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return this.source.get(row);
    }

    @Override
    @NotNull
    public DataColumn<?> get(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return this.source.get(columnName);
    }

    @Override
    @NotNull
    public ValueColumn<T> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.source.getValue(thisRef, (KProperty)property);
    }

    @Override
    public boolean hasNulls() {
        return this.source.hasNulls();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.source.iterator();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    @NotNull
    public KType type() {
        return this.source.type();
    }

    @Override
    @Nullable
    public T defaultValue() {
        return this.source.defaultValue();
    }

    @Override
    @NotNull
    public Iterable<T> values() {
        return this.source.values();
    }

    @Override
    @RequiredByIntellijPlugin
    @NotNull
    public List<T> toList() {
        return this.source.toList();
    }

    @Override
    @NotNull
    public Set<T> toSet() {
        return this.source.toSet();
    }

    @Override
    public int countDistinct() {
        return this.source.countDistinct();
    }

    @Override
    public boolean contains(T value) {
        return this.source.contains(value);
    }

    @Override
    @NotNull
    public String name() {
        return this.source.name();
    }

    @Override
    @NotNull
    public ColumnPath path() {
        return this.source.path();
    }
}

