/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.plugins.add.starters.dialog;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependencyRepository;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.initializr.json.KtorPluginDescriptor;
import com.intellij.ktor.plugins.add.KtorPluginsUtilsKt;
import com.intellij.ktor.plugins.add.starters.KtorPluginUpdateService;
import com.intellij.ktor.plugins.add.starters.dialog.KtorAddPluginsStep;
import com.intellij.ktor.plugins.add.starters.dialog.KtorModuleAddPluginsInfo;
import com.intellij.ktor.utils.KtorVersionModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ktor/plugins/add/starters/dialog/KtorPluginsDialogWrapper;", "Lcom/intellij/openapi/ui/DialogWrapper;", "module", "Lcom/intellij/openapi/module/Module;", "ktorVersion", "Lcom/intellij/ktor/utils/KtorVersionModel;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/ktor/utils/KtorVersionModel;)V", "moduleInfo", "Lcom/intellij/ktor/plugins/add/starters/dialog/KtorModuleAddPluginsInfo;", "pluginsStep", "Lcom/intellij/ktor/plugins/add/starters/dialog/KtorAddPluginsStep;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getStyle", "Lcom/intellij/openapi/ui/DialogWrapper$DialogStyle;", "doOKAction", "", "intellij.ktor"})
public final class KtorPluginsDialogWrapper
extends DialogWrapper {
    @NotNull
    private final Module module;
    @NotNull
    private final KtorModuleAddPluginsInfo moduleInfo;
    @Nullable
    private KtorAddPluginsStep pluginsStep;

    public KtorPluginsDialogWrapper(@NotNull Module module, @NotNull KtorVersionModel ktorVersion) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)ktorVersion, (String)"ktorVersion");
        super(module.getProject());
        this.module = module;
        this.moduleInfo = new KtorModuleAddPluginsInfo(ktorVersion);
        this.setTitle(KtorStarterBundle.INSTANCE.message("ktor.add.starters.plugin.dialog.wrapper.title", new Object[0]));
        this.setOKActionEnabled(false);
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent component;
        block0: {
            this.setOKActionEnabled(true);
            KtorAddPluginsStep librariesStep = new KtorAddPluginsStep(this.module, this.moduleInfo, new WizardContext(this.module.getProject(), this.myDisposable));
            librariesStep._init();
            component = librariesStep.getComponent();
            component.setMinimumSize(new Dimension(800, 565));
            JComponent jComponent = librariesStep.getPreferredFocusedComponent();
            if (jComponent == null) break block0;
            jComponent.requestFocus();
        }
        return component;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Object object = this.pluginsStep;
        if (object == null || (object = object.getPreferredFocusedComponent()) == null) {
            object = super.getPreferredFocusedComponent();
        }
        return object;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    protected void doOKAction() {
        List<KtorPluginDescriptor> addedPluginsDescriptors = this.moduleInfo.getSelectedPluginDescriptors();
        List<UnifiedDependency> dependencies = KtorPluginsUtilsKt.extractDependenciesFromPlugins(addedPluginsDescriptors);
        List<UnifiedDependencyRepository> repositories = KtorPluginsUtilsKt.extractRepositoriesFromPlugins(addedPluginsDescriptors);
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtorPluginUpdateService.Companion.getInstance(project).updateDependencies(this.module, dependencies, repositories);
        super.doOKAction();
    }
}

