/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.ktor.run.KtorRunConfiguration;
import com.intellij.ktor.run.KtorRunConfigurationProducerKt;
import com.intellij.ktor.run.KtorRunConfigurationTypeKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetectorKt;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ktor/run/KtorRunConfigurationProducer;", "Lcom/intellij/execution/junit/JavaRunConfigurationProducerBase;", "Lcom/intellij/ktor/run/KtorRunConfiguration;", "<init>", "()V", "isDumbAware", "", "setupConfigurationFromContext", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getKtorMainClassFqName", "", "location", "Lcom/intellij/execution/Location;", "findMainFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "container", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "intellij.ktor"})
public final class KtorRunConfigurationProducer
extends JavaRunConfigurationProducerBase<KtorRunConfiguration> {
    public boolean isDumbAware() {
        return true;
    }

    protected boolean setupConfigurationFromContext(@NotNull KtorRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        if (!KtorRunConfigurationProducerKt.access$isKtorConfigurationAvailable(location2.getModule())) {
            return false;
        }
        String string = this.getKtorMainClassFqName((Location<PsiElement>)location2);
        if (string == null) {
            return false;
        }
        String startClassFqName = string;
        KtorRunConfiguration $this$setupConfigurationFromContext_u24lambda_u240 = configuration;
        boolean bl = false;
        $this$setupConfigurationFromContext_u24lambda_u240.setMainClassName(startClassFqName);
        $this$setupConfigurationFromContext_u24lambda_u240.setGeneratedName();
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)$this$setupConfigurationFromContext_u24lambda_u240);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConfigurationFromContext(@NotNull KtorRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinMainFunctionDetector detector = KotlinMainFunctionDetector.Companion.getInstanceDumbAware(project);
        Location location = context.getLocation();
        Location location2 = location;
        if (location == null) return false;
        if ((location2 = location2.getPsiElement()) == null) {
            return false;
        }
        Location psiElement = location2;
        KtDeclarationContainer ktDeclarationContainer = KotlinMainFunctionDetectorKt.findMainOwner((KotlinMainFunctionDetector)detector, (PsiElement)psiElement);
        if (ktDeclarationContainer == null) {
            return false;
        }
        KtDeclarationContainer container = ktDeclarationContainer;
        String string = KotlinRunConfigurationProducer.Companion.getMainClassQualifiedName(container);
        if (string == null) {
            return false;
        }
        String startClassFQName = string;
        Module module = context.getModule();
        if (!Intrinsics.areEqual((Object)configuration.getMainClassName(), (Object)startClassFQName)) return false;
        if (!KtorRunConfigurationProducerKt.access$isKtorConfigurationAvailable(module)) return false;
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration.getConfigurationModule();
        if (!Intrinsics.areEqual((Object)module, (Object)(javaRunConfigurationModule != null ? javaRunConfigurationModule.getModule() : null))) return false;
        return true;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ConfigurationFactory factory = other.getConfiguration().getFactory();
        return factory != null && Intrinsics.areEqual((Object)factory.getOptionsClass(), JvmMainMethodRunConfigurationOptions.class);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return KtorRunConfigurationTypeKt.ktorRunConfigurationType().getDefaultConfigurationFactory();
    }

    private final String getKtorMainClassFqName(Location<PsiElement> location) {
        Project project = location.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinMainFunctionDetector detector = KotlinMainFunctionDetector.Companion.getInstanceDumbAware(project);
        PsiElement psiElement = location.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        KtDeclarationContainer ktDeclarationContainer = KotlinMainFunctionDetectorKt.findMainOwner((KotlinMainFunctionDetector)detector, (PsiElement)psiElement);
        if (ktDeclarationContainer == null) {
            return null;
        }
        KtDeclarationContainer container = ktDeclarationContainer;
        KtNamedFunction ktNamedFunction = this.findMainFunction(detector, container);
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction mainFunction = ktNamedFunction;
        if (!KtorRunConfigurationProducerKt.access$isKtorApplication(mainFunction)) {
            return null;
        }
        return KotlinRunConfigurationProducer.Companion.getMainClassQualifiedName(container);
    }

    private final KtNamedFunction findMainFunction(KotlinMainFunctionDetector $this$findMainFunction, KtDeclarationContainer container) {
        KtDeclarationContainer ktDeclarationContainer = container;
        return ktDeclarationContainer instanceof KtFile ? KotlinMainFunctionDetectorKt.findMain$default((KotlinMainFunctionDetector)$this$findMainFunction, (KtFile)((KtFile)container), null, (int)2, null) : (ktDeclarationContainer instanceof KtClassOrObject ? KotlinMainFunctionDetectorKt.findMain$default((KotlinMainFunctionDetector)$this$findMainFunction, (KtClassOrObject)((KtClassOrObject)container), null, (int)2, null) : null);
    }
}

