/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.test;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UClassInitializerEx;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInspection/test/TestCaseWithConstructorVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitInitializer", "", "node", "Lorg/jetbrains/uast/UClassInitializer;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "isAssignmentToFinalField", "expression", "Lorg/jetbrains/uast/UExpression;", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nTestCaseWithConstructorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestCaseWithConstructorInspection.kt\ncom/intellij/codeInspection/test/TestCaseWithConstructorVisitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,63:1\n19#2:64\n19#2:65\n19#2:66\n*S KotlinDebug\n*F\n+ 1 TestCaseWithConstructorInspection.kt\ncom/intellij/codeInspection/test/TestCaseWithConstructorVisitor\n*L\n35#1:64\n57#1:65\n59#1:66\n*E\n"})
final class TestCaseWithConstructorVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public TestCaseWithConstructorVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public boolean visitInitializer(@NotNull UClassInitializer node) {
        UClassInitializerEx uClassInitializerEx;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.isStatic()) {
            return true;
        }
        UClassInitializer $this$asSafely$iv = node;
        boolean $i$f$asSafely = false;
        UClassInitializer uClassInitializer = $this$asSafely$iv;
        if (!(uClassInitializer instanceof UClassInitializerEx)) {
            uClassInitializer = null;
        }
        if ((uClassInitializerEx = (UClassInitializerEx)uClassInitializer) == null || (uClassInitializerEx = uClassInitializerEx.getJavaPsi()) == null || (uClassInitializerEx = uClassInitializerEx.getContainingClass()) == null) {
            return true;
        }
        UClassInitializerEx containingClass = uClassInitializerEx;
        if (!TestFrameworks.getInstance().isTestClass((PsiClass)containingClass)) {
            return true;
        }
        if (MethodUtils.isTrivial((UClassInitializer)node)) {
            return true;
        }
        String message = JvmAnalysisBundle.message("jvm.inspections.test.case.with.constructor.problem.descriptor.initializer", new Object[0]);
        UDeclaration uDeclaration = (UDeclaration)node;
        Intrinsics.checkNotNull((Object)message);
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }

    public boolean visitMethod(@NotNull UMethod node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiMethod method = node.getJavaPsi();
        if (!node.isConstructor()) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        PsiClass containingClass = psiClass;
        if (!TestFrameworks.getInstance().isTestClass(containingClass)) {
            return true;
        }
        if (TestUtils.isParameterizedTest((PsiClass)containingClass)) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.TestSuite")) {
            return true;
        }
        if (MethodUtils.isTrivial((UMethod)node, arg_0 -> TestCaseWithConstructorVisitor.visitMethod$lambda$0((Function1)new Function1<UExpression, Boolean>((Object)this){

            public final Boolean invoke(UExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return TestCaseWithConstructorVisitor.access$isAssignmentToFinalField((TestCaseWithConstructorVisitor)((Object)this.receiver), p0);
            }
        }, arg_0))) {
            return true;
        }
        String message = JvmAnalysisBundle.message("jvm.inspections.test.case.with.constructor.problem.descriptor", new Object[0]);
        UDeclaration uDeclaration = (UDeclaration)node;
        Intrinsics.checkNotNull((Object)message);
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }

    private final boolean isAssignmentToFinalField(UExpression expression) {
        UExpression $this$asSafely$iv = expression;
        boolean $i$f$asSafely = false;
        UExpression uExpression = $this$asSafely$iv;
        if (!(uExpression instanceof UBinaryExpression)) {
            uExpression = null;
        }
        UBinaryExpression uBinaryExpression = (UBinaryExpression)uExpression;
        if (uBinaryExpression == null) {
            return false;
        }
        UBinaryExpression assignmentExpression = uBinaryExpression;
        if (!Intrinsics.areEqual((Object)assignmentExpression.getOperator(), (Object)UastBinaryOperator.EQUALS)) {
            return false;
        }
        UExpression $this$asSafely$iv2 = UastUtils.skipParenthesizedExprDown((UExpression)assignmentExpression.getLeftOperand());
        boolean $i$f$asSafely2 = false;
        UExpression uExpression2 = $this$asSafely$iv2;
        if (!(uExpression2 instanceof UReferenceExpression)) {
            uExpression2 = null;
        }
        UReferenceExpression uReferenceExpression = (UReferenceExpression)uExpression2;
        if (uReferenceExpression == null) {
            return false;
        }
        UReferenceExpression lhs = uReferenceExpression;
        UElement target = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)lhs));
        return target instanceof UFieldEx && ((UFieldEx)target).getJavaPsi().hasModifier(JvmModifier.FINAL);
    }

    private static final boolean visitMethod$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isAssignmentToFinalField(TestCaseWithConstructorVisitor $this, UExpression expression) {
        return $this.isAssignmentToFinalField(expression);
    }
}

