/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.css.utils;

import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0006H\u0014J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/inline/completion/css/utils/CssMLCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "lexerProvider", "Lkotlin/Function0;", "Lcom/intellij/lexer/Lexer;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;Lkotlin/jvm/functions/Function0;)V", "createBaseLexer", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "bracketsSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.fullLine.css"})
public final class CssMLCompletionLexer
extends MLCompletionLexerAdapter {
    @NotNull
    private final Function0<Lexer> lexerProvider;
    @NotNull
    private final TokenSet bracketsSet;

    public CssMLCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosures2, @NotNull Function0<? extends Lexer> lexerProvider) {
        Intrinsics.checkNotNullParameter((Object)enclosures2, (String)"enclosures");
        Intrinsics.checkNotNullParameter(lexerProvider, (String)"lexerProvider");
        super(enclosures2);
        this.lexerProvider = lexerProvider;
        IElementType[] iElementTypeArray = new IElementType[]{CssElementTypes.CSS_LPAREN, CssElementTypes.CSS_RPAREN, CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE, CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_RBRACKET};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.bracketsSet = tokenSet;
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        return (Lexer)this.lexerProvider.invoke();
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text2, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        if (this.bracketsSet.contains(token)) {
            collector2.bracket(StringsKt.first((CharSequence)text2), offset);
            return;
        }
        if (Intrinsics.areEqual((Object)token, (Object)CssElementTypes.CSS_STRING_TOKEN)) {
            char quote = StringsKt.first((CharSequence)text2);
            if (this.getEnclosures().isStringMarker(quote)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, quote, offset, null, 4, null);
                if (StringsKt.last((CharSequence)text2) == quote && text2.length() > 1 && (text2.length() - 3 < 0 || text2.charAt(text2.length() - 2) != '\\' || text2.charAt(text2.length() - 3) == '\\')) {
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, quote, offset + text2.length() - 1, null, 4, null);
                }
            }
        } else if (this.seemsLikeSpecialToken(text2)) {
            collector2.special(text2, offset);
        }
    }
}

