/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.features.correctness;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.ml.inline.completion.features.correctness.InspectionBasedEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.OnRangeElementsEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.RawEnrichmentTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0001\u0010J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0003\u0011\u0012\u0013\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool;", "", "aspect", "Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool$Aspect;", "getAspect", "()Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool$Aspect;", "getLocationInSuggestion", "Lcom/intellij/openapi/util/TextRange;", "rangeInFile", "offset", "", "suggestion", "", "getErrorRangeInFile", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Aspect", "Lcom/intellij/ml/inline/completion/features/correctness/InspectionBasedEnrichmentTool;", "Lcom/intellij/ml/inline/completion/features/correctness/OnRangeElementsEnrichmentTool;", "Lcom/intellij/ml/inline/completion/features/correctness/RawEnrichmentTool;", "intellij.fullLine.core.completion"})
public sealed interface EnrichmentTool
permits InspectionBasedEnrichmentTool, OnRangeElementsEnrichmentTool, RawEnrichmentTool {
    @NotNull
    public Aspect getAspect();

    @Nullable
    default public TextRange getLocationInSuggestion(@NotNull TextRange rangeInFile, int offset, @NotNull String suggestion2) {
        Intrinsics.checkNotNullParameter((Object)rangeInFile, (String)"rangeInFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        TextRange textRange = new TextRange(0, suggestion2.length()).shiftRight(offset);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange suggestionLocationInFile = textRange;
        if (!suggestionLocationInFile.intersects(rangeInFile)) {
            return null;
        }
        TextRange textRange2 = suggestionLocationInFile.intersection(rangeInFile);
        Intrinsics.checkNotNull((Object)textRange2);
        return textRange2.shiftLeft(offset);
    }

    @NotNull
    default public TextRange getErrorRangeInFile(@NotNull ProblemDescriptor problemDescriptor) {
        InjectedLanguageManager injectionManager;
        TextRange rangeInElement;
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = problemDescriptor.getPsiElement();
        PsiFile psiFile2 = psiElement.getContainingFile();
        TextRange textRange = problemDescriptor.getTextRangeInElement();
        if (textRange == null) {
            textRange = rangeInElement = new TextRange(0, psiElement.getTextLength());
        }
        if ((injectionManager = InjectedLanguageManager.getInstance((Project)psiElement.getProject())).isInjectedFragment(psiFile2)) {
            int offset = injectionManager.injectedToHost(psiElement, rangeInElement.getStartOffset());
            TextRange textRange2 = rangeInElement.shiftRight(offset);
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
            return textRange2;
        }
        TextRange textRange3 = rangeInElement.shiftRight(psiElement.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"shiftRight(...)");
        return textRange3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool$Aspect;", "", "<init>", "(Ljava/lang/String;I)V", "HIGHLIGHTING", "RED_CODE_ANALYSIS", "COMMENTS", "UNKNOWN", "intellij.fullLine.core.completion"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect HIGHLIGHTING = new Aspect();
        public static final /* enum */ Aspect RED_CODE_ANALYSIS = new Aspect();
        public static final /* enum */ Aspect COMMENTS = new Aspect();
        public static final /* enum */ Aspect UNKNOWN = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        @NotNull
        public static EnumEntries<Aspect> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.HIGHLIGHTING, Aspect.RED_CODE_ANALYSIS, Aspect.COMMENTS, Aspect.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

