/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.completion;

import com.intellij.codeInsight.inline.completion.editor.InlineCompletionEditorType;
import com.intellij.ml.inline.completion.impl.cache.LightweightCacheKeyEditorAttribute;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.vcs.completion.CommitMessagesLightweightCacheKeyAttributeKt;
import com.intellij.ml.llm.vcs.completion.context.CommitMessagesVcsUtilsKt;
import com.intellij.ml.llm.vcs.completion.context.VcsChangesSnapshot;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0017\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/vcs/completion/CommitMessagesLightweightCacheKeyAttribute;", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKeyEditorAttribute;", "<init>", "()V", "isApplicable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "calculateEditorHash", "", "(Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "intellij.ml.llm.vcs.completion"})
public final class CommitMessagesLightweightCacheKeyAttribute
implements LightweightCacheKeyEditorAttribute {
    @Override
    public boolean isApplicable(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return InlineCompletionEditorType.Companion.get(editor2) == InlineCompletionEditorType.COMMIT_MESSAGES;
    }

    @Override
    @Nullable
    public Integer calculateEditorHash(@NotNull Editor editor2) {
        VcsLogProvider vcsLogProvider;
        VirtualFile root;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        VcsChangesSnapshot vcsChangesSnapshot = (VcsChangesSnapshot)editor2.getUserData(CommitMessagesLightweightCacheKeyAttributeKt.getVCS_CHANGES_SNAPSHOT_KEY());
        if (vcsChangesSnapshot == null) {
            return null;
        }
        VcsChangesSnapshot vcsChanges = vcsChangesSnapshot;
        VirtualFile virtualFile = root = vcsChanges.findAnyRelatedRoot(project3);
        VcsLogProvider vcsLogProvider2 = vcsLogProvider = virtualFile != null ? CommitMessagesVcsUtilsKt.getVcsLogProvider(virtualFile, project3) : null;
        String branchName = vcsLogProvider2 != null ? vcsLogProvider2.getCurrentBranch(root) : null;
        PSString diff = vcsChanges.getChangesDiff(project3);
        CharSequence charSequence = branchName;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)diff) == null || charSequence.length() == 0)) {
            return null;
        }
        String string = branchName;
        if (string == null) {
            string = "";
        }
        PSString pSString = diff;
        String dataForHash = string + "|" + (pSString != null ? (CharSequence)pSString : (CharSequence)"");
        return Strings.stringHashCode((CharSequence)dataForHash);
    }
}

