/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.collections.visualizer.jvm;

import com.intellij.debugger.collections.visualizer.jvm.BaseFieldsConverter;
import com.intellij.debugger.collections.visualizer.jvm.FieldsConverter;
import com.intellij.debugger.collections.visualizer.jvm.JvmCollectionAccessor;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/debugger/collections/visualizer/jvm/JvmArrayAccessor;", "Lcom/intellij/debugger/collections/visualizer/jvm/JvmCollectionAccessor;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "fieldsConverter", "Lcom/intellij/debugger/collections/visualizer/jvm/FieldsConverter;", "<init>", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;Lcom/intellij/debugger/collections/visualizer/jvm/FieldsConverter;)V", "size", "", "value", "Lcom/sun/jdi/ObjectReference;", "(Lcom/sun/jdi/ObjectReference;)Ljava/lang/Long;", "elementAt", "Lcom/sun/jdi/Value;", "elementIdx", "", "subCollection", "Lkotlinx/coroutines/flow/Flow;", "startIndex", "amount", "intellij.debugger.collections.visualizer.jvm"})
@ApiStatus.Experimental
public final class JvmArrayAccessor
extends JvmCollectionAccessor {
    public JvmArrayAccessor(@NotNull EvaluationContextImpl context, @NotNull ValueDescriptorImpl descriptor, @NotNull FieldsConverter fieldsConverter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)fieldsConverter, (String)"fieldsConverter");
        super(context, (ValueDescriptor)descriptor, fieldsConverter);
    }

    public /* synthetic */ JvmArrayAccessor(EvaluationContextImpl evaluationContextImpl, ValueDescriptorImpl valueDescriptorImpl, FieldsConverter fieldsConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fieldsConverter = new BaseFieldsConverter(evaluationContextImpl);
        }
        this(evaluationContextImpl, valueDescriptorImpl, fieldsConverter);
    }

    @Override
    @NotNull
    protected Long size(@NotNull ObjectReference value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((ArrayReference)value).length();
    }

    @Override
    @Nullable
    protected Value elementAt(@NotNull ObjectReference value, int elementIdx) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((ArrayReference)value).getValue(elementIdx);
    }

    @Override
    @NotNull
    protected Flow<Value> subCollection(@NotNull ObjectReference value, int startIndex, int amount) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List<Value> list = ((ArrayReference)value).getValues(startIndex, amount);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValues(...)");
        return FlowKt.asFlow((Iterable)list);
    }
}

