/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLexerUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.idCache.XmlFilterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.expr.VueJSLanguage;
import org.jetbrains.vuejs.lang.expr.VueTSLanguage;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.lang.html.highlighting.VueSyntaxHighlighterFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/vuejs/lang/html/index/VueFilterLexer;", "Lcom/intellij/psi/impl/cache/impl/BaseFilterLexer;", "occurrenceConsumer", "Lcom/intellij/psi/impl/cache/impl/OccurrenceConsumer;", "originalLexer", "Lcom/intellij/lexer/Lexer;", "<init>", "(Lcom/intellij/psi/impl/cache/impl/OccurrenceConsumer;Lcom/intellij/lexer/Lexer;)V", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/psi/impl/cache/impl/OccurrenceConsumer;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "advance", "", "Companion", "intellij.vuejs.backend"})
public final class VueFilterLexer
extends BaseFilterLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashSet<Language> SUPPORTED_LANGUAGES;
    @NotNull
    private static final TokenSet COMMENTS;
    @NotNull
    private static final TokenSet XML_IN_PLAIN_TEXT_TOKENS;
    @NotNull
    private static final TokenSet SKIP_WORDS;

    public VueFilterLexer(@NotNull OccurrenceConsumer occurrenceConsumer, @NotNull Lexer originalLexer) {
        Intrinsics.checkNotNullParameter((Object)occurrenceConsumer, (String)"occurrenceConsumer");
        Intrinsics.checkNotNullParameter((Object)originalLexer, (String)"originalLexer");
        super(originalLexer, occurrenceConsumer);
    }

    public VueFilterLexer(@NotNull OccurrenceConsumer occurrenceConsumer, @Nullable Project project, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)occurrenceConsumer, (String)"occurrenceConsumer");
        this(occurrenceConsumer, VueFilterLexer.Companion.getHighlightingLexer(project, file));
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (!SKIP_WORDS.contains(tokenType)) {
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                this.addOccurrenceInToken(1);
            } else if (XML_IN_PLAIN_TEXT_TOKENS.contains(tokenType)) {
                this.scanWordsInToken((short)(0x10 | 8), tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, false);
            } else if (tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN || tokenType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                this.scanWordsInToken(1, false, false);
            } else if (COMMENTS.contains(tokenType)) {
                this.scanWordsInToken(2, false, false);
                this.advanceTodoItemCountsInToken();
            } else if (JSTokenTypes.STRING_LITERALS.contains(tokenType) || tokenType == JSTokenTypes.STRING_TEMPLATE_PART) {
                this.scanWordsInToken((short)(4 | 8), true, false);
            } else if (tokenType != null && !SUPPORTED_LANGUAGES.contains(tokenType.getLanguage())) {
                boolean inComments = CacheUtil.isInComments((IElementType)tokenType);
                this.scanWordsInToken((short)(inComments ? 2 : (short)(0x10 | 8)), true, false);
                if (inComments) {
                    this.advanceTodoItemCountsInToken();
                }
            } else {
                this.scanWordsInToken(16, false, false);
            }
        }
        this.myDelegate.advance();
    }

    static {
        Object[] objectArray = new Language[]{XMLLanguage.INSTANCE, HTMLLanguage.INSTANCE, VueLanguage.INSTANCE, VueJSLanguage.INSTANCE, VueTSLanguage.INSTANCE, Language.ANY};
        HashSet hashSet = ContainerUtil.newHashSet((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        SUPPORTED_LANGUAGES = hashSet;
        objectArray = new TokenSet[2];
        objectArray[0] = JSElementTypes.COMMENTS;
        IElementType[] iElementTypeArray = new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS};
        objectArray[1] = TokenSet.create((IElementType[])iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        COMMENTS = tokenSet;
        objectArray = new IElementType[]{XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_NAME, XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_DATA_CHARACTERS, XmlElementType.XML_TEXT, XmlElementType.HTML_RAW_TEXT, XmlTokenType.XML_TAG_CHARACTERS};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        XML_IN_PLAIN_TEXT_TOKENS = tokenSet2;
        objectArray = new TokenSet[3];
        objectArray[0] = JSLexerUtil.SKIP_WORDS_SCAN_SET;
        objectArray[1] = XmlFilterLexer.NO_WORDS_TOKEN_SET;
        iElementTypeArray = new IElementType[]{XmlTokenType.XML_COMMA};
        objectArray[2] = TokenSet.create((IElementType[])iElementTypeArray);
        TokenSet tokenSet3 = TokenSet.orSet((TokenSet[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"orSet(...)");
        SKIP_WORDS = tokenSet3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R!\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/vuejs/lang/html/index/VueFilterLexer$Companion;", "", "<init>", "()V", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "SUPPORTED_LANGUAGES", "Ljava/util/HashSet;", "Lcom/intellij/lang/Language;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "COMMENTS", "Lcom/intellij/psi/tree/TokenSet;", "XML_IN_PLAIN_TEXT_TOKENS", "SKIP_WORDS", "intellij.vuejs.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final Lexer getHighlightingLexer(Project project, VirtualFile file) {
            Lexer lexer = VueSyntaxHighlighterFactory.Util.INSTANCE.getSyntaxHighlighter(project, file, LangMode.NO_TS).getHighlightingLexer();
            Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"getHighlightingLexer(...)");
            return lexer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

