/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.lsp.LspServerActivationRule;
import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.lang.typescript.lsp.ServiceActivationHelper;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VueLspActivationHelper;
import org.jetbrains.vuejs.lang.typescript.service.VueLspServerLoader;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueLspServerActivationRule;", "Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "<init>", "()V", "isFileAcceptable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vuejs.backend"})
public final class VueLspServerActivationRule
extends LspServerActivationRule {
    @NotNull
    public static final VueLspServerActivationRule INSTANCE = new VueLspServerActivationRule();

    private VueLspServerActivationRule() {
        super((LspServerLoader)VueLspServerLoader.INSTANCE, (ServiceActivationHelper)VueLspActivationHelper.INSTANCE);
    }

    public boolean isFileAcceptable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!TypeScriptLanguageServiceUtil.IS_VALID_FILE_FOR_SERVICE.value((Object)file)) {
            return false;
        }
        return VueFileTypeKt.isVueFile(file) || TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file);
    }
}

