/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.ObjIntConsumer;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;

final class IntIntTransientMultiMaplet
extends IntIntMultiMaplet {
    private final Int2ObjectMap<IntSet> myMap = new Int2ObjectOpenHashMap();

    IntIntTransientMultiMaplet() {
    }

    @Override
    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public IntSet get(int key) {
        return (IntSet)this.myMap.get(key);
    }

    @Override
    public void putAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.put(value, (IntSet)integers));
    }

    @Override
    public void put(int key, IntSet value) {
        IntSet x = (IntSet)this.myMap.get(key);
        if (x == null) {
            this.myMap.put(key, (Object)value);
        } else {
            x.addAll((IntCollection)value);
        }
    }

    @Override
    public void replace(int key, IntSet value) {
        if (value == null || value.isEmpty()) {
            this.myMap.remove(key);
        } else {
            this.myMap.put(key, (Object)value);
        }
    }

    @Override
    public void put(int key, int value) {
        IntSet collection = (IntSet)this.myMap.get(key);
        if (collection == null) {
            IntOpenHashSet x = new IntOpenHashSet();
            x.add(value);
            this.myMap.put(key, (Object)x);
        } else {
            collection.add(value);
        }
    }

    @Override
    public void removeFrom(int key, int value) {
        IntSet collection = (IntSet)this.myMap.get(key);
        if (collection != null && collection.remove(value) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void removeAll(int key, IntSet values) {
        IntSet collection = (IntSet)this.myMap.get(key);
        if (collection != null) {
            collection.removeAll((IntCollection)values);
            if (collection.isEmpty()) {
                this.myMap.remove(key);
            }
        }
    }

    @Override
    public void remove(int key) {
        this.myMap.remove(key);
    }

    @Override
    public void replaceAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.replace(value, (IntSet)integers));
    }

    @Override
    void forEachEntry(ObjIntConsumer<? super IntSet> proc) {
        this.myMap.forEach((integer, integers) -> proc.accept((IntSet)integers, integer));
    }

    @Override
    public void close() {
        this.myMap.clear();
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
    }
}

