/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi.reference;

import com.intellij.editorconfig.common.syntax.psi.EditorConfigDescribableElement;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigFlatOptionKey;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.impl.EditorConfigReferenceSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.psi.reference.EditorConfigConstantReference;
import org.editorconfig.language.psi.reference.EditorConfigDeclarationReference;
import org.editorconfig.language.psi.reference.EditorConfigFlatOptionKeyReference;
import org.editorconfig.language.psi.reference.EditorConfigHeaderReference;
import org.editorconfig.language.psi.reference.EditorConfigIdentifierReference;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptorUtilKt;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigReferenceDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.editorconfig.language.util.EditorConfigDescriptorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/editorconfig/language/psi/reference/BackendEditorConfigReferenceSupport;", "Lcom/intellij/editorconfig/common/syntax/psi/impl/EditorConfigReferenceSupport;", "<init>", "()V", "getReference", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigDescribableElement;", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nBackendEditorConfigReferenceSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorConfigReferenceSupport.kt\norg/editorconfig/language/psi/reference/BackendEditorConfigReferenceSupport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,41:1\n13#2:42\n*S KotlinDebug\n*F\n+ 1 BackendEditorConfigReferenceSupport.kt\norg/editorconfig/language/psi/reference/BackendEditorConfigReferenceSupport\n*L\n34#1:42\n*E\n"})
public final class BackendEditorConfigReferenceSupport
implements EditorConfigReferenceSupport {
    @NotNull
    public PsiReference getReference(@NotNull EditorConfigHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (PsiReference)new EditorConfigHeaderReference(element);
    }

    @Nullable
    public PsiReference getReference(@NotNull EditorConfigDescribableElement element) {
        PsiReference psiReference;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof EditorConfigFlatOptionKey) {
            return (PsiReference)new EditorConfigFlatOptionKeyReference((EditorConfigFlatOptionKey)element);
        }
        EditorConfigDescriptor descriptor = EditorConfigDescriptorUtilKt.getDescriptor(element, false);
        if (descriptor instanceof EditorConfigDeclarationDescriptor) {
            psiReference = (PsiReference)new EditorConfigDeclarationReference(element);
        } else if (descriptor instanceof EditorConfigReferenceDescriptor) {
            psiReference = (PsiReference)new EditorConfigIdentifierReference(element, ((EditorConfigReferenceDescriptor)descriptor).getId());
        } else if (descriptor instanceof EditorConfigConstantDescriptor) {
            psiReference = (PsiReference)new EditorConfigConstantReference(element);
        } else if (descriptor instanceof EditorConfigUnionDescriptor) {
            EditorConfigConstantReference editorConfigConstantReference;
            if (EditorConfigDescriptorUtil.INSTANCE.isConstant(descriptor)) {
                editorConfigConstantReference = new EditorConfigConstantReference(element);
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BackendEditorConfigReferenceSupport.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Got non-constant union");
                editorConfigConstantReference = null;
            }
            psiReference = (PsiReference)editorConfigConstantReference;
        } else {
            psiReference = null;
        }
        return psiReference;
    }
}

