/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.services.impl;

import com.intellij.editorconfig.common.plugin.EditorConfigFileType;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigCharClassPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigDescribableElement;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigFlatOptionKey;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOption;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValueIdentifier;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPsiFile;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigQualifiedKeyPart;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigQualifiedOptionKey;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigRootDeclaration;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigSection;
import com.intellij.editorconfig.common.syntax.psi.impl.EditorConfigElementFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.filetype.EditorConfigFileConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigElementFactoryImpl;", "Lcom/intellij/editorconfig/common/syntax/psi/impl/EditorConfigElementFactory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createDummyFile", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigPsiFile;", "content", "", "createRootDeclaration", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigRootDeclaration;", "file", "Lcom/intellij/psi/PsiFile;", "createSection", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigSection;", "source", "createHeader", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;", "createPattern", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigPattern;", "createCharClassPattern", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigCharClassPattern;", "createAnyValue", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigDescribableElement;", "createValueIdentifier", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigOptionValueIdentifier;", "createOption", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigOption;", "createKey", "createKeyPart", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigQualifiedKeyPart;", "intellij.editorconfig.backend"})
public final class EditorConfigElementFactoryImpl
implements EditorConfigElementFactory {
    @NotNull
    private final Project project;

    public EditorConfigElementFactoryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final EditorConfigPsiFile createDummyFile(CharSequence content) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText(EditorConfigFileConstants.INSTANCE.getFILE_NAME(), (FileType)EditorConfigFileType.INSTANCE, content);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.editorconfig.common.syntax.psi.EditorConfigPsiFile");
        return (EditorConfigPsiFile)psiFile;
    }

    @NotNull
    public EditorConfigRootDeclaration createRootDeclaration(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = this.createDummyFile(EditorConfigFileConstants.INSTANCE.getRootDeclarationFor(file)).getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.editorconfig.common.syntax.psi.EditorConfigRootDeclaration");
        return (EditorConfigRootDeclaration)psiElement;
    }

    @NotNull
    public EditorConfigSection createSection(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return (EditorConfigSection)CollectionsKt.single((List)this.createDummyFile(source).getSections());
    }

    @NotNull
    public EditorConfigHeader createHeader(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigHeader editorConfigHeader = this.createSection(source).getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
        return editorConfigHeader;
    }

    @NotNull
    public EditorConfigPattern createPattern(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigPattern editorConfigPattern = this.createSection("[" + source + "]").getHeader().getPattern();
        Intrinsics.checkNotNull((Object)editorConfigPattern);
        return editorConfigPattern;
    }

    @NotNull
    public EditorConfigCharClassPattern createCharClassPattern(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)this.createPattern(source)), EditorConfigCharClassPattern.class, (boolean)false);
        Intrinsics.checkNotNull((Object)psiElement);
        return (EditorConfigCharClassPattern)psiElement;
    }

    @NotNull
    public EditorConfigDescribableElement createAnyValue(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigDescribableElement editorConfigDescribableElement = this.createOption("foo=" + source).getAnyValue();
        Intrinsics.checkNotNull((Object)editorConfigDescribableElement);
        return editorConfigDescribableElement;
    }

    @NotNull
    public EditorConfigOptionValueIdentifier createValueIdentifier(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigOptionValueIdentifier editorConfigOptionValueIdentifier = this.createOption("foo=" + source).getOptionValueIdentifier();
        Intrinsics.checkNotNull((Object)editorConfigOptionValueIdentifier);
        return editorConfigOptionValueIdentifier;
    }

    @NotNull
    public EditorConfigOption createOption(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        List list = this.createSection("[*]" + source).getOptionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptionList(...)");
        return (EditorConfigOption)CollectionsKt.single((List)list);
    }

    @NotNull
    public EditorConfigDescribableElement createKey(@NotNull CharSequence source) {
        EditorConfigDescribableElement editorConfigDescribableElement;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigOption option = this.createOption(source + "=bar");
        EditorConfigFlatOptionKey editorConfigFlatOptionKey = option.getFlatOptionKey();
        if (editorConfigFlatOptionKey != null) {
            editorConfigDescribableElement = (EditorConfigDescribableElement)editorConfigFlatOptionKey;
        } else {
            EditorConfigQualifiedOptionKey editorConfigQualifiedOptionKey = option.getQualifiedOptionKey();
            if (editorConfigQualifiedOptionKey != null) {
                editorConfigDescribableElement = (EditorConfigDescribableElement)editorConfigQualifiedOptionKey;
            } else {
                throw new IllegalStateException();
            }
        }
        return editorConfigDescribableElement;
    }

    @NotNull
    public EditorConfigQualifiedKeyPart createKeyPart(@NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EditorConfigQualifiedOptionKey editorConfigQualifiedOptionKey = this.createOption("hello." + source + "=value").getQualifiedOptionKey();
        Intrinsics.checkNotNull((Object)editorConfigQualifiedOptionKey);
        Object e = editorConfigQualifiedOptionKey.getQualifiedKeyPartList().get(1);
        Intrinsics.checkNotNull(e);
        return (EditorConfigQualifiedKeyPart)e;
    }
}

