/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connectivity.ex.dataSource.artifacts;

import com.intellij.database.connectivity.ex.dataSource.artifacts.ArtifactRepositoriesProvider;
import com.intellij.database.connectivity.ex.dataSource.artifacts.DatabaseArtifactLoaderImpl;
import com.intellij.database.connectivity.ex.dataSource.artifacts.MavenItemResolverKt;
import com.intellij.database.connectivity.ex.dataSource.artifacts.RemoteRepositoryDescription;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DatabaseDriverManagerUtil;
import com.intellij.database.util.Version;
import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.eel.EelDownloadableFileService;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ProcessKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.proxy.CommonProxy;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 N2\u00020\u0001:\u0001NB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010(\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010.\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010/\u001a\u0004\u0018\u00010\u00132\u0006\u0010.\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u00100\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u00101\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J:\u00102\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0005\u0012\u0004\u0012\u00020\u001b032\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J6\u00104\u001a\b\u0012\u0004\u0012\u00020\u0013052\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\u0006072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u0013092\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010:\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J:\u0010;\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0005\u0012\u0004\u0012\u00020\u001b032\u0006\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010B\u001a\u0004\u0018\u00010CH\u0016J \u0010H\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010I\u001a\u00020J2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010K\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010L\u001a\u00020\u001b*\u00020\u00112\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001307H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u00060\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020E078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006O"}, d2={"Lcom/intellij/database/connectivity/ex/dataSource/artifacts/DatabaseArtifactLoaderImpl;", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactLoader;", "<init>", "()V", "myDefaultRepositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "myRepositories", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Repository;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "downloadArtifact", "", "version", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$ArtifactVersion;", "context", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;", "artifactDir", "Ljava/nio/file/Path;", "artifact", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Artifact;", "Lcom/intellij/database/util/Version;", "findArtifactDir", "getArtifactDirByArtifact", "", "isValid", "", "list", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList;", "name", "hasMissingLocalFiles", "isAllDownloaded", "exists", "dir", "ver", "item", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item;", "downloadMavenItems", "download", "refillCache", "unpackZippedItems", "getNativeLibraries", "arch", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$Arch;", "getNativeLibrary", "archive", "unpackZipIfNeeded", "getUnpackedPath", "getArtifactDir", "resolveClassPath", "Lkotlin/Pair;", "resolveMavenItem", "", "getRepositories", "", "getClasspathElements", "", "hasClasspathElementsFast", "getClassPathState", "remoteArtifactListUrl", "getRemoteArtifactListUrl", "()Ljava/lang/String;", "localArtifactListPath", "getLocalArtifactListPath", "()Ljava/nio/file/Path;", "loadArtifactList", "", "testArtifactLists", "Ljava/net/URL;", "getTestArtifactLists", "()Ljava/util/List;", "hasClassPathFast", "asDownloadable", "Lcom/intellij/util/download/DownloadableFileSetDescription;", "filterItemsForDownloading", "isApplicable", "paths", "Companion", "intellij.database.connectivity.ex"})
@SourceDebugExtension(value={"SMAP\nDatabaseArtifactLoaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseArtifactLoaderImpl.kt\ncom/intellij/database/connectivity/ex/dataSource/artifacts/DatabaseArtifactLoaderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,467:1\n1915#2,2:468\n777#2:471\n873#2,2:472\n1807#2,3:474\n777#2:477\n873#2,2:478\n2792#2,3:480\n1786#2,3:483\n1915#2,2:486\n777#2:488\n873#2,2:489\n1915#2,2:491\n777#2:493\n873#2,2:494\n777#2:496\n873#2,2:497\n1915#2:499\n1586#2:500\n1661#2,3:501\n1915#2,2:504\n1916#2:506\n777#2:507\n873#2,2:508\n1586#2:510\n1661#2,3:511\n1915#2,2:514\n1391#2:516\n1480#2,5:517\n1807#2,3:522\n1586#2:525\n1661#2,3:526\n1586#2:529\n1661#2,3:530\n1642#2,10:533\n1915#2:543\n1916#2:545\n1652#2:546\n1786#2,3:547\n1#3:470\n1#3:544\n*S KotlinDebug\n*F\n+ 1 DatabaseArtifactLoaderImpl.kt\ncom/intellij/database/connectivity/ex/dataSource/artifacts/DatabaseArtifactLoaderImpl\n*L\n91#1:468,2\n125#1:471\n125#1:472,2\n125#1:474,3\n132#1:477\n132#1:478,2\n132#1:480,3\n141#1:483,3\n146#1:486,2\n158#1:488\n158#1:489,2\n158#1:491,2\n168#1:493\n168#1:494,2\n169#1:496\n169#1:497,2\n169#1:499\n183#1:500\n183#1:501,3\n183#1:504,2\n169#1:506\n233#1:507\n233#1:508,2\n279#1:510\n279#1:511,3\n279#1:514,2\n290#1:516\n290#1:517,5\n294#1:522,3\n304#1:525\n304#1:526,3\n307#1:529\n307#1:530,3\n357#1:533,10\n357#1:543\n357#1:545\n357#1:546\n465#1:547,3\n357#1:544\n*E\n"})
public final class DatabaseArtifactLoaderImpl
extends DatabaseArtifactLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<RemoteRepository> myDefaultRepositories;
    @NotNull
    private final ConcurrentMap<DatabaseArtifactList.Repository, RemoteRepository> myRepositories;
    @NotNull
    public static final String DRIVER_DIR = "jdbc-drivers";
    @NotNull
    private static final String ARTIFACTS_XML = "jdbc-drivers.xml";
    @NotNull
    private static final Logger LOG;

    public DatabaseArtifactLoaderImpl() {
        CommonProxy.isInstalledAssertion();
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> DatabaseArtifactLoaderImpl.myRepositories$lambda$1(DatabaseArtifactLoaderImpl::myRepositories$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.myRepositories = concurrentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadArtifact(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DatabaseArtifactList.Artifact artifact = version.artifact;
        Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
        Version version2 = version.version;
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
        Path target = this.artifactDir(artifact, version2, context);
        try {
            DownloadableFileSetDescription description = this.asDownloadable(version, context);
            if (!description.getFiles().isEmpty()) {
                try {
                    List cfr_ignored_0 = (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<kotlin.Pair<? extends Path, ? extends DownloadableFileDescription>>>, Object>(description, target, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ DownloadableFileSetDescription $description;
                        final /* synthetic */ Path $target;
                        {
                            this.$description = $description;
                            this.$target = $target;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void $this$runBlockingCancellable;
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlockingCancellable);
                                    this.label = 1;
                                    Object object2 = ProcessKt.computeDetached((CoroutineContext)$this$runBlockingCancellable.getCoroutineContext().minusKey((CoroutineContext.Key)Job.Key).plus((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<kotlin.Pair<? extends Path, ? extends DownloadableFileDescription>>>, Object>(this.$description, this.$target, null){
                                        int label;
                                        final /* synthetic */ DownloadableFileSetDescription $description;
                                        final /* synthetic */ Path $target;
                                        {
                                            this.$description = $description;
                                            this.$target = $target;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.label = 1;
                                                    Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> downloadArtifact.1.invokeSuspend$lambda$0(this.$description, this.$target, arg_0), (Continuation)((Continuation)this));
                                                    if (object2 != object) return object2;
                                                    return object;
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object2 = $result;
                                                    return object2;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super List<kotlin.Pair<Path, DownloadableFileDescription>>> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }

                                        private static final List invokeSuspend$lambda$0(DownloadableFileSetDescription $description, Path $target, ProgressIndicator it) {
                                            return EelDownloadableFileService.Companion.getInstance().createDownloader($description).download($target);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super List<kotlin.Pair<Path, DownloadableFileDescription>>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
                catch (Throwable e) {
                    NioFiles.deleteRecursively((Path)target);
                    throw e;
                }
            }
            try {
                this.downloadMavenItems(version, target, context);
            }
            catch (Exception e) {
                throw new IOException("Download from maven failed", e);
            }
            this.unpackZippedItems(version, context);
        }
        finally {
            List list = version.items;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"items");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.refillCache(version, target, it, context);
            }
        }
    }

    private final Path artifactDir(DatabaseArtifactList.Artifact artifact, Version version, DatabaseArtifactContext context) {
        return this.findArtifactDir(artifact, version, context);
    }

    @NotNull
    public Path findArtifactDir(@NotNull DatabaseArtifactList.Artifact artifact, @NotNull Version version, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = artifact.id;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
        Path expected = this.getArtifactDirByArtifact(string, version, context);
        if (Files.exists(expected, new LinkOption[0])) {
            return expected;
        }
        String string2 = artifact.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        Path old = this.getArtifactDirByArtifact(string2, version, context);
        if (Files.exists(old, new LinkOption[0])) {
            return old;
        }
        if (Intrinsics.areEqual((Object)artifact.id, (Object)"MySQL ConnectorJ") && Files.exists(old = this.getArtifactDirByArtifact("MySQL Connector/J 8", version, context), new LinkOption[0])) {
            return old;
        }
        return expected;
    }

    @NotNull
    public final Path getArtifactDirByArtifact(@NotNull String artifact, @NotNull Version version, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = context.getDownloadPath().resolve(artifact).resolve(version.toString());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public boolean isValid(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isAllDownloaded(version, context);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isValid(@NotNull DatabaseArtifactList list, @NotNull String name, @Nullable Version version, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        artifact = list.getArtifact(name);
        if (artifact == null) ** GOTO lbl-1000
        v0 = version;
        if (v0 == null) lbl-1000:
        // 2 sources

        {
            v1 = null;
        } else {
            v1 = artifact.get(v0);
        }
        v2 = desc = v1;
        if (v2 != null) {
            it = v2;
            $i$a$-let-DatabaseArtifactLoaderImpl$isValid$1 = false;
            v3 = this.isValid(it, context);
        } else {
            v3 = version != null && Files.exists(this.getArtifactDir(list, name, version, context), new LinkOption[0]) != false;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasMissingLocalFiles(@NotNull DatabaseArtifactList.ArtifactVersion artifact, @NotNull DatabaseArtifactContext context) {
        boolean bl;
        void $this$any$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DatabaseArtifactList.Artifact artifact2 = artifact.artifact;
        Intrinsics.checkNotNullExpressionValue((Object)artifact2, (String)"artifact");
        Version version = artifact.version;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
        Path dir = this.artifactDir(artifact2, version, context);
        List list = artifact.items;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"items");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!context.isApplicable(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object = $this$any$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv;
            boolean bl3 = false;
            if (it.type != DatabaseArtifactList.Item.Type.LICENSE && it.isLocal()) {
                Intrinsics.checkNotNull((Object)it);
                if (Files.notExists(DatabaseArtifactLoaderImpl.Companion.getItemFile(dir, it), new LinkOption[0])) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAllDownloaded(DatabaseArtifactList.ArtifactVersion artifact, DatabaseArtifactContext context) {
        boolean bl;
        void $this$none$iv;
        void $this$filterTo$iv$iv;
        DatabaseArtifactList.Artifact artifact2 = artifact.artifact;
        Intrinsics.checkNotNullExpressionValue((Object)artifact2, (String)"artifact");
        Version version = artifact.version;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
        Path dir = this.artifactDir(artifact2, version, context);
        List list = artifact.items;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"items");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!context.isApplicable(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        object = $this$none$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv;
            boolean bl3 = false;
            if (it.type != DatabaseArtifactList.Item.Type.LICENSE) {
                Intrinsics.checkNotNull((Object)it);
                if (!this.exists(dir, artifact, it, context)) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private final boolean exists(Path dir, DatabaseArtifactList.ArtifactVersion ver, DatabaseArtifactList.Item item, DatabaseArtifactContext context) {
        boolean bl;
        block5: {
            if (item.type != DatabaseArtifactList.Item.Type.MAVEN) {
                return Files.exists(DatabaseArtifactLoaderImpl.Companion.getItemFile(dir, item), new LinkOption[0]);
            }
            kotlin.Pair<List<Path>, Boolean> state = this.getClassPathState(item, ver, dir, context);
            if (!((Boolean)state.getSecond()).booleanValue()) {
                return false;
            }
            Iterable $this$all$iv = (Iterable)state.getFirst();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    if (Files.exists(it, new LinkOption[0])) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void downloadMavenItems(DatabaseArtifactList.ArtifactVersion download, Path dir, DatabaseArtifactContext context) throws Exception {
        List list = download.items;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"items");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv;
            boolean bl = false;
            if (it.type != DatabaseArtifactList.Item.Type.MAVEN) continue;
            DatabaseArtifactList.Item.OS oS = it.os;
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"os");
            if (!context.isApplicable(oS)) continue;
            Intrinsics.checkNotNull((Object)it);
            this.resolveMavenItem(dir, it, true, context, download);
        }
    }

    private final void refillCache(DatabaseArtifactList.ArtifactVersion download, Path dir, DatabaseArtifactList.Item item, DatabaseArtifactContext context) {
        item.classpath = null;
        this.getClassPathState(item, download, dir, context);
    }

    /*
     * WARNING - void declaration
     */
    public void unpackZippedItems(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DatabaseArtifactList.Artifact artifact = version.artifact;
        Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
        Version version2 = version.version;
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
        Path dir = this.artifactDir(artifact, version2, context);
        List list = version.items;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"items");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv$iv;
            boolean bl = false;
            DatabaseArtifactList.Item.OS oS = it.os;
            Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"os");
            if (!context.isApplicable(oS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv;
            boolean bl = false;
            if (it.type != DatabaseArtifactList.Item.Type.NATIVE && it.type != DatabaseArtifactList.Item.Type.PACK) continue;
            Intrinsics.checkNotNull((Object)it);
            DatabaseArtifactLoaderImpl.Companion.unpackZipIfNeeded(DatabaseArtifactLoaderImpl.Companion.getItemFile(dir, it), version, context.getNativeLibsRoot());
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public List<Path> getNativeLibraries(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactList.Item.Arch arch, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        v0 = version.artifact;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"artifact");
        v1 = version.version;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"version");
        dir = this.artifactDir(v0, v1, context);
        paths = new ArrayList<E>();
        v2 = version.items;
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"items");
        $this$filter$iv = v2;
        $i$f$filter = false;
        var8_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (DatabaseArtifactList.Item)element$iv$iv;
            $i$a$-filter-DatabaseArtifactLoaderImpl$getNativeLibraries$1 = false;
            v3 = it.os;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"os");
            if (!(context.isApplicable(v3) != false && it.arch.matches(arch) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (DatabaseArtifactList.Item)element$iv$iv;
            $i$a$-filter-DatabaseArtifactLoaderImpl$getNativeLibraries$2 = false;
            if (it.archDependsOn != DatabaseArtifactList.Item.ArchDependsOn.SYSTEM) ** GOTO lbl-1000
            v4 = it.arch;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"arch");
            if (context.isApplicable(v4)) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            item = (DatabaseArtifactList.Item)element$iv;
            $i$a$-forEach-DatabaseArtifactLoaderImpl$getNativeLibraries$3 = false;
            if (item.type == DatabaseArtifactList.Item.Type.PACK) {
                nativeLibrariesPath = version.getProperty("native.libraries.path");
                if (nativeLibrariesPath == null) continue;
                v6 = dir.resolve(item.name);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"resolve(...)");
                v7 = this.getUnpackedPath(v6, version, context).resolve(nativeLibrariesPath);
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"resolve(...)");
                paths.add(v7);
            }
            if (item.type == DatabaseArtifactList.Item.Type.NATIVE) {
                archive = dir.resolve(item.name);
                Intrinsics.checkNotNull((Object)archive);
                archPath = this.getNativeLibrary(archive, version, arch, context);
                if (archPath != null) {
                    paths.add(archPath);
                }
            }
            if (item.type != DatabaseArtifactList.Item.Type.MAVEN) continue;
            v8 = item.url;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"url");
            if (!StringsKt.contains$default((CharSequence)v8, (CharSequence)":dll:", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNull((Object)item);
            $this$map$iv = (Iterable)this.getClassPathState(item, version, dir, context).getFirst();
            $i$f$map = false;
            $i$a$-filter-DatabaseArtifactLoaderImpl$getNativeLibraries$2 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var19_26 = (Path)item$iv$iv;
                var20_27 = destination$iv$iv;
                $i$a$-map-DatabaseArtifactLoaderImpl$getNativeLibraries$3$1 = false;
                var20_27.add(it.getParent());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (Path)element$iv;
                $i$a$-forEach-DatabaseArtifactLoaderImpl$getNativeLibraries$3$2 = false;
                Intrinsics.checkNotNull((Object)it);
                paths.add(it);
            }
        }
        return paths;
    }

    @Nullable
    public Path getNativeLibrary(@NotNull Path archive, @Nullable DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactList.Item.Arch arch, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = DatabaseArtifactLoaderImpl.Companion.unpackZipIfNeeded(archive, version, context.getNativeLibsRoot());
        if (path == null) {
            return null;
        }
        return DatabaseArtifactLoaderImpl.Companion.chooseArchPath(path, arch);
    }

    @Nullable
    public Path unpackZipIfNeeded(@NotNull Path archive, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DatabaseArtifactLoaderImpl.Companion.unpackZipIfNeeded(archive, null, context.getNativeLibsRoot());
    }

    @NotNull
    public Path getUnpackedPath(@NotNull Path archive, @Nullable DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DatabaseArtifactLoaderImpl.Companion.getUnpackPath(archive, version, context.getNativeLibsRoot());
    }

    @NotNull
    public Path getArtifactDir(@NotNull DatabaseArtifactList list, @NotNull String name, @NotNull Version version, @NotNull DatabaseArtifactContext context) {
        DatabaseArtifactList.Artifact artifact;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path asIs = this.getArtifactDirByArtifact(name, version, context);
        if (Files.exists(asIs, new LinkOption[0])) {
            return asIs;
        }
        DatabaseArtifactList.Artifact artifact2 = artifact = list.getArtifact(name);
        return artifact2 == null ? asIs : this.artifactDir(artifact2, version, context);
    }

    /*
     * WARNING - void declaration
     */
    private final kotlin.Pair<List<Path>, Boolean> resolveClassPath(DatabaseArtifactList.Item item, DatabaseArtifactList.ArtifactVersion version, Path dir, DatabaseArtifactContext context) {
        block11: {
            block12: {
                Iterable<Path> iterable;
                block14: {
                    block13: {
                        void $this$filterTo$iv$iv;
                        String additionalPath;
                        DatabaseArtifactList.Item.OS oS = item.os;
                        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"os");
                        if (!context.isApplicable(oS)) break block11;
                        if (item.type == DatabaseArtifactList.Item.Type.JAR) {
                            Object[] objectArray = new Path[]{DatabaseArtifactLoaderImpl.Companion.getItemFile(dir, item)};
                            return TuplesKt.to((Object)CollectionsKt.mutableListOf((Object[])objectArray), (Object)true);
                        }
                        if (item.type != DatabaseArtifactList.Item.Type.PACK) break block12;
                        Path root = DatabaseArtifactLoaderImpl.Companion.unpackZipIfNeeded(DatabaseArtifactLoaderImpl.Companion.getItemFile(dir, item), version, context.getNativeLibsRoot());
                        if (root != null && (additionalPath = version.getProperty("jar.libraries.path")) != null) {
                            root = root.resolve(additionalPath);
                        }
                        if ((iterable = root) == null) break block13;
                        Path it = iterable;
                        boolean bl = false;
                        List<Path> list = Files.list(it).toList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
                        Iterable $this$filter$iv = list;
                        boolean $i$f$filter = false;
                        Iterable iterable2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Path file = (Path)element$iv$iv;
                            boolean bl2 = false;
                            Path path = file.getFileName();
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFileName(...)");
                            if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)path), (Object)"jar")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                        iterable = list2;
                        if (list2 != null) break block14;
                    }
                    iterable = new ArrayList();
                }
                Iterable<Path> files = iterable;
                return TuplesKt.to((Object)files, (Object)true);
            }
            if (item.type == DatabaseArtifactList.Item.Type.MAVEN) {
                try {
                    return TuplesKt.to((Object)CollectionsKt.toMutableList(this.resolveMavenItem(dir, item, false, context, version)), (Object)true);
                }
                catch (ArtifactResolutionException artifactResolutionException) {
                    return TuplesKt.to((Object)new ArrayList(), (Object)false);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    return TuplesKt.to((Object)new ArrayList(), (Object)false);
                }
            }
        }
        return TuplesKt.to((Object)new ArrayList(), (Object)true);
    }

    private final Collection<Path> resolveMavenItem(Path dir, DatabaseArtifactList.Item item, boolean download, DatabaseArtifactContext context, DatabaseArtifactList.ArtifactVersion version) throws Exception {
        DatabaseArtifactList.Artifact artifact = version.artifact;
        Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
        Version version2 = version.version;
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
        Path path = this.artifactDir(artifact, version2, DatabaseArtifactContext.Companion.getDefaultContext());
        DatabaseArtifactList databaseArtifactList = item.list;
        Intrinsics.checkNotNullExpressionValue((Object)databaseArtifactList, (String)"list");
        return MavenItemResolverKt.resolveMavenItem(dir, path, item, download, this.getRepositories(databaseArtifactList, context), context.useEel());
    }

    /*
     * WARNING - void declaration
     */
    private final List<RemoteRepository> getRepositories(DatabaseArtifactList list, DatabaseArtifactContext context) {
        if (this.myDefaultRepositories == null) {
            this.myDefaultRepositories = ArtifactRepositoryManager.createDefaultRemoteRepositories();
        }
        List<RemoteRepository> list2 = this.myDefaultRepositories;
        Intrinsics.checkNotNull(list2);
        ArrayList<Object> repositories = new ArrayList<Object>((Collection)list2);
        for (ArtifactRepositoriesProvider provider : ArtifactRepositoriesProvider.Companion.getAllProviders()) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = provider.getRepositories(context);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RemoteRepositoryDescription remoteRepositoryDescription = (RemoteRepositoryDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ArtifactRepositoryManager.createRemoteRepository((String)it.getId(), (String)it.getUrl()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RemoteRepository it = (RemoteRepository)element$iv;
                boolean bl = false;
                repositories.add(it);
            }
        }
        for (DatabaseArtifactList.Repository repository : list.getRepositories()) {
            Object v = this.myRepositories.get(repository);
            Intrinsics.checkNotNull(v);
            repositories.add(v);
        }
        return new ArrayList(repositories);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Path> getClasspathElements(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list = version.items;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"items");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            DatabaseArtifactList.Artifact artifact = version.artifact;
            Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
            Version version2 = version.version;
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
            Iterable list$iv$iv = (Iterable)this.getClassPathState(it, version, this.artifactDir(artifact, version2, context), context).getFirst();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public boolean hasClasspathElementsFast(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            List list = version.items;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"items");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    DatabaseArtifactList.Artifact artifact = version.artifact;
                    Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
                    Version version2 = version.version;
                    Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
                    if (!this.hasClassPathFast(it, this.artifactDir(artifact, version2, context), context)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final kotlin.Pair<List<Path>, Boolean> getClassPathState(DatabaseArtifactList.Item item, DatabaseArtifactList.ArtifactVersion ver, Path dir, DatabaseArtifactContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair cp = item.classpath;
        if (cp != null) {
            Object object = cp.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            if (this.isApplicable(context, (List)object)) {
                void $this$mapTo$iv$iv2;
                Object object2 = cp.first;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
                Iterable $this$map$iv2 = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it);
                }
                return TuplesKt.to((Object)CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)), (Object)cp.second);
            }
        }
        kotlin.Pair<List<Path>, Boolean> newClasspath = this.resolveClassPath(item, ver, dir, context);
        Iterable $i$f$map = (Iterable)newClasspath.getFirst();
        DatabaseArtifactList.Item item2 = item;
        boolean $i$f$map2 = false;
        void destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path bl = (Path)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it);
        }
        Object object = newClasspath.getSecond();
        List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        item2.classpath = new Pair((Object)list, object);
        return TuplesKt.to((Object)newClasspath.getFirst(), (Object)newClasspath.getSecond());
    }

    @Nullable
    public String getRemoteArtifactListUrl() {
        String serviceUrl;
        String string = serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        return (string != null ? ((CharSequence)string).length() > 0 : false) ? serviceUrl + "/jdbc-drivers/jdbc-drivers.xml" : null;
    }

    @NotNull
    public Path getLocalArtifactListPath() {
        Path path = Path.of(DatabaseDriverManagerUtil.getDownloadPath(), new String[0]).resolve(ARTIFACTS_XML);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Nullable
    public byte[] loadArtifactList() throws IOException {
        byte[] byArray;
        String string = this.getRemoteArtifactListUrl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            byArray = HttpRequests.request((String)it).readBytes(ProgressIndicatorProvider.getGlobalProgressIndicator());
        } else {
            byArray = null;
        }
        return byArray;
    }

    @NotNull
    public List<URL> getTestArtifactLists() {
        Object object;
        block8: {
            block7: {
                Object object2;
                Object $this$_get_testArtifactLists__u24lambda_u240_u240;
                object = DatabaseDriverManagerUtil.existentTestPath((String)"test-database-artifacts.xml");
                if (object == null) break block7;
                File file = object;
                boolean bl = false;
                DatabaseArtifactLoaderImpl databaseArtifactLoaderImpl = this;
                try {
                    $this$_get_testArtifactLists__u24lambda_u240_u240 = databaseArtifactLoaderImpl;
                    boolean bl2 = false;
                    $this$_get_testArtifactLists__u24lambda_u240_u240 = Result.constructor-impl((Object)CollectionsKt.listOf((Object)file.toURI().toURL()));
                }
                catch (Throwable bl2) {
                    $this$_get_testArtifactLists__u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                databaseArtifactLoaderImpl = $this$_get_testArtifactLists__u24lambda_u240_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)databaseArtifactLoaderImpl));
                if (throwable == null) {
                    object2 = databaseArtifactLoaderImpl;
                } else {
                    Throwable it = throwable;
                    boolean bl3 = false;
                    LOG.warn(it);
                    object2 = CollectionsKt.emptyList();
                }
                List list = (List)object2;
                object = list;
                if (list != null) break block8;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasClassPathFast(DatabaseArtifactList.Item item, Path dir, DatabaseArtifactContext context) {
        Pair cp;
        Pair pair = cp = item.classpath;
        if (pair != null) {
            if (pair.first == null) return false;
            Object object = cp.first;
            Intrinsics.checkNotNull((Object)object);
            if (((List)object).isEmpty()) return false;
            return true;
        }
        DatabaseArtifactList.Item.OS oS = item.os;
        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"os");
        if (!context.isApplicable(oS)) {
            return false;
        }
        DatabaseArtifactList.Item.Type type = item.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                boolean bl = Files.exists(DatabaseArtifactLoaderImpl.Companion.getItemFile(dir, item), new LinkOption[0]);
                return bl;
            }
            case 3: {
                boolean bl;
                if (Files.notExists(dir, new LinkOption[0])) {
                    return false;
                }
                AutoCloseable autoCloseable = Files.walk(dir, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    Stream str = (Stream)autoCloseable;
                    boolean bl2 = false;
                    boolean bl3 = !str.allMatch(arg_0 -> DatabaseArtifactLoaderImpl.hasClassPathFast$lambda$0$1(DatabaseArtifactLoaderImpl::hasClassPathFast$lambda$0$0, arg_0));
                    bl = bl3;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            default: {
                return false;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DownloadableFileSetDescription asDownloadable(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = version.artifact.name;
        String string2 = version.version.toString();
        List list2 = version.items;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"items");
        Iterable iterable = list2;
        String string3 = string2;
        String string4 = string;
        boolean $i$f$mapNotNull = false;
        void var5_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DownloadableFileDescription it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DatabaseArtifactList.Item it = (DatabaseArtifactList.Item)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if ((this.filterItemsForDownloading(it, context) ? DatabaseArtifactLoaderImpl.Companion.asDownloadable(it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        String string5 = string3;
        String string6 = string4;
        return (DownloadableFileSetDescription)new DownloadableFileSetDescriptionImpl(string6, string5, list3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean filterItemsForDownloading(DatabaseArtifactList.Item item, DatabaseArtifactContext context) {
        if (item.type == DatabaseArtifactList.Item.Type.MAVEN) return false;
        if (item.archDependsOn == DatabaseArtifactList.Item.ArchDependsOn.SYSTEM) {
            DatabaseArtifactList.Item.Arch arch = item.arch;
            Intrinsics.checkNotNullExpressionValue((Object)arch, (String)"arch");
            if (!context.isApplicable(arch)) {
                return false;
            }
        }
        DatabaseArtifactList.Item.OS oS = item.os;
        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"os");
        boolean bl = context.isApplicable(oS);
        return bl;
    }

    private final boolean isApplicable(DatabaseArtifactContext $this$isApplicable, List<? extends Path> paths) {
        boolean bl;
        block3: {
            EelDescriptor root = EelProviderUtil.getEelDescriptor((Path)$this$isApplicable.getDownloadPath());
            Iterable $this$all$iv = paths;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)it), (Object)root)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final RemoteRepository myRepositories$lambda$0(DatabaseArtifactList.Repository r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return ArtifactRepositoryManager.createRemoteRepository((String)r.id, (String)r.url);
    }

    private static final RemoteRepository myRepositories$lambda$1(Function1 $tmp0, Object p0) {
        return (RemoteRepository)$tmp0.invoke(p0);
    }

    private static final boolean hasClassPathFast$lambda$0$0(Path it) {
        return !Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean hasClassPathFast$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(DatabaseArtifactLoaderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J$\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\"\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/connectivity/ex/dataSource/artifacts/DatabaseArtifactLoaderImpl$Companion;", "", "<init>", "()V", "DRIVER_DIR", "", "ARTIFACTS_XML", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getItemFile", "Ljava/nio/file/Path;", "dir", "item", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item;", "chooseArchPath", "path", "arch", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$Arch;", "extractLibrary", "", "archive", "out", "name", "unpackZipIfNeeded", "version", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$ArtifactVersion;", "nativeLibsRoot", "isExtracted", "", "getUnpackPath", "asDownloadable", "Lcom/intellij/util/download/DownloadableFileDescription;", "intellij.database.connectivity.ex"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getItemFile(Path dir, DatabaseArtifactList.Item item) {
            Path path;
            if (item.isLocal()) {
                String string = item.url;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
                Path path2 = Path.of(StringsKt.removePrefix((String)string, (CharSequence)"file://"), new String[0]);
                Intrinsics.checkNotNull((Object)path2);
                path = path2;
            } else {
                Path path3 = dir.resolve(item.name);
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            }
            return path;
        }

        private final Path chooseArchPath(Path path, DatabaseArtifactList.Item.Arch arch) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[arch.ordinal()]) {
                case 1: {
                    return path;
                }
                case 2: {
                    string = "x86";
                    break;
                }
                case 3: {
                    string = "x64";
                    break;
                }
                case 4: {
                    string = "arm64";
                    break;
                }
                case 5: {
                    string = "arm32";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String archDir = string;
            Path archFolder = path.resolve(archDir);
            if (Files.notExists(archFolder, new LinkOption[0])) {
                return path;
            }
            Path sso = archFolder.resolve("SSO");
            return Files.exists(sso, new LinkOption[0]) ? sso : archFolder;
        }

        private final void extractLibrary(Path archive, Path out, String name) {
            if (this.isExtracted(out)) {
                return;
            }
            try {
                EelApi eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Path)out));
                if (eel.getDescriptor() instanceof LocalEelDescriptor) {
                    if (FileUtil.isJarOrZip((File)archive.toFile())) {
                        ZipUtil.extract((Path)archive, (Path)out, null, (boolean)true);
                    } else if (FileUtil.extensionEquals((String)((Object)archive).toString(), (String)"gz")) {
                        new Decompressor.Tar(archive).overwrite(true).extract(out);
                    } else {
                        throw new IllegalArgumentException("Unsupported archive type: " + archive.toAbsolutePath());
                    }
                    return;
                }
                CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(eel, archive, out, null){
                    int label;
                    final /* synthetic */ EelApi $eel;
                    final /* synthetic */ Path $archive;
                    final /* synthetic */ Path $out;
                    {
                        this.$eel = $eel;
                        this.$archive = $archive;
                        this.$out = $out;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$eel.getArchive().extract(EelNioBridgeServiceKt.asEelPath((Path)this.$archive), EelNioBridgeServiceKt.asEelPath((Path)this.$out), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            catch (Exception e) {
                if (AsyncUtil.isCancellation((Throwable)e)) {
                    throw e;
                }
                LOG.warn("Failed to extract " + name, (Throwable)e);
                try {
                    NioFiles.deleteRecursively((Path)out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private final Path unpackZipIfNeeded(Path archive, DatabaseArtifactList.ArtifactVersion version, Path nativeLibsRoot) {
            if (Files.notExists(archive, new LinkOption[0])) {
                return null;
            }
            Path out = this.getUnpackPath(archive, version, nativeLibsRoot);
            this.extractLibrary(archive, out, PathsKt.getName((Path)archive));
            return out;
        }

        private final boolean isExtracted(Path out) {
            try {
                if (Files.newDirectoryStream(out).iterator().hasNext()) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private final Path getUnpackPath(Path archive, DatabaseArtifactList.ArtifactVersion version, Path nativeLibsRoot) {
            String name = StringsKt.substringBeforeLast$default((String)((Object)archive.getFileName()).toString(), (String)".", null, (int)2, null);
            if (version != null) {
                Path path = nativeLibsRoot.resolve(version.artifact.id).resolve(version.version.toString()).resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path path2 = path;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
                return path3;
            }
            MessageDigest digest = DigestUtil.sha256();
            try {
                DigestUtil.updateContentHash$default((MessageDigest)digest, (Path)archive, null, (int)4, null);
            }
            catch (Throwable th) {
                LOG.warn(th);
            }
            Path path = nativeLibsRoot.resolve("user-provided").resolve(name + "-" + StringUtil.toHexString((byte[])digest.digest()));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path4 = path;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path5 = Files.createDirectories(path4, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"createDirectories(...)");
            return path5;
        }

        private final DownloadableFileDescription asDownloadable(DatabaseArtifactList.Item $this$asDownloadable) {
            EelDownloadableFileService eelDownloadableFileService = EelDownloadableFileService.Companion.getInstance();
            String string = $this$asDownloadable.url;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
            String string2 = $this$asDownloadable.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            return eelDownloadableFileService.createFileDescription(string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DatabaseArtifactList.Item.Arch.values().length];
                try {
                    nArray[DatabaseArtifactList.Item.Arch.ANY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DatabaseArtifactList.Item.Arch.X86.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DatabaseArtifactList.Item.Arch.X86_64.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DatabaseArtifactList.Item.Arch.ARM64.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DatabaseArtifactList.Item.Arch.ARM32.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseArtifactList.Item.Type.values().length];
            try {
                nArray[DatabaseArtifactList.Item.Type.JAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.Type.PACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.Type.MAVEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

