/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.action.generate;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.TestDialogBuilder;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.actions.generate.LiveTemplateGenerateActionKt;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.model.action.generate.GenerateSpringEndpointAction;
import com.intellij.spring.mvc.model.action.generate.GenerateSpringEndpointActionKt;
import com.intellij.spring.mvc.model.action.generate.NonBlockingPopupBuilderImpl;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0019\u0010\u0013\u001a\u00130\u0014\u00a2\u0006\u000e\b\u0015\u0012\n\b\u0016\u0012\u0006\b\n0\u00178\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/mvc/model/action/generate/GenerateSpringEndpointAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "buildDialog", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "createDialogBuilder", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getErrorTitle", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nGenerateSpringEndpointAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateSpringEndpointAction.kt\ncom/intellij/spring/mvc/model/action/generate/GenerateSpringEndpointAction\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,277:1\n18#2:278\n*S KotlinDebug\n*F\n+ 1 GenerateSpringEndpointAction.kt\ncom/intellij/spring/mvc/model/action/generate/GenerateSpringEndpointAction\n*L\n60#1:278\n*E\n"})
public final class GenerateSpringEndpointAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        UElement uElement;
        block11: {
            block10: {
                void $this$getParentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(false);
                e.getPresentation().setIcon(SpringApiIcons.RequestMapping);
                Project project = (Project)e.getData(CommonDataKeys.PROJECT);
                if (project == null) {
                    return;
                }
                Project project2 = project;
                if (DumbService.Companion.isDumb(project2)) {
                    return;
                }
                PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
                if (psiFile == null) {
                    return;
                }
                PsiFile psiFile2 = psiFile;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
                if (module == null) {
                    return;
                }
                Module module2 = module;
                if (!SpringLibraryUtil.hasSpringLibrary((Module)module2)) {
                    return;
                }
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                if (editor == null) {
                    return;
                }
                Editor editor2 = editor;
                PsiElement psiElement = psiFile2.findElementAt(editor2.getCaretModel().getOffset());
                if (psiElement == null) {
                    return;
                }
                PsiElement psiElement2 = psiElement;
                uElement = UastContextKt.getFirstUElement$default((PsiElement)psiElement2, (boolean)false, (int)2, null);
                if (uElement == null) break block10;
                UElement uElement2 = uElement;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                uElement = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UClass.class, (boolean)strict$iv);
                if (uElement != null && (uElement = uElement.getJavaPsi()) != null) break block11;
            }
            return;
        }
        UElement psiClass = uElement;
        e.getPresentation().setEnabledAndVisible(SpringControllerUtils.isController((PsiClass)psiClass));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        String string = psiFile2.getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = StringUtil.capitalize((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capitalize(...)");
        String languageId = string3;
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        CreateFileFromTemplateDialog.Builder builder = this.createDialogBuilder(project2, dataContext3);
        this.buildDialog(builder);
        builder.show(this.getErrorTitle(), null, (CreateFileFromTemplateDialog.FileCreator)new CreateFileFromTemplateDialog.FileCreator<PsiElement>(languageId, project2, psiFile2, editor2){
            final /* synthetic */ String $languageId;
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ Editor $editor;
            {
                this.$languageId = $languageId;
                this.$project = $project;
                this.$psiFile = $psiFile;
                this.$editor = $editor;
            }

            public PsiElement createFile(String path, String templateName) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
                TemplateImpl template = LiveTemplateGenerateActionKt.findTemplate((String)"Spring MVC", (String)templateName, (String)this.$languageId);
                if (template == null) {
                    GenerateSpringEndpointActionKt.access$getLOG$p().error("Template not found: " + templateName);
                    return null;
                }
                TemplateManager templateManager = TemplateManager.getInstance((Project)this.$project);
                ApplicationManager.getApplication().invokeLater(() -> actionPerformed.1.createFile$lambda$0(this.$project, this.$psiFile, this, path, templateName, templateManager, this.$editor, template));
                return null;
            }

            public String getActionName(String name, String templateName) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
                Object[] objectArray = new Object[]{name};
                String string = SpringMvcBundle.message("progress.creating.endpoint", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public boolean startInWriteAction() {
                return true;
            }

            private static final void createFile$lambda$0$0(TemplateManager $templateManager, Editor $editor, TemplateImpl $template, String $path) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PATH", (Object)$path), TuplesKt.to((Object)"RETURN_TYPE", (Object)"?")};
                $templateManager.startTemplate($editor, (Template)$template, true, MapsKt.mapOf((Pair[])pairArray), null);
            }

            private static final void createFile$lambda$0(Project $project, PsiFile $psiFile, actionPerformed.1 this$0, String $path, String $templateName, TemplateManager $templateManager, Editor $editor, TemplateImpl $template) {
                PsiFile[] psiFileArray = new PsiFile[]{$psiFile};
                WriteCommandAction.writeCommandAction((Project)$project, (PsiFile[])psiFileArray).withName(this$0.getActionName($path, $templateName)).run(() -> actionPerformed.1.createFile$lambda$0$0($templateManager, $editor, $template, $path));
            }
        }, arg_0 -> GenerateSpringEndpointAction.actionPerformed$lambda$1(GenerateSpringEndpointAction::actionPerformed$lambda$0, arg_0));
    }

    private final void buildDialog(CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle(SpringMvcBundle.message("action.Spring.Create.Endpoint.dialog.title", new Object[0]));
        builder.addKind(SpringMvcBundle.message("method.name.get", new Object[0]), SpringApiIcons.RequestMapping, "getm");
        builder.addKind(SpringMvcBundle.message("method.name.post", new Object[0]), SpringApiIcons.RequestMapping, "postm");
        builder.addKind(SpringMvcBundle.message("method.name.put", new Object[0]), SpringApiIcons.RequestMapping, "putm");
        builder.addKind(SpringMvcBundle.message("method.name.delete", new Object[0]), SpringApiIcons.RequestMapping, "deletem");
        builder.addKind(SpringMvcBundle.message("method.name.patch", new Object[0]), SpringApiIcons.RequestMapping, "patchm");
        builder.addKind(SpringMvcBundle.message("method.name.request", new Object[0]), SpringApiIcons.RequestMapping, "reqm");
        builder.setValidator((InputValidator)new InputValidatorEx(){

            public String getErrorText(String inputString) {
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                return null;
            }

            public boolean checkInput(String inputString) {
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                return true;
            }

            public boolean canClose(String inputString) {
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                return !StringsKt.isBlank((CharSequence)inputString) && this.getErrorText(inputString) == null;
            }
        });
    }

    private final CreateFileFromTemplateDialog.Builder createDialogBuilder(Project project, DataContext dataContext) {
        TestDialogBuilder.TestAnswers answers;
        if (ApplicationManager.getApplication().isUnitTestMode() && (answers = (TestDialogBuilder.TestAnswers)dataContext.getData(TestDialogBuilder.TestAnswers.KEY)) != null) {
            return (CreateFileFromTemplateDialog.Builder)new TestDialogBuilder(answers);
        }
        return new NonBlockingPopupBuilderImpl(project);
    }

    private final String getErrorTitle() {
        String string = CommonBundle.getErrorTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorTitle(...)");
        return string;
    }

    private static final Unit actionPerformed$lambda$0(PsiElement it) {
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

