/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.lang.injection.general.SimpleInjection;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.mvc.webClient.SpringWebTestClientBodyLanguageInjectorKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/mvc/webClient/SpringWebTestClientBodyLanguageInjector;", "Lcom/intellij/lang/injection/general/LanguageInjectionContributor;", "<init>", "()V", "getInjection", "Lcom/intellij/lang/injection/general/Injection;", "host", "Lcom/intellij/psi/PsiElement;", "isTargetMethod", "", "uCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringWebTestClientBodyLanguageInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringWebTestClientBodyLanguageInjector.kt\ncom/intellij/spring/mvc/webClient/SpringWebTestClientBodyLanguageInjector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class SpringWebTestClientBodyLanguageInjector
implements LanguageInjectionContributor {
    @Nullable
    public Injection getInjection(@NotNull PsiElement host) {
        Object v4;
        block14: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Project project = host.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (project2.isDefault()) {
                return null;
            }
            if (!JavaLibraryUtil.hasLibraryJar((Project)project2, (String)"org.springframework:spring-test")) {
                return null;
            }
            UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)host, UInjectionHost.class);
            if (uInjectionHost == null) {
                return null;
            }
            UInjectionHost uInjectionHost2 = uInjectionHost;
            UExpression roomExpression = uInjectionHost2.getStringRoomExpression();
            UCallExpression uCallExpression = UastUtils.getUCallExpression((UElement)roomExpression.getUastParent(), (int)1);
            if (!this.isTargetMethod(uCallExpression)) {
                return null;
            }
            UCallExpression uCallExpression2 = uCallExpression;
            UElement uElement = uCallExpression2 != null ? uCallExpression2.getUastParent() : null;
            UExpression uExpression = uElement instanceof UExpression ? (UExpression)uElement : null;
            if (uExpression == null) {
                return null;
            }
            UExpression chainExpression = uExpression;
            Iterable iterable = UastUtils.getQualifiedChain((UExpression)chainExpression);
            for (Object t : iterable) {
                UExpression it = (UExpression)t;
                boolean bl = false;
                if (!(it instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)it).getMethodName(), (Object)"contentType"))) continue;
                v4 = t;
                break block14;
            }
            v4 = null;
        }
        Object var9_13 = v4;
        UCallExpression uCallExpression = var9_13 instanceof UCallExpression ? (UCallExpression)var9_13 : null;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression contentTypeCall = uCallExpression;
        UExpression firstArg = (UExpression)CollectionsKt.firstOrNull((List)contentTypeCall.getValueArguments());
        if (firstArg instanceof UReferenceExpression) {
            String bodyType = ((UReferenceExpression)firstArg).getResolvedName();
            if (Intrinsics.areEqual((Object)bodyType, (Object)"APPLICATION_JSON")) {
                Language language = Language.findLanguageByID((String)"JSON");
                Intrinsics.checkNotNull((Object)language);
                return (Injection)new SimpleInjection(language, "", "", "java");
            }
            if (Intrinsics.areEqual((Object)bodyType, (Object)"APPLICATION_XML") || Intrinsics.areEqual((Object)bodyType, (Object)"TEXT_XML")) {
                return (Injection)new SimpleInjection((Language)XMLLanguage.INSTANCE, "", "", "java");
            }
        } else if (firstArg != null) {
            String contentType = UastUtils.evaluateString((UExpression)firstArg);
            if (Intrinsics.areEqual((Object)contentType, (Object)"application/json")) {
                Language language = Language.findLanguageByID((String)"JSON");
                Intrinsics.checkNotNull((Object)language);
                return (Injection)new SimpleInjection(language, "", "", "java");
            }
            if (Intrinsics.areEqual((Object)contentType, (Object)"text/xml") || Intrinsics.areEqual((Object)contentType, (Object)"application/xml")) {
                return (Injection)new SimpleInjection((Language)XMLLanguage.INSTANCE, "", "", "java");
            }
        }
        return null;
    }

    private final boolean isTargetMethod(UCallExpression uCallExpression) {
        if (uCallExpression == null) {
            return false;
        }
        if (!uCallExpression.isMethodNameOneOf((Collection)SpringWebTestClientBodyLanguageInjectorKt.access$getBODY_METHOD_NAMES$p())) {
            return false;
        }
        String methodName = uCallExpression.getMethodName();
        if (Intrinsics.areEqual((Object)methodName, (Object)"bodyValue")) {
            PsiMethod psiMethod = uCallExpression.resolve();
            return Intrinsics.areEqual((Object)(psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"org.springframework.test.web.reactive.server.WebTestClient.RequestBodySpec");
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"content")) {
            PsiMethod psiMethod = uCallExpression.resolve();
            return Intrinsics.areEqual((Object)(psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder");
        }
        return false;
    }
}

