/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.debugger.scheduled;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.microservices.jvm.debugger.scheduled.DockerScheduledDebuggerConfiguration;
import com.intellij.microservices.jvm.debugger.scheduled.LocalScheduledDebuggerConfiguration;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerConfiguration;
import com.intellij.microservices.jvm.debugger.scheduled.WslScheduledDebuggerConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.net.NetUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\b\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\b\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\b\u0010\u0013\u001a\u00020\u0011H\u0002\u001a\b\u0010\b\u001a\u00020\u0007H\u0002\u001a\b\u0010\u0014\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"scheduledPort", "Lcom/intellij/openapi/util/Key;", "", "getScheduledPort", "()Lcom/intellij/openapi/util/Key;", "abiVersion", "machineDependentPluginPath", "", "os", "configureScheduledDebuggerByTargetName", "Lcom/intellij/microservices/jvm/debugger/scheduled/ScheduledDebuggerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "architecture", "isMac", "", "isLinux", "isWindows", "agentName", "pluginDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "intellij.microservices.jvm"})
public final class ScheduledDebuggerConfigurationKt {
    @NotNull
    private static final Key<Integer> scheduledPort;
    public static final int abiVersion = 4;

    @NotNull
    public static final Key<Integer> getScheduledPort() {
        return scheduledPort;
    }

    private static final String machineDependentPluginPath(String os) {
        return ScheduledDebuggerConfigurationKt.pluginDir() + "/scheduled/4/" + os + "/" + ScheduledDebuggerConfigurationKt.architecture();
    }

    static /* synthetic */ String machineDependentPluginPath$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = ScheduledDebuggerConfigurationKt.os();
        }
        return ScheduledDebuggerConfigurationKt.machineDependentPluginPath(string);
    }

    @NotNull
    public static final ScheduledDebuggerConfiguration configureScheduledDebuggerByTargetName(@NotNull Project project, @NotNull TargetEnvironmentRequest request2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        int port = NetUtils.findAvailableSocketPort();
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = request2.getConfiguration();
        Object object2 = object = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.getTypeId() : null;
        ScheduledDebuggerConfiguration configuration = Intrinsics.areEqual((Object)object, (Object)"docker") ? (ScheduledDebuggerConfiguration)new DockerScheduledDebuggerConfiguration(project, port) : (Intrinsics.areEqual((Object)object, (Object)"wsl") ? (ScheduledDebuggerConfiguration)new WslScheduledDebuggerConfiguration(project, port) : (ScheduledDebuggerConfiguration)new LocalScheduledDebuggerConfiguration(project, port));
        Object it = object = configuration;
        boolean bl = false;
        ((ScheduledDebuggerConfiguration)it).prepareTargetRequest(request2);
        return object;
    }

    private static final String architecture() {
        String string = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    private static final boolean isMac() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringsKt.indexOf$default((CharSequence)string2, (String)"mac", (int)0, (boolean)false, (int)6, null) != -1;
    }

    private static final boolean isLinux() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringsKt.indexOf$default((CharSequence)string2, (String)"linux", (int)0, (boolean)false, (int)6, null) != -1;
    }

    private static final boolean isWindows() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringsKt.indexOf$default((CharSequence)string2, (String)"win", (int)0, (boolean)false, (int)6, null) != -1;
    }

    private static final String os() {
        String string;
        if (ScheduledDebuggerConfigurationKt.isMac()) {
            string = "mac";
        } else if (ScheduledDebuggerConfigurationKt.isLinux()) {
            string = "linux";
        } else if (ScheduledDebuggerConfigurationKt.isWindows()) {
            string = "win";
        } else {
            String string2 = "unsupported OS";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return string;
    }

    private static final String agentName() {
        return ScheduledDebuggerConfigurationKt.isMac() ? "libscheduled.dylib" : (ScheduledDebuggerConfigurationKt.isLinux() ? "libscheduled.so" : "scheduled.dll");
    }

    private static final Path pluginDir() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve("microservices-jvm");
    }

    public static final /* synthetic */ String access$agentName() {
        return ScheduledDebuggerConfigurationKt.agentName();
    }

    public static final /* synthetic */ String access$os() {
        return ScheduledDebuggerConfigurationKt.os();
    }

    public static final /* synthetic */ String access$architecture() {
        return ScheduledDebuggerConfigurationKt.architecture();
    }

    public static final /* synthetic */ String access$machineDependentPluginPath(String os) {
        return ScheduledDebuggerConfigurationKt.machineDependentPluginPath(os);
    }

    static {
        Key key = Key.create((String)"SCHEDULED_DEBUGGER_PORT");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        scheduledPort = key;
    }
}

