/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptHighlightingLexer;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JavaScriptHighlightDescriptor;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0003\u0014\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "dialectOptionsHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "<init>", "(Lcom/intellij/lang/javascript/DialectOptionHolder;)V", "getDialectOptionsHolder", "()Lcom/intellij/lang/javascript/DialectOptionHolder;", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "getTokenHighlights", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getMappedKey", "original", "getKeywords", "Lcom/intellij/psi/tree/TokenSet;", "JSXmlTokenHighlighter", "Companion", "Keys", "intellij.javascript.psi.impl"})
public class JSHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DialectOptionHolder dialectOptionsHolder;
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_KEYWORD = JavaScriptHighlightDescriptor.KEYWORD.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_STRING = JavaScriptHighlightDescriptor.STRING.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_NUMBER = JavaScriptHighlightDescriptor.NUMBER.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_REGEXP = JavaScriptHighlightDescriptor.REGEXP.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_LINE_COMMENT = JavaScriptHighlightDescriptor.LINE_COMMENT.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_BLOCK_COMMENT = JavaScriptHighlightDescriptor.BLOCK_COMMENT.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_DOC_COMMENT = JavaScriptHighlightDescriptor.DOC_COMMENT.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_OPERATION_SIGN = JavaScriptHighlightDescriptor.OPERATION_SIGN.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_PARENTHS = JavaScriptHighlightDescriptor.PARENTHESES.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_BRACKETS = JavaScriptHighlightDescriptor.BRACKETS.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_BRACES = JavaScriptHighlightDescriptor.BRACES.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_COMMA = JavaScriptHighlightDescriptor.COMMA.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_DOT = JavaScriptHighlightDescriptor.DOT.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_SEMICOLON = JavaScriptHighlightDescriptor.SEMICOLON.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_BAD_CHARACTER = JavaScriptHighlightDescriptor.BAD_CHARACTER.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_DOC_TAG = JavaScriptHighlightDescriptor.DOC_TAG.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_DOC_TAG_NAMEPATH = JavaScriptHighlightDescriptor.DOC_TAG_NAMEPATH.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_DOC_TYPE = JavaScriptHighlightDescriptor.DOC_TYPE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_VALID_STRING_ESCAPE = JavaScriptHighlightDescriptor.VALID_STRING_ESCAPE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_INVALID_STRING_ESCAPE = JavaScriptHighlightDescriptor.INVALID_STRING_ESCAPE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_LOCAL_VARIABLE = JavaScriptHighlightDescriptor.LOCAL_VARIABLE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_PARAMETER = JavaScriptHighlightDescriptor.PARAMETER.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_INSTANCE_MEMBER_VARIABLE = JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_STATIC_MEMBER_VARIABLE = JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_GLOBAL_VARIABLE = JavaScriptHighlightDescriptor.GLOBAL_VARIABLE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_GLOBAL_FUNCTION = JavaScriptHighlightDescriptor.GLOBAL_FUNCTION.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_LOCAL_FUNCTION = JavaScriptHighlightDescriptor.LOCAL_FUNCTION.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey ES6_DECORATOR = JavaScriptHighlightDescriptor.DECORATOR.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_STATIC_MEMBER_FUNCTION = JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_INSTANCE_MEMBER_FUNCTION = JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_CLASS = JavaScriptHighlightDescriptor.CLASS.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_INTERFACE = JavaScriptHighlightDescriptor.INTERFACE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_TYPE_ALIAS = JavaScriptHighlightDescriptor.TYPE_ALIAS.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_LABEL = JavaScriptHighlightDescriptor.LABEL.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_MODULE_NAME = JavaScriptHighlightDescriptor.MODULE_NAME.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey FUNCTION_ARROW = JavaScriptHighlightDescriptor.FUNCTION_ARROW.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_PRIMITIVE_TYPE = JavaScriptHighlightDescriptor.PRIMITIVE_TYPE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_EXPORTED_VARIABLE = JavaScriptHighlightDescriptor.EXPORTED_VARIABLE.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_EXPORTED_FUNCTION = JavaScriptHighlightDescriptor.EXPORTED_FUNCTION.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_EXPORTED_CLASS = JavaScriptHighlightDescriptor.EXPORTED_CLASS.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JSX_CLIENT_COMPONENT = JavaScriptHighlightDescriptor.JSX_CLIENT_COMPONENT.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS = JavaScriptHighlightDescriptor.TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS.getOrCreateTextAttributesKey();
    @JvmField
    @NotNull
    public static final TextAttributesKey JS_INJECTED_LANGUAGE_FRAGMENT;
    @NotNull
    private static final Lazy<TokenSet> OPERATORS_LIKE$delegate;

    public JSHighlighter(@NotNull DialectOptionHolder dialectOptionsHolder) {
        Intrinsics.checkNotNullParameter((Object)dialectOptionsHolder, (String)"dialectOptionsHolder");
        this.dialectOptionsHolder = dialectOptionsHolder;
    }

    @NotNull
    public final DialectOptionHolder getDialectOptionsHolder() {
        return this.dialectOptionsHolder;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return (Lexer)new JavaScriptHighlightingLexer(this.dialectOptionsHolder);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        if (this.getKeywords().contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)JS_KEYWORD);
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray, (String)"pack(...)");
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)Keys.INSTANCE.getKeys1().get(tokenType), (TextAttributesKey)Keys.INSTANCE.getKeys2().get(tokenType));
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray, (String)"pack(...)");
        return textAttributesKeyArray;
    }

    @NotNull
    public TextAttributesKey getMappedKey(@NotNull TextAttributesKey original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return original;
    }

    @NotNull
    public TokenSet getKeywords() {
        return JSKeywordSets.JS_RESERVED_WORDS;
    }

    private static final TokenSet OPERATORS_LIKE_delegate$lambda$0() {
        TokenSet[] tokenSetArray = new TokenSet[]{JSTokenTypes.OPERATIONS, JSTokenTypes.ARROWS};
        return TokenSet.orSet((TokenSet[])tokenSetArray);
    }

    @NotNull
    protected static final TokenSet getOPERATORS_LIKE() {
        return Companion.getOPERATORS_LIKE();
    }

    static {
        TextAttributesKey textAttributesKey = EditorColors.createInjectedLanguageFragmentKey((Language)JavascriptLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createInjectedLanguageFragmentKey(...)");
        JS_INJECTED_LANGUAGE_FRAGMENT = textAttributesKey;
        OPERATORS_LIKE$delegate = LazyKt.lazy(JSHighlighter::OPERATORS_LIKE_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R!\u00100\u001a\u0002018DX\u0085\u0084\u0002\u00a2\u0006\u0012\n\u0004\b5\u00106\u0012\u0004\b2\u0010\u0003\u001a\u0004\b3\u00104\u00a8\u00067"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSHighlighter$Companion;", "", "<init>", "()V", "JS_KEYWORD", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "JS_STRING", "JS_NUMBER", "JS_REGEXP", "JS_LINE_COMMENT", "JS_BLOCK_COMMENT", "JS_DOC_COMMENT", "JS_OPERATION_SIGN", "JS_PARENTHS", "JS_BRACKETS", "JS_BRACES", "JS_COMMA", "JS_DOT", "JS_SEMICOLON", "JS_BAD_CHARACTER", "JS_DOC_TAG", "JS_DOC_TAG_NAMEPATH", "JS_DOC_TYPE", "JS_VALID_STRING_ESCAPE", "JS_INVALID_STRING_ESCAPE", "JS_LOCAL_VARIABLE", "JS_PARAMETER", "JS_INSTANCE_MEMBER_VARIABLE", "JS_STATIC_MEMBER_VARIABLE", "JS_GLOBAL_VARIABLE", "JS_GLOBAL_FUNCTION", "JS_LOCAL_FUNCTION", "ES6_DECORATOR", "JS_STATIC_MEMBER_FUNCTION", "JS_INSTANCE_MEMBER_FUNCTION", "JS_CLASS", "JS_INTERFACE", "JS_TYPE_ALIAS", "JS_LABEL", "JS_MODULE_NAME", "FUNCTION_ARROW", "JS_PRIMITIVE_TYPE", "JS_EXPORTED_VARIABLE", "JS_EXPORTED_FUNCTION", "JS_EXPORTED_CLASS", "JSX_CLIENT_COMPONENT", "JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS", "JS_INJECTED_LANGUAGE_FRAGMENT", "OPERATORS_LIKE", "Lcom/intellij/psi/tree/TokenSet;", "getOPERATORS_LIKE$annotations", "getOPERATORS_LIKE", "()Lcom/intellij/psi/tree/TokenSet;", "OPERATORS_LIKE$delegate", "Lkotlin/Lazy;", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final TokenSet getOPERATORS_LIKE() {
            Lazy lazy = OPERATORS_LIKE$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (TokenSet)object;
        }

        @JvmStatic
        protected static /* synthetic */ void getOPERATORS_LIKE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSHighlighter$JSXmlTokenHighlighter;", "Lcom/intellij/ide/highlighter/EmbeddedTokenHighlighter;", "<init>", "()V", "getEmbeddedTokenAttributes", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.javascript.psi.impl"})
    public static final class JSXmlTokenHighlighter
    implements EmbeddedTokenHighlighter {
        @NotNull
        public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
            MultiMap map = new MultiMap(Keys.INSTANCE.getKeys1().size() + Keys.INSTANCE.getKeys2().size());
            map.putAllValues(Keys.INSTANCE.getKeys1());
            map.putAllValues(Keys.INSTANCE.getKeys2());
            return map;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSHighlighter$Keys;", "", "<init>", "()V", "keys1", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getKeys1", "()Ljava/util/Map;", "keys2", "getKeys2", "intellij.javascript.psi.impl"})
    private static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        private static final Map<IElementType, TextAttributesKey> keys1 = new HashMap();
        @NotNull
        private static final Map<IElementType, TextAttributesKey> keys2 = new HashMap();

        private Keys() {
        }

        @NotNull
        public final Map<IElementType, TextAttributesKey> getKeys1() {
            return keys1;
        }

        @NotNull
        public final Map<IElementType, TextAttributesKey> getKeys2() {
            return keys2;
        }

        static {
            SyntaxHighlighterBase.fillMap(keys1, (TokenSet)JSHighlighter.getOPERATORS_LIKE(), (TextAttributesKey)JS_OPERATION_SIGN);
            SyntaxHighlighterBase.fillMap(keys1, (TokenSet)JSKeywordSets.JS_RESERVED_WORDS, (TextAttributesKey)JS_KEYWORD);
            keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, JS_VALID_STRING_ESCAPE);
            keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
            keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
            keys1.put(JSTokenTypes.NUMERIC_LITERAL, JS_NUMBER);
            keys1.put(JSTokenTypes.STRING_LITERAL, JS_STRING);
            keys1.put(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, JS_STRING);
            keys1.put(JSTokenTypes.STRING_TEMPLATE_PART, JS_STRING);
            keys1.put(JSTokenTypes.BACKQUOTE, JS_STRING);
            keys1.put(JSTokenTypes.REGEXP_LITERAL, JS_REGEXP);
            keys1.put(JSTokenTypes.LPAR, JS_PARENTHS);
            keys1.put(JSTokenTypes.RPAR, JS_PARENTHS);
            keys1.put(JSTokenTypes.LBRACE, JS_BRACES);
            keys1.put(JSTokenTypes.RBRACE, JS_BRACES);
            keys1.put(JSTokenTypes.LBRACKET, JS_BRACKETS);
            keys1.put(JSTokenTypes.RBRACKET, JS_BRACKETS);
            keys1.put(JSTokenTypes.COMMA, JS_COMMA);
            keys1.put(JSTokenTypes.DOT, JS_DOT);
            keys1.put(JSTokenTypes.ELVIS, JS_DOT);
            keys1.put(JSTokenTypes.SEMICOLON, JS_SEMICOLON);
            keys1.put(JSTokenTypes.C_STYLE_COMMENT, JS_BLOCK_COMMENT);
            keys1.put(JSTokenTypes.XML_STYLE_COMMENT, JS_BLOCK_COMMENT);
            keys1.put(JSElementTypes.DOC_COMMENT, JS_DOC_COMMENT);
            keys1.put(JSTokenTypes.END_OF_LINE_COMMENT, JS_LINE_COMMENT);
            keys1.put(JSTokenTypes.BAD_CHARACTER, JS_BAD_CHARACTER);
            keys1.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_COMMENT);
            keys2.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_TAG);
            IElementType[] javadoc = JSDocTokenTypes.INSTANCE.enumerateJSDocElementTypes();
            int n = javadoc.length;
            for (int i = 0; i < n; ++i) {
                IElementType type = javadoc[i];
                keys1.put(type, JS_DOC_COMMENT);
            }
            keys1.put(JSDocTokenTypes.DOC_DESCRIPTION, JS_DOC_COMMENT);
            keys1.put(JSDocTokenTypes.DOC_TAG_TYPE, JS_DOC_COMMENT);
            keys1.put(JSDocTokenTypes.DOC_TAG_NAMEPATH, JS_DOC_COMMENT);
            IElementType[] iElementTypeArray = JSElementTypes.XML_TOKENS.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
            for (IElementType type : iElementTypeArray) {
                keys1.put(type, XmlHighlighterColors.XML_TAG);
            }
            keys1.put(JSTokenTypes.XML_LBRACE, JS_BRACES);
            keys1.put(JSTokenTypes.XML_RBRACE, JS_BRACES);
            keys2.put(JSTokenTypes.XML_TAG_NAME, XmlHighlighterColors.XML_TAG_NAME);
            keys2.put(JSTokenTypes.XML_NAME, XmlHighlighterColors.XML_ATTRIBUTE_NAME);
            keys2.put(JSTokenTypes.XML_ATTR_VALUE, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
            keys2.put(JSTokenTypes.XML_ATTR_VALUE_END, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
            keys2.put(JSTokenTypes.XML_ATTR_VALUE_START, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
            keys2.put(JSTokenTypes.XML_ATTR_EQUAL, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
            keys2.put(JSTokenTypes.XML_ENTITY_REF, XmlHighlighterColors.XML_ENTITY_REFERENCE);
            keys1.put(JSTokenTypes.XML_STYLE_COMMENT, XmlHighlighterColors.XML_COMMENT);
            keys1.put(JSTokenTypes.XML_TAG_CONTENT, XmlHighlighterColors.XML_TAG_DATA);
        }
    }
}

