/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/psi/impl/JSBlockStatementEagerImpl;", "Lcom/intellij/lang/javascript/psi/impl/JSStatementImpl;", "Lcom/intellij/lang/javascript/psi/JSBlockStatement;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getStatementListItems", "", "Lcom/intellij/lang/javascript/psi/JSSourceElement;", "()[Lcom/intellij/lang/javascript/psi/JSSourceElement;", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "add", "Lcom/intellij/psi/PsiElement;", "element", "intellij.javascript.psi.impl"})
public class JSBlockStatementEagerImpl
extends JSStatementImpl
implements JSBlockStatement {
    public JSBlockStatementEagerImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    @NotNull
    public JSSourceElement[] getStatementListItems() {
        JSSourceElement[] jSSourceElementArray = JSBlockStatementImpl.getInnerStatements(this);
        Intrinsics.checkNotNullExpressionValue((Object)jSSourceElementArray, (String)"getInnerStatements(...)");
        return jSSourceElementArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSBlock(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @Nullable
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        ASTNode node;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof JSStatement && (node = this.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
            PsiElement psiElement = super.addAfter(element, node.getTreePrev().getPsi());
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), psiElement.getNode());
            return psiElement;
        }
        return super.add(element);
    }
}

