/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.impl.CssPsiPresentationService;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/psi/css/impl/CssBackendPsiPresentationService;", "Lcom/intellij/psi/css/impl/CssPsiPresentationService;", "<init>", "()V", "getLocationString", "", "context", "Lcom/intellij/psi/PsiElement;", "intellij.css.backend"})
public final class CssBackendPsiPresentationService
implements CssPsiPresentationService {
    @Nullable
    public String getLocationString(@NotNull PsiElement context) {
        PsiFile psiFile;
        VirtualFile vFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement context2 = context;
        if (context2 instanceof CssClass) {
            PsiElement psiElement = context2.getNavigationElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNavigationElement(...)");
            context2 = psiElement;
        }
        if ((vFile = (psiFile = context2.getContainingFile()).getVirtualFile()) != null) {
            for (OrderEntry entry : ProjectFileIndex.getInstance((Project)context2.getProject()).getOrderEntriesForFile(vFile)) {
                if (!(entry instanceof LibraryOrderEntry)) continue;
                return ((LibraryOrderEntry)entry).getPresentableName();
            }
        }
        Object filePathPresentation = SymbolPresentationUtil.getFilePathPresentation((PsiFile)psiFile);
        int lineNumber = -1;
        if (context2 instanceof CssNamedElement) {
            lineNumber = ((CssNamedElement)context2).getLineNumber();
        } else if (context2 instanceof CssSelector) {
            lineNumber = ((CssSelector)context2).getLineNumber();
        }
        if (lineNumber > 0) {
            filePathPresentation = (String)filePathPresentation + ":" + lineNumber;
        }
        return filePathPresentation;
    }
}

