/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.indexing.ID;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class CssFontFamilyUtil {
    private CssFontFamilyUtil() {
    }

    public static String[] getPopularFontFamilies(PsiElement context, @NotNull CssTermList termList) {
        if (termList == null) {
            CssFontFamilyUtil.$$$reportNull$$$0(0);
        }
        HashSet<String> values = new HashSet<String>();
        for (PsiElement child : termList.getChildren()) {
            String text;
            PsiElement originalChild = CompletionUtil.getOriginalElement((PsiElement)child);
            if (!(originalChild instanceof CssTerm) || (text = originalChild.getText()) == null) continue;
            values.add(StringUtil.toLowerCase((String)StringUtil.unquoteString((String)text)));
        }
        String currentValue = CssFontFamilyUtil.getCurrentValue(context);
        HashSet result = new HashSet();
        Processor collectProcessor = s -> {
            String key;
            String keyLowerCase;
            CssIndexValue type = CssIndexValue.keyType((String)s);
            if (!(type != CssIndexValue.FONT_FAMILY || values.contains(keyLowerCase = StringUtil.toLowerCase((String)(key = CssIndexValue.realKey((String)s)))) || key.isEmpty() || currentValue != null && StringUtil.toLowerCase((String)currentValue).startsWith(keyLowerCase))) {
                result.remove(StringUtil.decapitalize((String)key));
                if (!result.contains(StringUtil.capitalize((String)key))) {
                    result.add(key);
                }
            }
            return true;
        };
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)termList);
        CssIndexUtil.processKeysInScope((ID)CssIndex.CSS_INDEX, (Project)termList.getProject(), (GlobalSearchScope)scope, (Processor)collectProcessor);
        return ArrayUtilRt.toStringArray(result);
    }

    private static String getCurrentValue(PsiElement context) {
        String currentValue = context instanceof CssString ? ((CssString)context).getValue() : (context instanceof LeafElement && ((LeafElement)context).getElementType() == CssElementTypes.CSS_IDENT ? context.getText() : null);
        return currentValue;
    }

    public static String[] getPopularFontPacks(@NotNull CssTermList termList) {
        CssTermList originalTermList;
        if (termList == null) {
            CssFontFamilyUtil.$$$reportNull$$$0(1);
        }
        String currentValue = (originalTermList = (CssTermList)CompletionUtil.getOriginalElement((PsiElement)termList)) != null ? originalTermList.getText().trim() : "";
        HashSet result = new HashSet();
        Processor collectProcessor = s -> {
            CssIndexValue type = CssIndexValue.keyType((String)s);
            if (type == CssIndexValue.FONT_FAMILY_PACK) {
                String key = CssIndexValue.realKey((String)s);
                String keyLowerCase = StringUtil.toLowerCase((String)key);
                if (!key.isEmpty() && !StringUtil.toLowerCase((String)currentValue).startsWith(keyLowerCase)) {
                    result.add(key);
                }
            }
            return true;
        };
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)termList);
        CssIndexUtil.processKeysInScope((ID)CssIndex.CSS_INDEX, (Project)termList.getProject(), (GlobalSearchScope)scope, (Processor)collectProcessor);
        return ArrayUtilRt.toStringArray(result);
    }

    public static String[] getSystemFontFamilies() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return graphicsEnvironment.getAvailableFontFamilyNames();
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "termList";
        objectArray2[1] = "com/intellij/psi/css/impl/util/CssFontFamilyUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopularFontFamilies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopularFontPacks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

