/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "<init>", "()V", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "canImport", "", "typeName", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "intellij.gradle"})
public final class GradleRunConfigurationImporter
implements RunConfigurationImporter {
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, Object> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (!(runConfiguration instanceof GradleRunConfiguration)) {
            return;
        }
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = ((GradleRunConfiguration)runConfiguration).getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"getSettings(...)");
        ExternalSystemTaskExecutionSettings settings = externalSystemTaskExecutionSettings;
        ObjectUtils.consumeIfCast((Object)cfg.get("projectPath"), String.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$1(arg_0 -> GradleRunConfigurationImporter.process$lambda$0(settings, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("taskNames"), List.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$3(arg_0 -> GradleRunConfigurationImporter.process$lambda$2(settings, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("envs"), Map.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$5(arg_0 -> GradleRunConfigurationImporter.process$lambda$4(settings, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("jvmArgs"), String.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$7(arg_0 -> GradleRunConfigurationImporter.process$lambda$6(settings, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("scriptParameters"), String.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$9(arg_0 -> GradleRunConfigurationImporter.process$lambda$8(settings, arg_0), arg_0));
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)"gradle", (Object)typeName);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GradleExternalTaskConfigurationType.getInstance().getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"getFactory(...)");
        return configurationFactory;
    }

    private static final Unit process$lambda$0(ExternalSystemTaskExecutionSettings $settings, String it) {
        $settings.setExternalProjectPath(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$2(ExternalSystemTaskExecutionSettings $settings, List it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        $settings.setTaskNames(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$4(ExternalSystemTaskExecutionSettings $settings, Map it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        $settings.setEnv(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$6(ExternalSystemTaskExecutionSettings $settings, String it) {
        $settings.setVmOptions(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$8(ExternalSystemTaskExecutionSettings $settings, String it) {
        $settings.setScriptParameters(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

