/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.ProfilerDumpWriter;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/actions/ExportProfilerResultAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "writer", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "<init>", "(Lcom/intellij/profiler/api/ProfilerDumpWriter;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "Companion", "intellij.profiler.common"})
public class ExportProfilerResultAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfilerDumpWriter writer;

    public ExportProfilerResultAction(@NotNull ProfilerDumpWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(CommonProfilerBundleKt.profilerMessage("export.profiler.result.action.name", new Object[0]), null, AllIcons.ToolbarDecorator.Export);
        this.writer = writer;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        VirtualFile baseDir;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileSaverDescriptor descriptor = new FileSaverDescriptor(CommonProfilerBundleKt.profilerMessage("profiler.action.export", new Object[0]), CommonProfilerBundleKt.profilerMessage("profiler.action.export.selectPath", new Object[0]));
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, e.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog saverDialog = fileSaverDialog;
        String snapshotsFolder = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getSnapshotOptions().getFolder();
        if (snapshotsFolder != null) {
            v1 = LocalFileSystem.getInstance().findFileByPath(snapshotsFolder);
        } else {
            Project project = e.getProject();
            v1 = baseDir = project != null ? project.getBaseDir() : null;
        }
        if ((object = saverDialog.save(baseDir, this.writer.getDumpFileName())) == null || (object = object.getFile()) == null) {
            return;
        }
        Object file = object;
        Project project = e.getProject();
        String string = CommonProfilerBundleKt.profilerMessage("profiler.action.export.text", new Object[0]);
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.DEAF;
        new Task.Backgroundable(this, (File)file, e, project, string, performInBackgroundOption){
            final /* synthetic */ ExportProfilerResultAction this$0;
            final /* synthetic */ File $file;
            final /* synthetic */ AnActionEvent $e;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$e = $e;
                super($super_call_param$1, $super_call_param$2, true, $super_call_param$3);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ExportProfilerResultAction.access$getWriter$p(this.this$0).writeDump(this.$file, indicator);
                Project project = this.$e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                ProfilerToolWindowManager.Companion.getInstance(project2).showInfoBalloon(CommonProfilerBundleKt.profilerMessage("profiler.action.export.balloon", new Object[0]));
            }

            public void onThrowable(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                com.intellij.profiler.actions.ExportProfilerResultAction$Companion.access$notifySaveDumpError(ExportProfilerResultAction.Companion, error.getMessage(), this.getProject());
                this.$file.delete();
            }

            public void onCancel() {
                this.$file.delete();
            }
        }.queue();
    }

    public static final /* synthetic */ ProfilerDumpWriter access$getWriter$p(ExportProfilerResultAction $this) {
        return $this.writer;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\"\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000b*\u00070\u0007\u00a2\u0006\u0002\b\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0003\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/actions/ExportProfilerResultAction$Companion;", "", "<init>", "()V", "notifySaveDumpError", "", "message", "", "project", "Lcom/intellij/openapi/project/Project;", "withTextAfterColon", "Lorg/jetbrains/annotations/Nls;", "text", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        private final void notifySaveDumpError(@Nls String message, Project project) {
            ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, this.withTextAfterColon(CommonProfilerBundleKt.profilerMessage("profiler.action.export.save.error", new Object[0]), message), project, null, 4, null);
        }

        @Nls
        private final String withTextAfterColon(String $this$withTextAfterColon, @Nls String text) {
            CharSequence charSequence = text;
            return charSequence == null || charSequence.length() == 0 ? $this$withTextAfterColon : $this$withTextAfterColon + ": " + text;
        }

        public static final /* synthetic */ void access$notifySaveDumpError(Companion $this, String message, Project project) {
            $this.notifySaveDumpError(message, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

