/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerDumpParserProviderFinder;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfileHistoryConfiguration;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpDescriptor;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.api.ProfilerDumpParserProviderKt;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.statistics.SnapshotImportEventData;
import com.intellij.profiler.statistics.SnapshotImportOrigin;
import com.intellij.profiler.statistics.SnapshotImportSource;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\u001f\b\u0004\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/actions/ImportProfilerResultAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Recent", "Open", "Companion", "Lcom/intellij/profiler/actions/ImportProfilerResultAction$Open;", "Lcom/intellij/profiler/actions/ImportProfilerResultAction$Recent;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nImportProfilerResultAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportProfilerResultAction.kt\ncom/intellij/profiler/actions/ImportProfilerResultAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,193:1\n13#2:194\n*S KotlinDebug\n*F\n+ 1 ImportProfilerResultAction.kt\ncom/intellij/profiler/actions/ImportProfilerResultAction\n*L\n191#1:194\n*E\n"})
public abstract sealed class ImportProfilerResultAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    private ImportProfilerResultAction(@NlsActions.ActionText String text, Icon icon) {
        super(text, null, icon);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(!((Collection)ProfilerDumpParserProviderKt.getProfilerDumpParserProviders()).isEmpty());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public /* synthetic */ ImportProfilerResultAction(String text, Icon icon, DefaultConstructorMarker $constructor_marker) {
        this(text, icon);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImportProfilerResultAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\f\u0010\u0018\u001a\u00020\u0005*\u00020\u0019H\u0003J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/profiler/actions/ImportProfilerResultAction$Companion;", "", "<init>", "()V", "textFor", "", "dump", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "iconFor", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "importProfilerDump", "", "project", "Lcom/intellij/openapi/project/Project;", "onComplete", "Ljava/lang/Runnable;", "eventData", "Lcom/intellij/profiler/statistics/SnapshotImportEventData;", "importProfilerDumpAsAssociated", "file", "Ljava/io/File;", "parserProvider", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "getReasonString", "Lcom/intellij/profiler/api/Failure;", "findParserProvider", "chooseProviderManually", "providers", "", "chooseProfilerSnapshot", "Lcom/intellij/openapi/vfs/VirtualFile;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nImportProfilerResultAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportProfilerResultAction.kt\ncom/intellij/profiler/actions/ImportProfilerResultAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1586#2:194\n1661#2,3:195\n1915#2,2:199\n1915#2,2:201\n1#3:198\n*S KotlinDebug\n*F\n+ 1 ImportProfilerResultAction.kt\ncom/intellij/profiler/actions/ImportProfilerResultAction$Companion\n*L\n167#1:194\n167#1:195,3\n168#1:199,2\n169#1:201,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NlsSafe
        private final String textFor(ProfilerDumpDescriptor dump) {
            return dump.getName() + " (" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(dump.getTime()) + ")";
        }

        private final Icon iconFor(ProfilerDumpDescriptor dump) {
            Icon icon = AllIcons.Actions.Profile;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Profile");
            return icon;
        }

        public final void importProfilerDump(@NotNull Project project, @NotNull ProfilerDumpDescriptor dump, @Nullable Runnable onComplete, @Nullable SnapshotImportEventData eventData) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
            this.importProfilerDump(project, dump.getFile(), dump.getParserProvider(), dump, onComplete, eventData);
        }

        public static /* synthetic */ void importProfilerDump$default(Companion companion, Project project, ProfilerDumpDescriptor profilerDumpDescriptor, Runnable runnable, SnapshotImportEventData snapshotImportEventData, int n, Object object) {
            if ((n & 4) != 0) {
                runnable = null;
            }
            if ((n & 8) != 0) {
                snapshotImportEventData = null;
            }
            companion.importProfilerDump(project, profilerDumpDescriptor, runnable, snapshotImportEventData);
        }

        public final void importProfilerDumpAsAssociated(@NotNull Project project, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            com.intellij.profiler.actions.ImportProfilerResultAction$Companion.importProfilerDump$default(this, project, file, null, null, null, new SnapshotImportEventData(SnapshotImportOrigin.OPEN_FILE, SnapshotImportSource.External.INSTANCE), 28, null);
        }

        @RequiresEdt
        public final void importProfilerDump(@NotNull Project project, @NotNull File file, @Nullable ProfilerDumpParserProvider parserProvider, @Nullable ProfilerDumpDescriptor dump, @Nullable Runnable onComplete, @Nullable SnapshotImportEventData eventData) {
            ProfilerDumpParserProvider provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ProfilerToolWindowManager manager = ProfilerToolWindowManager.Companion.getInstance(project);
            Content content = manager.findToolWindowContent(file);
            if (content != null) {
                LOG.info("Dump for file " + file.getAbsoluteFile() + " is already opened. Navigating to the existing tab.");
                manager.openExistingTab(content);
                return;
            }
            ProfilerDumpParserProvider profilerDumpParserProvider = parserProvider;
            if (profilerDumpParserProvider == null) {
                profilerDumpParserProvider = this.findParserProvider(project, file);
            }
            if ((provider = profilerDumpParserProvider) == null) {
                ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, CommonProfilerBundleKt.profilerMessage("profiler.action.import.cant.find.parser", new Object[0]), project, null, 4, null);
                return;
            }
            long start = System.currentTimeMillis();
            Object[] objectArray = new Object[]{provider.getName()};
            String string = CommonProfilerBundleKt.profilerMessage("profiler.action.import.reading", objectArray);
            objectArray = PerformInBackgroundOption.ALWAYS_BACKGROUND;
            new Task.Backgroundable(provider, project, file, dump, start, eventData, manager, onComplete, string, (PerformInBackgroundOption)objectArray){
                private final ProfilerDumpFileParser parser;
                final /* synthetic */ ProfilerDumpParserProvider $provider;
                final /* synthetic */ Project $project;
                final /* synthetic */ File $file;
                final /* synthetic */ ProfilerDumpDescriptor $dump;
                final /* synthetic */ long $start;
                final /* synthetic */ SnapshotImportEventData $eventData;
                final /* synthetic */ ProfilerToolWindowManager $manager;
                final /* synthetic */ Runnable $onComplete;
                {
                    this.$provider = $provider;
                    this.$project = $project;
                    this.$file = $file;
                    this.$dump = $dump;
                    this.$start = $start;
                    this.$eventData = $eventData;
                    this.$manager = $manager;
                    this.$onComplete = $onComplete;
                    super($project, $super_call_param$1, true, $super_call_param$2);
                    this.parser = $provider.createParser($project);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ImportProfilerResultAction.access$getLOG$cp().info("Started reading the dump '" + this.$file.getName() + "'");
                    ProfilerDumpFileParsingResult result2 = this.parser.parse(this.$file, indicator);
                    if (result2 instanceof Success) {
                        Object object = this.$dump;
                        if (object == null || (object = ((ProfilerDumpDescriptor)object).getName()) == null) {
                            object = this.$file.getName();
                        }
                        Object name = object;
                        ProfileHistoryConfiguration profileHistoryConfiguration = ProfileHistoryConfiguration.Companion.getInstance(this.$project);
                        Intrinsics.checkNotNull((Object)name);
                        profileHistoryConfiguration.register(this.$file, (String)name);
                        ProfilerDumpDescriptor profilerDumpDescriptor = this.$dump;
                        if (profilerDumpDescriptor == null) {
                            profilerDumpDescriptor = ProfilerDumpDescriptor.Companion.fromFile(this.$file, this.$project, (String)name);
                        }
                        ProfilerDumpDescriptor descriptor = profilerDumpDescriptor;
                        AppUIUtil.invokeLaterIfProjectAlive((Project)this.$project, () -> importProfilerDump.1.run$lambda$0(this.$start, this.$eventData, this.$project, this.$provider, this.$file, this.$manager, result2, (String)name, this, descriptor));
                    } else if (result2 instanceof Failure) {
                        ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, com.intellij.profiler.actions.ImportProfilerResultAction$Companion.access$getReasonString(ImportProfilerResultAction.Companion, (Failure)result2), this.$project, null, 4, null);
                    }
                }

                public void onCancel() {
                    ImportProfilerResultAction.access$getLOG$cp().info("Reading the dump '" + this.$file.getName() + "' was cancelled");
                    super.onCancel();
                }

                public void onSuccess() {
                    ImportProfilerResultAction.access$getLOG$cp().info("Finished reading the dump '" + this.$file.getName() + "'");
                    super.onSuccess();
                }

                public void onFinished() {
                    block0: {
                        Runnable runnable = this.$onComplete;
                        if (runnable == null) break block0;
                        runnable.run();
                    }
                }

                public void onThrowable(Throwable error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    String message = UtilsKt.explain(error, CommonProfilerBundleKt.profilerMessage("profiler.action.import.error", new Object[0]));
                    ImportProfilerResultAction.access$getLOG$cp().warn(message, error);
                    ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, message, this.$project, null, 4, null);
                }

                private static final void run$lambda$0(long $start, SnapshotImportEventData $eventData, Project $project, ProfilerDumpParserProvider $provider, File $file, ProfilerToolWindowManager $manager, ProfilerDumpFileParsingResult $result, String $name, importProfilerDump.1 this$0, ProfilerDumpDescriptor $descriptor) {
                    long durationMs = System.currentTimeMillis() - $start;
                    if ($eventData != null) {
                        ProfilerUsageTriggerCollector.logSnapshotOpened($project, $provider.getId(), $file.length(), durationMs, $eventData);
                    }
                    ProfilerData profilerData = ((Success)$result).getData();
                    Intrinsics.checkNotNull((Object)$name);
                    ProfilerToolWindowManager.addProfilerDumpTab$default($manager, new ProfilerDumpPanel($project, profilerData, $name, this$0.parser.getHelpId(), $descriptor, $name), false, 2, null);
                }
            }.queue();
        }

        public static /* synthetic */ void importProfilerDump$default(Companion companion, Project project, File file, ProfilerDumpParserProvider profilerDumpParserProvider, ProfilerDumpDescriptor profilerDumpDescriptor, Runnable runnable, SnapshotImportEventData snapshotImportEventData, int n, Object object) {
            if ((n & 4) != 0) {
                profilerDumpParserProvider = null;
            }
            if ((n & 8) != 0) {
                profilerDumpDescriptor = null;
            }
            if ((n & 0x10) != 0) {
                runnable = null;
            }
            if ((n & 0x20) != 0) {
                snapshotImportEventData = null;
            }
            companion.importProfilerDump(project, file, profilerDumpParserProvider, profilerDumpDescriptor, runnable, snapshotImportEventData);
        }

        @NlsSafe
        private final String getReasonString(Failure $this$getReasonString) {
            return $this$getReasonString.getReason();
        }

        private final ProfilerDumpParserProvider findParserProvider(Project project, File file) {
            ProfilerDumpParserProvider profilerDumpParserProvider;
            ProfilerDumpParserProviderFinder finder = new ProfilerDumpParserProviderFinder();
            ProfilerDumpParserProviderFinder.Result result2 = finder.findParserProvider(file, ProfilerDumpParserProviderKt.getProfilerDumpParserProviders());
            if (result2 instanceof ProfilerDumpParserProviderFinder.Result.Success) {
                profilerDumpParserProvider = ((ProfilerDumpParserProviderFinder.Result.Success)result2).getProvider();
            } else if (result2 instanceof ProfilerDumpParserProviderFinder.Result.Failure) {
                profilerDumpParserProvider = this.chooseProviderManually(((ProfilerDumpParserProviderFinder.Result.Failure)result2).getProvidersWithoutSignaturesAndExtension(), project);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return profilerDumpParserProvider;
        }

        /*
         * WARNING - void declaration
         */
        private final ProfilerDumpParserProvider chooseProviderManually(List<? extends ProfilerDumpParserProvider> providers, Project project) {
            JBRadioButton it;
            void $this$mapTo$iv$iv;
            LOG.info("couldn't find an appropriate provider by file extension or file signature");
            if (providers.isEmpty()) {
                return null;
            }
            if (providers.size() == 1) {
                Object object = CollectionsKt.first(providers);
                ProfilerDumpParserProvider it2 = (ProfilerDumpParserProvider)object;
                boolean bl = false;
                LOG.info("provider " + it2.getName() + " has been chosen implicitly");
                return (ProfilerDumpParserProvider)object;
            }
            Object $this$map$iv = providers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ProfilerDumpParserProvider profilerDumpParserProvider = (ProfilerDumpParserProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JBRadioButton(it.getName()));
            }
            $this$map$iv = (List)destination$iv$iv;
            Iterable $this$chooseProviderManually_u24lambda_u242 = $this$map$iv;
            boolean bl = false;
            ((JBRadioButton)CollectionsKt.first((List)$this$chooseProviderManually_u24lambda_u242)).setSelected(true);
            Iterable buttons = $this$map$iv;
            Object $this$chooseProviderManually_u24lambda_u243 = $this$map$iv = new ButtonGroup();
            boolean bl2 = false;
            Iterable $this$forEach$iv = buttons;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JBRadioButton)element$iv;
                boolean bl3 = false;
                ((ButtonGroup)$this$chooseProviderManually_u24lambda_u243).add((AbstractButton)it);
            }
            Object $this$chooseProviderManually_u24lambda_u244 = $this$chooseProviderManually_u24lambda_u243 = new JPanel((LayoutManager)new VerticalFlowLayout());
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = buttons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                JBRadioButton it3 = (JBRadioButton)element$iv;
                boolean bl5 = false;
                ((Container)$this$chooseProviderManually_u24lambda_u244).add((Component)it3);
            }
            Object panel2 = $this$chooseProviderManually_u24lambda_u243;
            DialogWrapper dialog = ComponentsKt.dialog$default((String)CommonProfilerBundleKt.profilerMessage("import.profiler.dump.dialog.title", new Object[0]), (JComponent)((JComponent)panel2), (boolean)false, null, (boolean)false, (Project)project, null, null, null, null, null, (int)2012, null);
            AtomicReference<Object> ref = new AtomicReference<Object>(null);
            ApplicationManager.getApplication().invokeAndWait(() -> Companion.chooseProviderManually$lambda$5(dialog, (List)buttons, ref, providers));
            return ref.get();
        }

        @Nullable
        public final VirtualFile chooseProfilerSnapshot(@Nullable Project project) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(CommonProfilerBundleKt.profilerMessage("profiler.action.import.openFile", new Object[0])).withHideIgnored(false);
            return FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final void chooseProviderManually$lambda$5(DialogWrapper $dialog, List $buttons, AtomicReference $ref, List $providers) {
            if ($dialog.showAndGet()) {
                ProfilerDumpParserProvider profilerDumpParserProvider;
                Object v0;
                block5: {
                    Iterable iterable = CollectionsKt.withIndex((Iterable)$buttons);
                    for (Object t : iterable) {
                        IndexedValue indexedValue = (IndexedValue)t;
                        boolean bl = false;
                        JBRadioButton b = (JBRadioButton)indexedValue.component2();
                        if (!b.isSelected()) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                IndexedValue indexedValue = v0;
                Integer selected = indexedValue != null ? Integer.valueOf(indexedValue.getIndex()) : null;
                AtomicReference atomicReference = $ref;
                Integer n = selected;
                if (n != null) {
                    void it;
                    int n2 = ((Number)n).intValue();
                    AtomicReference atomicReference2 = atomicReference;
                    boolean bl = false;
                    profilerDumpParserProvider = (ProfilerDumpParserProvider)CollectionsKt.getOrNull((List)$providers, (int)it);
                    atomicReference = atomicReference2;
                } else {
                    profilerDumpParserProvider = null;
                }
                atomicReference.set(profilerDumpParserProvider);
            } else {
                $ref.set(null);
            }
        }

        public static final /* synthetic */ String access$getReasonString(Companion $this, Failure $receiver) {
            return $this.getReasonString($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/actions/ImportProfilerResultAction$Open;", "Lcom/intellij/profiler/actions/ImportProfilerResultAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.profiler.common"})
    public static final class Open
    extends ImportProfilerResultAction {
        public Open() {
            super(CommonProfilerBundleKt.profilerMessage("ui.action.open", new Object[0]), AllIcons.Actions.MenuOpen, null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            VirtualFile virtualFile = Companion.chooseProfilerSnapshot(project2);
            if (virtualFile == null) {
                return;
            }
            VirtualFile vFile = virtualFile;
            File file = new File(vFile.getPath());
            String string = e.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            com.intellij.profiler.actions.ImportProfilerResultAction$Companion.importProfilerDump$default(Companion, project2, file, null, null, null, new SnapshotImportEventData(SnapshotImportOrigin.OPEN_FILE, new SnapshotImportSource.DedicatedActionPlace(string)), 28, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/actions/ImportProfilerResultAction$Recent;", "Lcom/intellij/profiler/actions/ImportProfilerResultAction;", "dump", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "<init>", "(Lcom/intellij/profiler/api/ProfilerDumpDescriptor;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.profiler.common"})
    public static final class Recent
    extends ImportProfilerResultAction {
        @NotNull
        private final ProfilerDumpDescriptor dump;

        public Recent(@NotNull ProfilerDumpDescriptor dump) {
            Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
            super(Companion.textFor(dump), Companion.iconFor(dump), null);
            this.dump = dump;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            String string = e.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            com.intellij.profiler.actions.ImportProfilerResultAction$Companion.importProfilerDump$default(Companion, project2, this.dump, null, new SnapshotImportEventData(SnapshotImportOrigin.RECENT, new SnapshotImportSource.DedicatedActionPlace(string)), 4, null);
        }
    }
}

