/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamechart;

import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorsKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0007*\u00020\u0006H\u0004J\f\u0010\u0011\u001a\u00020\u0007*\u00020\u0006H\u0004J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H$R'\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "", "<init>", "()V", "colorScheme", "", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "Lcom/intellij/ui/JBColor;", "getColorScheme", "()Ljava/util/Map;", "colorScheme$delegate", "Lkotlin/Lazy;", "convert", "type", "getPrefix", "", "colorize", "shadow", "color", "produce", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nFlameChartColors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameChartColors.kt\ncom/intellij/profiler/ui/flamechart/FlameChartColorScheme\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,395:1\n11705#2:396\n12052#2,3:397\n*S KotlinDebug\n*F\n+ 1 FlameChartColors.kt\ncom/intellij/profiler/ui/flamechart/FlameChartColorScheme\n*L\n244#1:396\n244#1:397,3\n*E\n"})
public abstract class FlameChartColorScheme {
    @NotNull
    private final Lazy colorScheme$delegate = LazyKt.lazy(() -> FlameChartColorScheme.colorScheme_delegate$lambda$0(this));

    private final Map<ColorType, JBColor> getColorScheme() {
        Lazy lazy = this.colorScheme$delegate;
        return (Map)lazy.getValue();
    }

    private final JBColor convert(ColorType type) {
        String propName = "FlameGraph." + this.getPrefix() + "Cell." + FlameChartColorsKt.access$toStyle(type);
        return new JBColor(() -> FlameChartColorScheme.convert$lambda$0(propName, this, type));
    }

    @NotNull
    public String getPrefix() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @NotNull
    protected final JBColor colorize(@NotNull ColorType $this$colorize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$colorize), (String)"<this>");
        return new JBColor(() -> FlameChartColorScheme.colorize$lambda$0(this, $this$colorize));
    }

    @NotNull
    protected final JBColor shadow(@NotNull ColorType $this$shadow) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$shadow), (String)"<this>");
        return new JBColor(() -> FlameChartColorScheme.shadow$lambda$0(this, $this$shadow));
    }

    @NotNull
    public final JBColor color(@NotNull ColorType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        JBColor jBColor = this.getColorScheme().get((Object)type);
        if (jBColor == null) {
            throw new NoSuchElementException("Cannot find color for type " + this + "}");
        }
        return jBColor;
    }

    @NotNull
    protected abstract JBColor produce(@NotNull ColorType var1);

    /*
     * WARNING - void declaration
     */
    private static final Map colorScheme_delegate$lambda$0(FlameChartColorScheme this$0) {
        void $this$mapTo$iv$iv;
        ColorType[] $this$map$iv = ColorType.values();
        boolean $i$f$map = false;
        ColorType[] colorTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)this$0.convert((ColorType)it)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final Color convert$lambda$0(String $propName, FlameChartColorScheme this$0, ColorType $type) {
        Color color = UIManager.getColor($propName);
        if (color == null) {
            FlameChartColorScheme it = this$0;
            boolean bl = false;
            JBColor defaultColor = this$0.produce($type);
            UIManager.put($propName, defaultColor);
            color = (Color)defaultColor;
        }
        return color;
    }

    private static final Color colorize$lambda$0(FlameChartColorScheme this$0, ColorType $this_colorize) {
        return ColorUtil.mix((Color)((Color)this$0.color($this_colorize)), (Color)Color.BLACK, (double)0.75);
    }

    private static final Color shadow$lambda$0(FlameChartColorScheme this$0, ColorType $this_shadow) {
        return ColorUtil.mix((Color)((Color)this$0.color($this_shadow)), (Color)Color.DARK_GRAY, (double)0.3);
    }
}

