/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.sunburst;

import com.intellij.profiler.ui.sunburst.SunburstKt;
import com.intellij.profiler.ui.sunburst.SunburstModel;
import com.intellij.profiler.ui.sunburst.SunburstSection;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.EDT;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002LMB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0007J\"\u00102\u001a\u0002002\u001a\u00103\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019\u0012\u0004\u0012\u00020-0,J \u00104\u001a\u0002002\u0018\u00103\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0019\u0012\u0004\u0012\u00020-0,J\u001e\u00105\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207J\u001d\u00105\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\b\u00109\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019*\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0002J\u0016\u0010)\u001a\u0002002\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207J\u0006\u0010)\u001a\u00020*J\u0010\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020>H\u0014JD\u0010?\u001a\u0002002\u0006\u0010=\u001a\u00020@2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\u0006\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u0002072\n\b\u0002\u0010D\u001a\u0004\u0018\u00010 H\u0002J0\u0010E\u001a\u0002002\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190'2\u0012\u0010G\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190'H\u0002J3\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190'2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\n\b\u0002\u0010I\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010JJ \u0010K\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190'H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR0\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R*\u0010\u0012\u001a\u0004\u0018\u00018\u00002\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0019\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190$j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0019`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010+\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019\u0012\u0004\u0012\u00020-0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010.\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0019\u0012\u0004\u0012\u00020-0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst;", "T", "Ljavax/swing/JComponent;", "<init>", "()V", "value", "", "thickness", "getThickness", "()D", "setThickness", "(D)V", "Lcom/intellij/profiler/ui/sunburst/SunburstModel;", "model", "getModel", "()Lcom/intellij/profiler/ui/sunburst/SunburstModel;", "setModel", "(Lcom/intellij/profiler/ui/sunburst/SunburstModel;)V", "center", "getCenter", "()Ljava/lang/Object;", "setCenter", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "hovered", "Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "getHovered", "()Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "setHovered", "(Lcom/intellij/profiler/ui/sunburst/SunburstSection;)V", "hiddenItemsColor", "Lkotlin/Function1;", "Ljava/awt/Color;", "animator", "Lcom/intellij/util/animation/JBAnimator;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "sections", "", "adjust", "shift", "Ljava/awt/Point;", "hover", "Ljava/util/function/BiConsumer;", "Ljava/awt/event/InputEvent;", "select", "fireMouseHoverEvent", "", "ignorePowerSave", "onHover", "consumer", "onSelect", "findSection", "x", "", "y", "content", "(Ljava/lang/Object;)Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "takeIfVisible", "paintComponent", "g", "Ljava/awt/Graphics;", "fillSection", "Ljava/awt/Graphics2D;", "from", "to", "depth", "color", "animate", "source", "target", "generate", "root", "(Lcom/intellij/profiler/ui/sunburst/SunburstModel;Ljava/lang/Object;)Ljava/util/Collection;", "getRootSection", "MouseListener", "SortedIterable", "intellij.profiler.common"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nSunburst.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,424:1\n1#2:425\n1915#3,2:426\n1915#3,2:428\n1915#3,2:430\n1915#3,2:432\n1915#3,2:434\n1915#3,2:440\n1915#3,2:442\n1915#3,2:444\n221#4,2:436\n221#4,2:438\n*S KotlinDebug\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst\n*L\n148#1:426,2\n158#1:428,2\n185#1:430,2\n189#1:432,2\n205#1:434,2\n235#1:440,2\n239#1:442,2\n251#1:444,2\n213#1:436,2\n222#1:438,2\n*E\n"})
public final class Sunburst<T>
extends JComponent {
    private double thickness = 20.0;
    @NotNull
    private SunburstModel<T> model = new SunburstModel.Empty();
    @Nullable
    private T center;
    @Nullable
    private SunburstSection<T> hovered;
    @Nullable
    private Function1<? super SunburstSection<T>, ? extends Color> hiddenItemsColor = arg_0 -> Sunburst.hiddenItemsColor$lambda$0(this, arg_0);
    @NotNull
    private final JBAnimator animator;
    @NotNull
    private final Comparator<SunburstSection<T>> comparator;
    @NotNull
    private Collection<SunburstSection<T>> sections;
    private double adjust;
    @NotNull
    private final Point shift;
    @NotNull
    private BiConsumer<SunburstSection<T>, InputEvent> hover;
    @NotNull
    private BiConsumer<SunburstSection<T>, InputEvent> select;

    /*
     * WARNING - void declaration
     */
    public Sunburst() {
        void $this$animator_u24lambda_u240;
        JBAnimator jBAnimator;
        JBAnimator jBAnimator2 = jBAnimator = new JBAnimator();
        Sunburst sunburst = this;
        boolean bl = false;
        $this$animator_u24lambda_u240.setPeriod(16);
        sunburst.animator = jBAnimator;
        this.comparator = Sunburst::comparator$lambda$0;
        this.sections = new ArrayList();
        this.shift = new Point(0, 0);
        this.hover = (arg_0, arg_1) -> Sunburst.hover$lambda$0(this, arg_0, arg_1);
        this.select = Sunburst::select$lambda$0;
        MouseListener listener2 = new MouseListener();
        this.addMouseMotionListener(listener2);
        this.addMouseListener(listener2);
    }

    public final double getThickness() {
        return this.thickness;
    }

    public final void setThickness(double value) {
        this.thickness = value;
        this.repaint();
    }

    @NotNull
    public final SunburstModel<T> getModel() {
        return this.model;
    }

    public final void setModel(@NotNull SunburstModel<T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.model = value;
        this.setCenter(value.getRoot());
    }

    @Nullable
    public final T getCenter() {
        return this.center;
    }

    public final void setCenter(@Nullable T value) {
        this.center = value;
        this.hovered = null;
        if (this.model instanceof SunburstModel.WithAnimation) {
            this.animate(this.sections, this.generate(this.model, value));
        } else {
            this.sections = this.generate(this.model, value);
            this.fireMouseHoverEvent();
            this.repaint();
        }
    }

    @Nullable
    public final SunburstSection<T> getHovered() {
        return this.hovered;
    }

    public final void setHovered(@Nullable SunburstSection<T> sunburstSection) {
        this.hovered = sunburstSection;
    }

    private final void fireMouseHoverEvent() {
        Point position;
        if (!GraphicsEnvironment.isHeadless() && (position = this.getMousePosition(true)) != null) {
            SunburstSection<T> section = this.findSection(position.x, position.y);
            MouseEvent event = new MouseEvent(this, 503, 0L, 0, position.x, position.y, 0, false);
            this.hover.accept(section, event);
        }
    }

    @TestOnly
    public final void ignorePowerSave() {
        this.animator.ignorePowerSaveMode();
    }

    public final void onHover(@NotNull BiConsumer<SunburstSection<T>, InputEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BiConsumer<SunburstSection<SunburstSection<T>>, InputEvent> biConsumer = this.hover.andThen(consumer);
        Intrinsics.checkNotNullExpressionValue(biConsumer, (String)"andThen(...)");
        this.hover = biConsumer;
    }

    public final void onSelect(@NotNull BiConsumer<SunburstSection<T>, InputEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BiConsumer<SunburstSection<SunburstSection<T>>, InputEvent> biConsumer = this.select.andThen(consumer);
        Intrinsics.checkNotNullExpressionValue(biConsumer, (String)"andThen(...)");
        this.select = biConsumer;
    }

    @Nullable
    public final SunburstSection<T> findSection(int x, int y) {
        Object v0;
        block2: {
            double dX = (double)x - (double)this.getWidth() / 2.0 + (double)this.shift.x;
            double dY = (double)y - (double)this.getHeight() / 2.0 + (double)this.shift.y;
            double radius = Math.sqrt(dX * dX + dY * dY) - this.adjust;
            Ref.DoubleRef angle = new Ref.DoubleRef();
            double d = -dY;
            angle.element = Math.atan2(dX, d);
            if (angle.element < 0.0) {
                angle.element += Math.PI * 2;
            }
            angle.element /= Math.PI * 2;
            Function1 condition = arg_0 -> Sunburst.findSection$lambda$0(angle, this, radius, arg_0);
            Iterable iterable = this.sections;
            for (Object t : iterable) {
                if (!((Boolean)condition.invoke(t)).booleanValue()) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SunburstSection sunburstSection = v0;
        return sunburstSection != null ? this.takeIfVisible(sunburstSection) : null;
    }

    @Nullable
    public final SunburstSection<T> findSection(@Nullable T content) {
        Object v0;
        block2: {
            if (content == null) {
                return null;
            }
            Iterable iterable = this.sections;
            for (Object t : iterable) {
                SunburstSection it = (SunburstSection)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getContent(), content)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SunburstSection sunburstSection = v0;
        return sunburstSection != null ? this.takeIfVisible(sunburstSection) : null;
    }

    private final SunburstSection<T> takeIfVisible(SunburstSection<T> $this$takeIfVisible) {
        SunburstSection<T> sunburstSection;
        SunburstSection<T> it = sunburstSection = $this$takeIfVisible;
        boolean bl = false;
        return SunburstKt.access$createShape(it, this.getWidth() / 2, this.getHeight() / 2, this.thickness, this.adjust) != null ? sunburstSection : null;
    }

    public final void shift(int x, int y) {
        this.shift.x = x;
        this.shift.y = y;
        this.repaint();
    }

    @NotNull
    public final Point shift() {
        return new Point(this.shift.x, this.shift.y);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        Rectangle bounds = g2d.getClipBounds();
        g2d.setPaint(this.getBackground());
        g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        int x = bounds.width / 2 - this.shift.x;
        int y = bounds.height / 2 - this.shift.y;
        if (!this.sections.isEmpty() && this.hiddenItemsColor != null) {
            SortedIterable<SunburstSection<T>> shadows = new SortedIterable<SunburstSection<T>>(this.sections, this.comparator);
            SunburstSection current = null;
            current = new SunburstSection((SunburstSection)CollectionsKt.first((Iterable)shadows));
            Iterable $this$forEach$iv = shadows;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SunburstSection next2 = (SunburstSection)element$iv;
                boolean bl = false;
                if (next2.getStart() - current.getEnd() >= 0.002777777777777778 || current.getDepth() != next2.getDepth()) {
                    Function1<? super SunburstSection<T>, ? extends Color> function1 = this.hiddenItemsColor;
                    this.fillSection((Graphics2D)g, x, y, current.getStart(), current.getEnd(), current.getDepth(), function1 != null ? (Color)function1.invoke(current) : null);
                    current = new SunburstSection(next2);
                }
                current.setEnd(next2.getEnd());
            }
            Function1<? super SunburstSection<T>, ? extends Color> function1 = this.hiddenItemsColor;
            this.fillSection((Graphics2D)g, x, y, current.getStart(), current.getEnd(), current.getDepth(), function1 != null ? (Color)function1.invoke(current) : null);
        }
        Iterable $this$forEach$iv = this.sections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape shape;
            SunburstSection it = (SunburstSection)element$iv;
            boolean bl = false;
            if (SunburstKt.access$createShape(it, x, y, this.thickness, this.adjust) == null) continue;
            Color color = it.getColor();
            g2d.setColor(this.hovered == it ? ColorUtil.mix((Color)color, (Color)Color.BLACK, (double)0.05) : color);
            g2d.fill(shape);
        }
    }

    private final void fillSection(Graphics2D g, int x, int y, double from, double to, int depth, Color color) {
        Color color2 = color;
        if (color2 == null) {
            color2 = Color.GRAY;
        }
        Color color3 = color2;
        Intrinsics.checkNotNull((Object)color3);
        Shape stub = SunburstKt.access$createShape(new SunburstSection<Object>(null, from, to, depth, color3), x, y, this.thickness, this.adjust);
        if (stub != null) {
            if (color != null) {
                g.setColor(color);
            }
            g.fill(stub);
        }
    }

    static /* synthetic */ void fillSection$default(Sunburst sunburst, Graphics2D graphics2D, int n, int n2, double d, double d2, int n3, Color color, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            color = null;
        }
        sunburst.fillSection(graphics2D, n, n2, d, d2, n3, color);
    }

    /*
     * WARNING - void declaration
     */
    private final void animate(Collection<SunburstSection<T>> source, Collection<SunburstSection<T>> target) {
        void $this$animate_u24lambda_u2410;
        Animation animation;
        SunburstSection section;
        Object k;
        Object content;
        Object element$iv;
        EDT.assertIsEdt();
        SunburstModel<T> sunburstModel = this.model;
        SunburstModel.WithAnimation withAnimation = sunburstModel instanceof SunburstModel.WithAnimation ? (SunburstModel.WithAnimation)sunburstModel : null;
        if (withAnimation == null) {
            throw new IllegalStateException();
        }
        SunburstModel.WithAnimation model2 = withAnimation;
        SunburstSection<T> oldRoot = this.getRootSection(source);
        SunburstSection<T> newRoot = this.getRootSection(target);
        int distance = oldRoot != null && newRoot != null ? model2.getDistance(oldRoot.getContent(), newRoot.getContent()) : 0;
        Map map = CollectionFactory.createSmallMemoryFootprintMap((int)source.size());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSmallMemoryFootprintMap(...)");
        Map sourceMap = map;
        Iterable $this$forEach$iv = source;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            SunburstSection it = (SunburstSection)element$iv2;
            boolean bl = false;
            sourceMap.put(it.getContent(), it);
        }
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap((int)target.size());
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        Map targetMap = map2;
        Iterable $this$forEach$iv2 = target;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            SunburstSection it = (SunburstSection)element$iv3;
            boolean bl = false;
            targetMap.put(it.getContent(), it);
        }
        Set set = CollectionFactory.createSmallMemoryFootprintSet((Collection)sourceMap.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        Set sameSet = set;
        sameSet.retainAll(targetMap.keySet());
        SunburstSection<T> sunburstSection = newRoot;
        SunburstSection oldNewRoot = (SunburstSection)sourceMap.get(sunburstSection != null ? sunburstSection.getContent() : null);
        SunburstSection<T> sunburstSection2 = oldRoot;
        SunburstSection newOldRoot = (SunburstSection)targetMap.get(sunburstSection2 != null ? sunburstSection2.getContent() : null);
        List animations = new ArrayList();
        Object $this$forEach$iv22 = sameSet;
        boolean $i$f$forEach3 = false;
        Animation animation2 = $this$forEach$iv22.iterator();
        while (animation2.hasNext()) {
            SunburstSection to;
            SunburstSection from;
            content = element$iv = animation2.next();
            boolean bl = false;
            if ((SunburstSection)sourceMap.get(content) == null) {
                throw new IllegalStateException(("can't find value " + content).toString());
            }
            if ((SunburstSection)targetMap.get(content) == null) {
                throw new IllegalStateException(("can't find value " + content).toString());
            }
            animations.add(Sunburst.animate$animation(from.getStart(), to.getStart(), arg_0 -> Sunburst.animate$lambda$3$0(from, arg_0)));
            animations.add(Sunburst.animate$animation(from.getEnd(), to.getEnd(), arg_0 -> Sunburst.animate$lambda$3$1(from, arg_0)));
        }
        if (oldNewRoot != null) {
            $this$forEach$iv22 = sourceMap;
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.entrySet().iterator();
            while (animation2.hasNext()) {
                content = element$iv = (Map.Entry)animation2.next();
                boolean bl = false;
                k = content.getKey();
                section = (SunburstSection)content.getValue();
                if (sameSet.contains(k)) continue;
                animations.add(Sunburst.animate$animation(section.getStart(), section.getStart() <= oldNewRoot.getStart() ? 0.0 : 1.0, arg_0 -> Sunburst.animate$lambda$4$0(section, arg_0)));
                animations.add(Sunburst.animate$animation(section.getEnd(), section.getEnd() < oldNewRoot.getEnd() ? 0.0 : 1.0, arg_0 -> Sunburst.animate$lambda$4$1(section, arg_0)));
            }
        }
        if (newOldRoot != null) {
            $this$forEach$iv22 = targetMap;
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.entrySet().iterator();
            while (animation2.hasNext()) {
                content = element$iv = (Map.Entry)animation2.next();
                boolean bl = false;
                k = content.getKey();
                section = (SunburstSection)content.getValue();
                if (sameSet.contains(k)) continue;
                double start = section.getStart() <= newOldRoot.getStart() ? 0.0 : 1.0;
                double end = section.getEnd() < newOldRoot.getEnd() ? 0.0 : 1.0;
                SunburstSection fake = new SunburstSection(section.getContent(), start, end, section.getDepth() + distance, section.getColor());
                Collection<SunburstSection<T>> collection = this.sections;
                Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableCollection<com.intellij.profiler.ui.sunburst.SunburstSection<T of com.intellij.profiler.ui.sunburst.Sunburst>>");
                TypeIntrinsics.asMutableCollection(collection).add(fake);
                animations.add(Sunburst.animate$animation(fake.getStart(), section.getStart(), arg_0 -> Sunburst.animate$lambda$5$0(fake, arg_0)));
                animations.add(Sunburst.animate$animation(fake.getEnd(), section.getEnd(), arg_0 -> Sunburst.animate$lambda$5$1(fake, arg_0)));
            }
        }
        if (newOldRoot == null && oldNewRoot == null) {
            SunburstSection section2;
            boolean $this$forEach$iv3 = sameSet.isEmpty();
            if (_Assertions.ENABLED && !$this$forEach$iv3) {
                String $i$f$forEach4 = "Assertion failed";
                throw new AssertionError((Object)$i$f$forEach4);
            }
            $this$forEach$iv22 = sourceMap.values();
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.iterator();
            while (animation2.hasNext()) {
                element$iv = animation2.next();
                section2 = (SunburstSection)element$iv;
                boolean bl = false;
                animations.add(Sunburst.animate$animation(section2.getStart(), 1.0, arg_0 -> Sunburst.animate$lambda$6$0(section2, arg_0)));
                animations.add(Sunburst.animate$animation(section2.getEnd(), 1.0, arg_0 -> Sunburst.animate$lambda$6$1(section2, arg_0)));
            }
            $this$forEach$iv22 = targetMap.values();
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.iterator();
            while (animation2.hasNext()) {
                element$iv = animation2.next();
                section2 = (SunburstSection)element$iv;
                boolean bl = false;
                SunburstSection fake = new SunburstSection(section2.getContent(), 0.0, 0.0, section2.getDepth(), section2.getColor());
                Collection<SunburstSection<T>> collection = this.sections;
                Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableCollection<com.intellij.profiler.ui.sunburst.SunburstSection<T of com.intellij.profiler.ui.sunburst.Sunburst>>");
                TypeIntrinsics.asMutableCollection(collection).add(fake);
                animations.add(Sunburst.animate$animation(fake.getStart(), section2.getStart(), arg_0 -> Sunburst.animate$lambda$7$0(fake, arg_0)));
                animations.add(Sunburst.animate$animation(fake.getEnd(), section2.getEnd(), arg_0 -> Sunburst.animate$lambda$7$1(fake, arg_0)));
            }
        } else {
            animations.add(Sunburst.animate$animation(this.adjust, (double)(-distance) * this.thickness, arg_0 -> Sunburst.animate$lambda$8(this, arg_0)));
        }
        Animation[] animationArray = new Animation[1];
        animation2 = animation = new Animation(arg_0 -> Sunburst.animate$lambda$9(animations, arg_0));
        int n = 0;
        Animation[] animationArray2 = animationArray;
        JBAnimator jBAnimator = this.animator;
        boolean bl = false;
        $this$animate_u24lambda_u2410.setDuration(500);
        $this$animate_u24lambda_u2410.setEasing(Sunburst::animate$lambda$10$0);
        $this$animate_u24lambda_u2410.runWhenUpdated(() -> Sunburst.animate$lambda$10$1(this));
        $this$animate_u24lambda_u2410.runWhenExpired(() -> Sunburst.animate$lambda$10$2(this, target));
        Unit unit = Unit.INSTANCE;
        animationArray2[n] = animation;
        jBAnimator.animate(animationArray);
    }

    private final Collection<SunburstSection<T>> generate(SunburstModel<T> model2, T root) {
        List result2 = new ArrayList();
        if (root == null) {
            return result2;
        }
        result2.add(new SunburstSection<T>(root, 0.0, 1.0, 0, model2.getColor(root)));
        SunburstKt.access$generate0(model2, result2, root, 0.0, 1.0, 1);
        CollectionsKt.sortWith((List)result2, this.comparator);
        return result2;
    }

    static /* synthetic */ Collection generate$default(Sunburst sunburst, SunburstModel sunburstModel, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = sunburstModel.getRoot();
        }
        return sunburst.generate(sunburstModel, object);
    }

    private final SunburstSection<T> getRootSection(Collection<SunburstSection<T>> $this$getRootSection) {
        Object v0;
        block1: {
            Iterable iterable = $this$getRootSection;
            for (Object t : iterable) {
                SunburstSection it = (SunburstSection)t;
                boolean bl = false;
                if (!(it.getDepth() == 0)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Color hiddenItemsColor$lambda$0$0(Sunburst this$0, SunburstSection $base) {
        double proportion = ColorUtil.isDark((Color)this$0.getBackground()) ? 0.9 : 0.8;
        return ColorUtil.mix((Color)$base.getColor(), (Color)this$0.getBackground(), (double)proportion);
    }

    private static final Color hiddenItemsColor$lambda$0(Sunburst this$0, SunburstSection base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        JBColor jBColor = JBColor.lazy(() -> Sunburst.hiddenItemsColor$lambda$0$0(this$0, base));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        return (Color)jBColor;
    }

    private static final int comparator$lambda$0(SunburstSection o1, SunburstSection o2) {
        int byDepth = Intrinsics.compare((int)o1.getDepth(), (int)o2.getDepth());
        return byDepth != 0 ? byDepth : Double.compare(o1.getStart(), o2.getStart());
    }

    private static final void hover$lambda$0(Sunburst this$0, SunburstSection hover, InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"<unused var>");
        this$0.hovered = hover;
        this$0.repaint();
    }

    private static final void select$lambda$0(SunburstSection sunburstSection, InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)sunburstSection, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"<unused var>");
    }

    private static final boolean findSection$lambda$0(Ref.DoubleRef $angle, Sunburst this$0, double $radius, SunburstSection s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s.getStart() <= $angle.element && $angle.element <= s.getEnd() && (double)s.getDepth() * this$0.thickness <= $radius && $radius <= (double)(s.getDepth() + 1) * this$0.thickness;
    }

    private static final void animate$animation$lambda$2(DoubleConsumer $consumer, double $from, double $to, double value) {
        $consumer.accept($from + value * ($to - $from));
    }

    private static final void animate$lambda$3$0(SunburstSection $from, double it) {
        $from.setStart(it);
    }

    private static final void animate$lambda$3$1(SunburstSection $from, double it) {
        $from.setEnd(it);
    }

    private static final void animate$lambda$4$0(SunburstSection $section, double it) {
        $section.setStart(it);
    }

    private static final void animate$lambda$4$1(SunburstSection $section, double it) {
        $section.setEnd(it);
    }

    private static final void animate$lambda$5$0(SunburstSection $fake, double it) {
        $fake.setStart(it);
    }

    private static final void animate$lambda$5$1(SunburstSection $fake, double it) {
        $fake.setEnd(it);
    }

    private static final void animate$lambda$6$0(SunburstSection $section, double it) {
        $section.setStart(it);
    }

    private static final void animate$lambda$6$1(SunburstSection $section, double it) {
        $section.setEnd(it);
    }

    private static final void animate$lambda$7$0(SunburstSection $fake, double it) {
        $fake.setStart(it);
    }

    private static final void animate$lambda$7$1(SunburstSection $fake, double it) {
        $fake.setEnd(it);
    }

    private static final double animate$lambda$10$0(double x) {
        return Math.sqrt(1.0 - Math.pow(1.0 - x, 3.0));
    }

    private static final void animate$lambda$10$1(Sunburst this$0) {
        this$0.repaint();
    }

    private static final void animate$lambda$10$2(Sunburst this$0, Collection $target) {
        this$0.sections = $target;
        this$0.adjust = 0.0;
        this$0.fireMouseHoverEvent();
        this$0.repaint();
    }

    private static final DoubleConsumer animate$animation(double from, double to, DoubleConsumer consumer) {
        return arg_0 -> Sunburst.animate$animation$lambda$2(consumer, from, to, arg_0);
    }

    private static final void animate$lambda$8(Sunburst this$0, double it) {
        this$0.adjust = it;
    }

    private static final void animate$lambda$9(List $animations, double value) {
        Iterable $this$forEach$iv = $animations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DoubleConsumer it = (DoubleConsumer)element$iv;
            boolean bl = false;
            it.accept(value);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst$MouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/intellij/profiler/ui/sunburst/Sunburst;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseMoved", "mouseExited", "intellij.profiler.common"})
    private final class MouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getButton() != 1 || e.isConsumed()) {
                return;
            }
            SunburstSection section = Sunburst.this.findSection(e.getX(), e.getY());
            if (section != null) {
                Sunburst.this.select.accept(section, e);
                e.consume();
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Sunburst.this.hover.accept(Sunburst.this.findSection(e.getX(), e.getY()), e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Sunburst.this.hover.accept(null, e);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\r\u0012\t\u0012\u00078\u0001\u00a2\u0006\u0002\b\u000f0\u000eH\u0096\u0082\u0004R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u000bj\b\u0012\u0004\u0012\u00028\u0001`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst$SortedIterable;", "T", "", "collection", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Ljava/util/Collection;Ljava/util/Comparator;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "iterator", "", "Lkotlin/jvm/internal/EnhancedNullability;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nSunburst.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst$SortedIterable\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,424:1\n1253#2,2:425\n*S KotlinDebug\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst$SortedIterable\n*L\n303#1:425,2\n*E\n"})
    private static final class SortedIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        @NotNull
        private final ArrayList<T> data;

        public SortedIterable(@NotNull Collection<? extends T> collection, @NotNull Comparator<T> comparator) {
            boolean isSorted;
            block2: {
                boolean bl;
                Intrinsics.checkNotNullParameter(collection, (String)"collection");
                Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
                this.data = new ArrayList<T>(collection);
                Sequence $this$all$iv = SequencesKt.zipWithNext((Sequence)CollectionsKt.asSequence((Iterable)this.data));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    Object next2;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    Object prev2 = pair.component1();
                    if (comparator.compare(prev2, next2 = pair.component2()) <= 0) continue;
                    bl = false;
                    break block2;
                }
                bl = isSorted = true;
            }
            if (!isSorted) {
                CollectionsKt.sortWith((List)this.data, comparator);
            }
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator<T> iterator2 = this.data.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            return iterator2;
        }
    }
}

